/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.ptb;

import java.io.IOException;
import java.io.InputStream;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGInputStreamBase;
import org.herac.tuxguitar.io.ptb.PTSongParser;
import org.herac.tuxguitar.io.ptb.base.PTBar;
import org.herac.tuxguitar.io.ptb.base.PTBeat;
import org.herac.tuxguitar.io.ptb.base.PTDirection;
import org.herac.tuxguitar.io.ptb.base.PTGuitarIn;
import org.herac.tuxguitar.io.ptb.base.PTNote;
import org.herac.tuxguitar.io.ptb.base.PTSection;
import org.herac.tuxguitar.io.ptb.base.PTSong;
import org.herac.tuxguitar.io.ptb.base.PTSymbol;
import org.herac.tuxguitar.io.ptb.base.PTTempo;
import org.herac.tuxguitar.io.ptb.base.PTTrack;
import org.herac.tuxguitar.io.ptb.base.PTTrackInfo;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGSong;

public class PTInputStream
implements TGInputStreamBase {
    private static final String PTB_VERSION = "ptab-4";
    private InputStream stream;
    private String version;
    private PTSong song;
    private PTSongParser parser;

    public void init(TGFactory tGFactory, InputStream inputStream) {
        this.version = null;
        this.stream = inputStream;
        this.parser = new PTSongParser(tGFactory);
    }

    public TGFileFormat getFileFormat() {
        return new TGFileFormat("PowerTab", "*.ptb");
    }

    public boolean isSupportedVersion(String string) {
        return string.equals(PTB_VERSION);
    }

    public boolean isSupportedVersion() {
        try {
            this.readVersion();
            return this.isSupportedVersion(this.version);
        }
        catch (Exception exception) {
            return false;
        }
        catch (Error error) {
            return false;
        }
    }

    private void readVersion() {
        if (this.version == null) {
            this.version = this.readString(4) + "-" + this.readShort();
        }
    }

    public TGSong readSong() throws IOException {
        this.readVersion();
        if (!this.isSupportedVersion(this.version)) {
            throw new IOException("Unsupported Version");
        }
        this.song = new PTSong();
        this.readSongInfo();
        this.readDataInstruments(this.song.getTrack1());
        this.readDataInstruments(this.song.getTrack2());
        this.close();
        return this.parser.parseSong(this.song);
    }

    private void readSongInfo() {
        this.song.getInfo().setClassification(this.readByte());
        if (this.song.getInfo().getClassification() == 0) {
            this.skip(1);
            this.song.getInfo().setName(this.readString());
            this.song.getInfo().setInterpret(this.readString());
            this.song.getInfo().setReleaseType(this.readByte());
            if (this.song.getInfo().getReleaseType() == 0) {
                this.song.getInfo().setAlbumType(this.readByte());
                this.song.getInfo().setAlbum(this.readString());
                this.song.getInfo().setYear(this.readShort());
                this.song.getInfo().setLiveRecording(this.readBoolean());
            } else if (this.song.getInfo().getReleaseType() == 1) {
                this.song.getInfo().setAlbum(this.readString());
                this.song.getInfo().setLiveRecording(this.readBoolean());
            } else if (this.song.getInfo().getReleaseType() == 2) {
                this.song.getInfo().setAlbum(this.readString());
                this.song.getInfo().setDay(this.readShort());
                this.song.getInfo().setMonth(this.readShort());
                this.song.getInfo().setYear(this.readShort());
            }
            if (this.readByte() == 0) {
                this.song.getInfo().setAuthor(this.readString());
                this.song.getInfo().setLyricist(this.readString());
            }
            this.song.getInfo().setArrenger(this.readString());
            this.song.getInfo().setGuitarTranscriber(this.readString());
            this.song.getInfo().setBassTranscriber(this.readString());
            this.song.getInfo().setCopyright(this.readString());
            this.song.getInfo().setLyrics(this.readString());
            this.song.getInfo().setGuitarInstructions(this.readString());
            this.song.getInfo().setBassInstructions(this.readString());
        } else if (this.song.getInfo().getClassification() == 1) {
            this.song.getInfo().setName(this.readString());
            this.song.getInfo().setAlbum(this.readString());
            this.song.getInfo().setStyle(this.readShort());
            this.song.getInfo().setLevel(this.readByte());
            this.song.getInfo().setAuthor(this.readString());
            this.song.getInfo().setInstructions(this.readString());
            this.song.getInfo().setCopyright(this.readString());
        }
    }

    private void readDataInstruments(PTTrack pTTrack) {
        int n;
        int n2 = this.readHeaderItems();
        for (n = 0; n < n2; ++n) {
            this.readTrackInfo(pTTrack);
            if (n >= n2 - 1) continue;
            this.readShort();
        }
        n2 = this.readHeaderItems();
        for (n = 0; n < n2; ++n) {
            this.readChord();
            if (n >= n2 - 1) continue;
            this.readShort();
        }
        n2 = this.readHeaderItems();
        for (n = 0; n < n2; ++n) {
            this.readFloattingText();
            if (n >= n2 - 1) continue;
            this.readShort();
        }
        n2 = this.readHeaderItems();
        for (n = 0; n < n2; ++n) {
            this.readGuitarIn(pTTrack);
            if (n >= n2 - 1) continue;
            this.readShort();
        }
        n2 = this.readHeaderItems();
        for (n = 0; n < n2; ++n) {
            this.readTempoMarker(pTTrack);
            if (n >= n2 - 1) continue;
            this.readShort();
        }
        n2 = this.readHeaderItems();
        for (n = 0; n < n2; ++n) {
            this.readDynamic();
            if (n >= n2 - 1) continue;
            this.readShort();
        }
        n2 = this.readHeaderItems();
        for (n = 0; n < n2; ++n) {
            this.readSectionSymbol(pTTrack);
            if (n >= n2 - 1) continue;
            this.readShort();
        }
        n2 = this.readHeaderItems();
        for (n = 0; n < n2; ++n) {
            this.readSection(pTTrack.getSection(n));
            if (n >= n2 - 1) continue;
            this.readShort();
        }
    }

    private void readTrackInfo(PTTrack pTTrack) {
        PTTrackInfo pTTrackInfo = new PTTrackInfo();
        pTTrackInfo.setNumber(this.readByte());
        pTTrackInfo.setName(this.readString());
        pTTrackInfo.setInstrument((short)this.readByte());
        pTTrackInfo.setVolume((short)this.readByte());
        pTTrackInfo.setBalance((short)this.readByte());
        pTTrackInfo.setReverb((short)this.readByte());
        pTTrackInfo.setChorus((short)this.readByte());
        pTTrackInfo.setTremolo((short)this.readByte());
        pTTrackInfo.setPhaser((short)this.readByte());
        this.readByte();
        this.readString();
        this.readByte();
        int[] nArray = new int[this.readByte() & 0xFF];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.readByte();
        }
        pTTrackInfo.setStrings(nArray);
        pTTrack.getInfos().add(pTTrackInfo);
    }

    private void readSection(PTSection pTSection) {
        int n;
        this.readInt();
        this.readInt();
        this.readInt();
        this.readInt();
        int n2 = this.readByte();
        this.readByte();
        this.readByte();
        this.readByte();
        this.readByte();
        this.readBarLine(pTSection);
        int n3 = this.readHeaderItems();
        for (n = 0; n < n3; ++n) {
            this.readDirection(pTSection);
            if (n >= n3 - 1) continue;
            this.readShort();
        }
        n3 = this.readHeaderItems();
        for (n = 0; n < n3; ++n) {
            this.readChordText();
            if (n >= n3 - 1) continue;
            this.readShort();
        }
        n3 = this.readHeaderItems();
        for (n = 0; n < n3; ++n) {
            this.readRhythmSlash();
            if (n >= n3 - 1) continue;
            this.readShort();
        }
        pTSection.setStaffs(this.readHeaderItems());
        for (n = 0; n < pTSection.getStaffs(); ++n) {
            this.readStaff(n, pTSection);
            if (n >= pTSection.getStaffs() - 1) continue;
            this.readShort();
        }
        n3 = this.readHeaderItems();
        for (n = 0; n < n3; ++n) {
            this.readBarLine(pTSection);
            if (n >= n3 - 1) continue;
            this.readShort();
        }
        PTBar pTBar = new PTBar();
        pTBar.setRepeatClose(n2 >>> 5 == 4 ? n2 - 128 : 0);
        pTSection.getPosition(pTSection.getNextPositionNumber()).addComponent(pTBar);
    }

    private void readStaff(int n, PTSection pTSection) {
        this.readByte();
        this.readByte();
        this.readByte();
        this.readByte();
        this.readByte();
        for (int i = 0; i < 2; ++i) {
            int n2 = this.readHeaderItems();
            for (int j = 0; j < n2; ++j) {
                this.readPosition(n, i, pTSection);
                if (j >= n2 - 1) continue;
                this.readShort();
            }
        }
    }

    private void readPosition(int n, int n2, PTSection pTSection) {
        int n3;
        int n4;
        PTBeat pTBeat = new PTBeat(n, n2);
        int n5 = this.readByte();
        int n6 = this.readByte();
        n6 = n6 - 128 < 0 ? n6 : n6 - 128;
        this.readByte();
        int n7 = this.readByte();
        this.readByte();
        int n8 = this.readByte();
        int n9 = this.readByte();
        int n10 = 1;
        int n11 = this.readByte();
        for (n4 = 0; n4 < n11; ++n4) {
            n3 = this.readShort();
            this.readByte();
            int n12 = this.readByte();
            if ((n12 & 8) == 0) continue;
            n10 = n3;
        }
        n4 = this.readHeaderItems();
        for (n3 = 0; n3 < n4; ++n3) {
            this.readNote(pTBeat);
            if (n3 >= n4 - 1) continue;
            this.readShort();
        }
        pTBeat.setMultiBarRest(n4 == 0 ? n10 : 1);
        pTBeat.setVibrato((n7 & 8) != 0 || (n7 & 0x10) != 0);
        pTBeat.setGrace((n8 & 1) != 0);
        pTBeat.setDuration(n9);
        pTBeat.setDotted((n7 & 1) != 0);
        pTBeat.setDoubleDotted((n7 & 2) != 0);
        pTBeat.setArpeggioUp((n7 & 0x20) != 0);
        pTBeat.setArpeggioDown((n7 & 0x40) != 0);
        pTBeat.setEnters((n6 - n6 % 8) / 8 + 1);
        pTBeat.setTimes(n6 % 8 + 1);
        pTSection.getPosition(n5).addComponent(pTBeat);
    }

    private void readNote(PTBeat pTBeat) {
        PTNote pTNote = new PTNote();
        int n = this.readByte();
        int n2 = this.readShort();
        int n3 = this.readByte();
        for (int i = 0; i < n3; ++i) {
            this.readByte();
            this.readByte();
            int n4 = this.readByte();
            int n5 = this.readByte();
            pTNote.setBend(n5 == 101 ? n4 / 16 + 1 : 0);
            pTNote.setSlide(n5 == 100);
        }
        pTNote.setValue(n & 0x1F);
        pTNote.setString(((n & 0xE0) >> 5) + 1);
        pTNote.setTied((n2 & 1) != 0);
        pTNote.setDead((n2 & 2) != 0);
        pTBeat.addNote(pTNote);
    }

    private void readTimeSignature(PTBar pTBar) {
        int n = this.readInt();
        this.readByte();
        pTBar.setNumerator(((n >> 24) - (n >> 24) % 8) / 8 + 1);
        pTBar.setDenominator((int)Math.pow(2.0, (n >> 24) % 8));
    }

    private void readKeySignature() {
        this.readByte();
    }

    private void readBarLine(PTSection pTSection) {
        PTBar pTBar = new PTBar();
        int n = this.readByte();
        int n2 = this.readByte();
        pTBar.setRepeatStart(n2 >>> 5 == 3);
        pTBar.setRepeatClose(n2 >>> 5 == 4 ? n2 - 128 : 0);
        this.readKeySignature();
        this.readTimeSignature(pTBar);
        this.readRehearsalSign();
        pTSection.getPosition(n).addComponent(pTBar);
    }

    private void readChord() {
        this.readShort();
        this.readByte();
        this.readShort();
        this.readByte();
        this.readByte();
        int n = this.readByte();
        for (int i = 0; i < n; ++i) {
            this.readByte();
        }
    }

    private void readFloattingText() {
        this.readString();
        this.readInt();
        this.readInt();
        this.readInt();
        this.readInt();
        this.readByte();
        this.readFontSetting();
    }

    private void readFontSetting() {
        this.readString();
        this.readInt();
        this.readInt();
        this.readBoolean();
        this.readBoolean();
        this.readBoolean();
        this.readInt();
    }

    private void readGuitarIn(PTTrack pTTrack) {
        int n = this.readShort();
        int n2 = this.readByte();
        int n3 = this.readByte();
        this.skip(1);
        int n4 = this.readByte() & 0xFF;
        pTTrack.getSection(n).getPosition(n3).addComponent(new PTGuitarIn(n2, n4));
    }

    private void readTempoMarker(PTTrack pTTrack) {
        int n = this.readShort();
        int n2 = this.readByte();
        int n3 = this.readShort();
        int n4 = this.readShort();
        this.readString();
        int n5 = 1;
        if ((n4 & 1) != 0) {
            n5 = 2;
        } else if ((n4 & 2) != 0) {
            n5 = 3;
        }
        if (n3 > 0) {
            pTTrack.getSection(n).getPosition(n2).addComponent(new PTTempo(n3, n5));
        }
    }

    private void readSectionSymbol(PTTrack pTTrack) {
        int n = this.readShort();
        int n2 = this.readByte();
        int n3 = this.readInt();
        PTSymbol pTSymbol = new PTSymbol();
        pTSymbol.setEndNumber(n3 >> 16);
        pTTrack.getSection(n).getPosition(n2).addComponent(pTSymbol);
    }

    private void readDynamic() {
        this.readShort();
        this.readByte();
        this.readByte();
        this.readShort();
    }

    private void readRehearsalSign() {
        this.readByte();
        this.readString();
    }

    private void readDirection(PTSection pTSection) {
        int n = this.readByte();
        int n2 = this.readByte();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.readShort();
            pTSection.getPosition(n).addComponent(new PTDirection(n3 >> 8, (n3 & 0xC0) >> 6, n3 & 0x1F));
        }
    }

    private void readChordText() {
        this.readByte();
        this.readShort();
        this.readByte();
        this.readShort();
        this.readByte();
    }

    private void readRhythmSlash() {
        this.readByte();
        this.readByte();
        this.readInt();
    }

    private int readHeaderItems() {
        int n;
        int n2 = this.readShort();
        if (n2 != 0 && (n = this.readShort()) == 65535) {
            if (this.readShort() != 1) {
                return -1;
            }
            this.readString(this.readShort());
        }
        return n2;
    }

    private String readString() {
        try {
            int n = this.stream.read() & 0xFF;
            return this.readString(n < 255 ? n : this.readShort());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private String readString(int n) {
        try {
            byte[] byArray = new byte[n];
            this.stream.read(byArray);
            return new String(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private int readInt() {
        try {
            byte[] byArray = new byte[4];
            this.stream.read(byArray);
            return (byArray[3] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    private int readShort() {
        try {
            byte[] byArray = new byte[]{0, 0};
            this.stream.read(byArray);
            return (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    private boolean readBoolean() {
        try {
            return this.stream.read() > 0;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    private int readByte() {
        try {
            return this.stream.read();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    private void skip(int n) {
        try {
            this.stream.read(new byte[n]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void close() {
        try {
            this.stream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

