/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tools.custom.tuner;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.herac.tuxguitar.gui.tools.custom.tuner.TGTunerListener;
import org.herac.tuxguitar.gui.tools.custom.tuner.TGTunerRoughWidget;

public class TGTuningString {
    private int string;
    private Button stringButton = null;
    private TGTunerListener listener = null;

    TGTuningString(int n, Composite composite, TGTunerListener tGTunerListener) {
        this.string = n;
        this.listener = tGTunerListener;
        this.stringButton = new Button(composite, 2);
        this.stringButton.setText("--------- " + TGTunerRoughWidget.TONESSTRING[n % 12] + (int)Math.floor(n / 12) + " ---------");
    }

    void addListener() {
        this.stringButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGTuningString.this.stringButton.setSelection(true);
                TGTuningString.this.listener.fireCurrentString(TGTuningString.this.string);
            }
        });
    }

    public int getString() {
        return this.string;
    }

    public Button getStringButton() {
        return this.stringButton;
    }
}

