/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tools.custom.tuner;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tools.custom.tuner.TGTuner;
import org.herac.tuxguitar.gui.tools.custom.tuner.TGTunerFineWidget;
import org.herac.tuxguitar.gui.tools.custom.tuner.TGTunerListener;
import org.herac.tuxguitar.gui.tools.custom.tuner.TGTunerRoughWidget;
import org.herac.tuxguitar.gui.tools.custom.tuner.TGTunerSettingsDialog;
import org.herac.tuxguitar.gui.tools.custom.tuner.TGTuningString;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.util.TGSynchronizer;

public class TGTunerDialog
implements TGTunerListener {
    private static final int SHELL_WIDTH = 400;
    protected TGTuner tuner = null;
    protected int[] tuning = null;
    protected Label currentFrequency = null;
    protected Shell dialog = null;
    protected TGTunerRoughWidget roughTuner = null;
    protected ArrayList allStringButtons = null;
    protected TGTunerFineWidget fineTuner = null;

    TGTunerDialog(int[] nArray) {
        this.tuning = nArray;
    }

    public void show() {
        this.dialog = DialogUtils.newDialog((Shell)TuxGuitar.instance().getShell(), (int)2160);
        this.dialog.setLayout((Layout)new GridLayout());
        this.dialog.setImage(TuxGuitar.instance().getIconManager().getAppIcon());
        this.dialog.setText(TuxGuitar.getProperty((String)"tuner.instrument-tuner"));
        this.dialog.setMinimumSize(400, -1);
        this.dialog.setSize(700, 400);
        Group group = new Group((Composite)this.dialog, 16);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty((String)"tuner.tuner"));
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.allStringButtons = new ArrayList(this.tuning.length);
        this.fineTuner = new TGTunerFineWidget(composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        for (int i = 0; i < this.tuning.length; ++i) {
            this.createTuningString(this.tuning[i], composite2);
        }
        Composite composite3 = new Composite((Composite)group, 0);
        composite3.setLayout((Layout)new GridLayout(1, false));
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        this.currentFrequency = new Label(composite3, 16384);
        this.currentFrequency.setLayoutData((Object)new GridData(4, 4, true, true));
        this.roughTuner = new TGTunerRoughWidget((Composite)group);
        Composite composite4 = new Composite((Composite)group, 0);
        composite4.setLayout((Layout)new GridLayout(2, false));
        composite4.setLayoutData((Object)new GridData(4, 4, true, true));
        Button button = new Button(composite4, 8);
        button.setText(TuxGuitar.getProperty((String)"settings"));
        button.setLayoutData((Object)TGTunerDialog.getGridData(80, 25));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGTunerDialog.this.getTuner().pause();
                new TGTunerSettingsDialog(TGTunerDialog.this).show();
            }
        });
        Button button2 = new Button(composite4, 8);
        button2.setText(TuxGuitar.getProperty((String)"close"));
        button2.setLayoutData((Object)TGTunerDialog.getGridData(80, 25));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGTunerDialog.this.getTuner().setCanceled(true);
                TGTunerDialog.this.dialog.dispose();
            }
        });
        this.dialog.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                TGTunerDialog.this.getTuner().setCanceled(true);
                TGTunerDialog.this.dialog.dispose();
            }
        });
        DialogUtils.openDialog((Shell)this.dialog, (int)10);
        this.tuner = new TGTuner(this);
        this.getTuner().start();
    }

    static GridData getGridData(int n, int n2) {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = n;
        gridData.minimumHeight = n2;
        return gridData;
    }

    public void fireFrequency(final double d) {
        if (!this.dialog.isDisposed()) {
            try {
                TGSynchronizer.instance().addRunnable(new TGSynchronizer.TGRunnable(){

                    public void run() {
                        if (!TGTunerDialog.this.dialog.isDisposed() && !TGTunerDialog.this.roughTuner.isDisposed()) {
                            TGTunerDialog.this.currentFrequency.setText(Math.floor(d) + " Hz");
                            TGTunerDialog.this.roughTuner.setCurrentFrequency(d);
                        }
                        if (!TGTunerDialog.this.dialog.isDisposed() && !TGTunerDialog.this.fineTuner.isDisposed()) {
                            TGTunerDialog.this.fineTuner.setCurrentFrequency(d);
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public TGTuner getTuner() {
        return this.tuner;
    }

    public int[] getTuning() {
        return this.tuning;
    }

    public void fireException(final Exception exception) {
        try {
            TGSynchronizer.instance().addRunnable(new TGSynchronizer.TGRunnable(){

                public void run() {
                    if (!TGTunerDialog.this.dialog.isDisposed()) {
                        MessageDialog.errorMessage((Throwable)exception);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void fireCurrentString(int n) {
        this.tuner.pause();
        if (n == 0) {
            this.tuner.setWantedRange();
            this.fineTuner.setEnabled(false);
        } else {
            this.tuner.setWantedNote(n);
            this.fineTuner.setWantedTone(n);
        }
        this.tuner.resumeFromPause();
    }

    protected void createTuningString(int n, Composite composite) {
        TGTuningString tGTuningString = new TGTuningString(n, composite, this);
        this.allStringButtons.add(tGTuningString);
        tGTuningString.getStringButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGTunerDialog.this.fineTuner.setCurrentFrequency(-1.0);
                Iterator iterator = TGTunerDialog.this.allStringButtons.iterator();
                while (iterator.hasNext()) {
                    TGTuningString tGTuningString = (TGTuningString)iterator.next();
                    tGTuningString.getStringButton().setSelection(false);
                }
            }
        });
        tGTuningString.addListener();
    }
}

