/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tools.custom.tuner;

import craigl.spectrumanalyzer.FFT;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import org.herac.tuxguitar.gui.tools.custom.tuner.TGTunerListener;
import org.herac.tuxguitar.gui.tools.custom.tuner.TGTunerQueue;
import org.herac.tuxguitar.gui.tools.custom.tuner.TGTunerSettings;

public class TGTuner
extends Thread {
    protected TGTunerListener mainWindow = null;
    protected boolean canceled;
    protected boolean paused;
    protected TGTunerSettings settings;
    protected TargetDataLine dataLine;
    protected TGTunerQueue queue;
    protected FFT fft;
    protected double[] ar;
    protected double[] ai;
    protected byte[] data;
    protected double rate;
    protected double maximumFrequency;
    protected double minimumFrequency;

    TGTuner(TGTunerListener tGTunerListener) {
        this.mainWindow = tGTunerListener;
        this.canceled = false;
        this.paused = false;
        this.queue = new TGTunerQueue();
        try {
            this.settings = TGTunerSettings.loadTuxGuitarSettings();
            this.dataLine = TGTunerSettings.getDataLine(this.settings);
        }
        catch (Exception exception) {
            this.mainWindow.fireException(exception);
        }
        this.setWantedRange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int n = 0;
        long l = 0L;
        if (this.dataLine != null) {
            this.openDataLine();
        }
        while (!this.canceled) {
            if (this.dataLine != null && !this.paused && this.dataLine.isOpen()) {
                TGTuner tGTuner = this;
                synchronized (tGTuner) {
                    int n2;
                    this.dataLine.read(this.data, 0, this.settings.getBufferSize());
                    for (n2 = 0; n2 < this.settings.getBufferSize(); ++n2) {
                        this.ar[n2] = this.data[n2];
                        this.ai[n2] = 0.0;
                    }
                    for (n2 = this.settings.getBufferSize(); n2 < this.settings.getFFTSize(); ++n2) {
                        this.ar[n2] = 0.0;
                        this.ai[n2] = 0.0;
                    }
                    ++n;
                    long l2 = System.currentTimeMillis();
                    if (this.fft != null) {
                        this.fft.doFFT(this.ar, this.ai, false);
                    }
                    l += System.currentTimeMillis() - l2;
                    double d = -1.0;
                    double d2 = this.settings.getTreshold();
                    int n3 = (int)Math.round(this.minimumFrequency / this.rate);
                    while ((long)n3 < Math.round(this.maximumFrequency / this.rate)) {
                        double d3 = (double)n3 * this.rate;
                        double d4 = Math.sqrt(Math.pow(this.ar[n3], 2.0) + Math.pow(this.ai[n3], 2.0));
                        if (d4 > d2) {
                            d2 = d4;
                            d = d3;
                        }
                        ++n3;
                    }
                    this.queue.add(d);
                    this.mainWindow.fireFrequency(this.queue.getFreqApproximation());
                    this.dataLine.flush();
                }
            }
            try {
                Thread.sleep(this.settings.getWaitPeriod());
            }
            catch (InterruptedException interruptedException) {}
        }
        this.closeDataLine();
        System.out.println(" Average FFT time: " + (double)l / (double)n);
    }

    protected void computeFFTParams() {
        if (this.settings != null) {
            int n = this.settings.getFFTSize();
            int n2 = 0;
            for (int i = 0; i < 20; ++i) {
                if ((n /= 2) < 1) {
                    this.fft = new FFT(n2);
                    break;
                }
                ++n2;
            }
            this.data = new byte[this.settings.getBufferSize()];
            this.ar = new double[this.settings.getFFTSize()];
            this.ai = new double[this.settings.getFFTSize()];
            this.rate = (double)this.settings.getSampleRate() / (double)this.settings.getFFTSize();
        }
    }

    public void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    public void pause() {
        this.paused = true;
    }

    public void resumeFromPause() {
        this.paused = false;
        this.queue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSettings(TGTunerSettings tGTunerSettings) {
        this.closeDataLine();
        TGTuner tGTuner = this;
        synchronized (tGTuner) {
            this.settings = tGTunerSettings;
            try {
                this.dataLine = TGTunerSettings.getDataLine(tGTunerSettings);
            }
            catch (Exception exception) {
                this.mainWindow.fireException(exception);
            }
        }
        this.openDataLine();
    }

    public TGTunerSettings getSettings() {
        return this.settings;
    }

    public void setWantedNote(int n) {
        this.minimumFrequency = this.getNoteFrequency(n - 3);
        this.maximumFrequency = this.getNoteFrequency(n + 3);
    }

    public void setWantedRange() {
        int[] nArray = this.mainWindow.getTuning();
        this.maximumFrequency = this.getNoteFrequency(nArray[0] + 3);
        this.minimumFrequency = this.getNoteFrequency(nArray[nArray.length - 1] - 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openDataLine() {
        if (this.dataLine != null) {
            TGTuner tGTuner = this;
            synchronized (tGTuner) {
                this.computeFFTParams();
                try {
                    this.dataLine.open();
                    this.dataLine.start();
                }
                catch (LineUnavailableException lineUnavailableException) {
                    System.out.println("------- TGTuner: openDataLine() exception -------");
                    lineUnavailableException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDataLine() {
        TGTuner tGTuner = this;
        synchronized (tGTuner) {
            if (this.dataLine != null) {
                this.dataLine.stop();
                this.dataLine.close();
            }
        }
    }

    public double getNoteFrequency(int n) {
        return 110.0 * Math.pow(2.0, (double)(n - 45) / 12.0);
    }

    public static void computeFFT(int n, int n2, double[] dArray, double[] dArray2) {
        int n3;
        double d;
        int n4;
        double d2 = 2.0 / (double)n2;
        int n5 = 0;
        for (n4 = 0; n4 < n2; ++n4) {
            if (n5 >= n4) {
                double d3 = dArray[n5] * d2;
                d = dArray2[n5] * d2;
                dArray[n5] = dArray[n4] * d2;
                dArray2[n5] = dArray2[n4] * d2;
                dArray[n4] = d3;
                dArray2[n4] = d;
            }
            for (n3 = n2 / 2; n3 >= 1 && n5 >= n3; n5 -= n3, n3 /= 2) {
            }
            n5 += n3;
        }
        n3 = 1;
        int n6 = 2 * n3;
        while (n3 < n2) {
            d = (double)n * Math.PI / (double)n3;
            for (int i = 0; i < n3; ++i) {
                double d4 = (double)i * d;
                double d5 = Math.cos(d4);
                double d6 = Math.sin(d4);
                for (n4 = i; n4 < n2; n4 += n6) {
                    n5 = n4 + n3;
                    double d7 = d5 * dArray[n5] - d6 * dArray2[n5];
                    double d8 = d5 * dArray2[n5] + d6 * dArray[n5];
                    dArray[n5] = dArray[n4] - d7;
                    dArray2[n5] = dArray2[n4] - d8;
                    int n7 = n4;
                    dArray[n7] = dArray[n7] + d7;
                    int n8 = n4;
                    dArray2[n8] = dArray2[n8] + d8;
                }
            }
            n3 = n6;
            n3 = n6;
            n6 = 2 * n3;
        }
    }

    static class TGTunerException
    extends Exception {
        private static final long serialVersionUID = -1860514279319403845L;

        public TGTunerException(String string) {
            super(string);
        }
    }
}

