/*
 * Decompiled with CFR 0.152.
 */
package craigl.spectrumanalyzer;

public class FFT {
    private static final double TWOPI = Math.PI * 2;
    private static final int LOG2_MAXFFTSIZE = 15;
    private static final int MAXFFTSIZE = 32768;
    private int bits;
    private int[] bitreverse = new int[32768];

    public FFT(int n) {
        this.bits = n;
        if (n > 15) {
            System.out.println("" + n + " is too big");
            System.exit(1);
        }
        for (int i = (1 << n) - 1; i >= 0; --i) {
            int n2 = 0;
            for (int j = 0; j < n; ++j) {
                n2 *= 2;
                if ((i & 1 << j) == 0) continue;
                ++n2;
            }
            this.bitreverse[i] = n2;
        }
    }

    public void doFFT(double[] dArray, double[] dArray2, boolean bl) {
        double d;
        double d2;
        int n;
        int n2;
        int n3 = 1 << this.bits;
        int n4 = n3 / 2;
        for (int i = 0; i < this.bits; ++i) {
            for (n2 = 0; n2 < n3; n2 += n4) {
                for (n = 0; n < n4; ++n) {
                    int n5 = this.bitreverse[n2 / n4];
                    double d3 = Math.PI * 2 * (double)n5 / (double)n3;
                    double d4 = Math.cos(d3);
                    double d5 = Math.sin(d3);
                    int n6 = n2 + n4;
                    if (bl) {
                        d5 = -d5;
                    }
                    d2 = dArray[n6] * d4 + dArray2[n6] * d5;
                    d = dArray2[n6] * d4 - dArray[n6] * d5;
                    dArray[n6] = dArray[n2] - d2;
                    dArray2[n6] = dArray2[n2] - d;
                    int n7 = n2;
                    dArray[n7] = dArray[n7] + d2;
                    int n8 = n2++;
                    dArray2[n8] = dArray2[n8] + d;
                }
            }
            n4 /= 2;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n = this.bitreverse[n2];
            if (n <= n2) continue;
            d2 = dArray[n2];
            d = dArray2[n2];
            dArray[n2] = dArray[n];
            dArray2[n2] = dArray2[n];
            dArray[n] = d2;
            dArray2[n] = d;
        }
        if (!bl) {
            double d6 = 1.0 / (double)n3;
            n = 0;
            while (n < n3) {
                int n9 = n;
                dArray[n9] = dArray[n9] * d6;
                int n10 = n++;
                dArray2[n10] = dArray2[n10] * d6;
            }
        }
    }
}

