/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.util;

public class TGSynchronizer {
    private static TGSynchronizer instance;
    private TGSynchronizerController controller;

    private TGSynchronizer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TGSynchronizer instance() {
        if (instance == null) {
            Class clazz = TGSynchronizer.class;
            synchronized (clazz) {
                instance = new TGSynchronizer();
            }
        }
        return instance;
    }

    public void addRunnable(TGRunnable tGRunnable) throws Throwable {
        TGSynchronizerTask tGSynchronizerTask = new TGSynchronizerTask(tGRunnable);
        this.controller.execute(tGSynchronizerTask);
        if (tGSynchronizerTask.getThrowable() != null) {
            throw tGSynchronizerTask.getThrowable();
        }
    }

    public void runLater(TGRunnable tGRunnable) throws Throwable {
        TGSynchronizerTask tGSynchronizerTask = new TGSynchronizerTask(tGRunnable);
        this.controller.executeLater(tGSynchronizerTask);
        if (tGSynchronizerTask.getThrowable() != null) {
            throw tGSynchronizerTask.getThrowable();
        }
    }

    public void setController(TGSynchronizerController tGSynchronizerController) {
        this.controller = tGSynchronizerController;
    }

    public static interface TGSynchronizerController {
        public void execute(TGSynchronizerTask var1);

        public void executeLater(TGSynchronizerTask var1);
    }

    public static interface TGRunnable {
        public void run() throws Throwable;
    }

    public class TGSynchronizerTask {
        private Throwable throwable;
        private TGRunnable runnable;

        public TGSynchronizerTask(TGRunnable tGRunnable) {
            this.runnable = tGRunnable;
            this.throwable = null;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public void run() {
            try {
                this.runnable.run();
            }
            catch (Throwable throwable) {
                this.throwable = throwable;
            }
        }
    }
}

