/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.util;

import java.io.File;
import java.io.FilenameFilter;

public class TGLibraryLoader {
    private static TGLibraryLoader instance;

    private TGLibraryLoader() {
    }

    public static TGLibraryLoader instance() {
        if (instance == null) {
            instance = new TGLibraryLoader();
        }
        return instance;
    }

    public void loadLibraries(File file, final String string, final String string2) {
        if (file != null && file.exists()) {
            FilenameFilter filenameFilter = new FilenameFilter(){

                public boolean accept(File file, String string3) {
                    int n;
                    if (string3 == null) {
                        return false;
                    }
                    if (string != null && string.length() > 0 && (n = string3.indexOf(string)) != 0) {
                        return false;
                    }
                    return string2 == null || string2.length() <= 0 || (n = string3.indexOf(string2)) == string3.length() - string2.length();
                }
            };
            String[] stringArray = file.list(filenameFilter);
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file.getAbsolutePath() + File.separator + stringArray[i]);
                if (!file2.exists() || file2.isDirectory()) continue;
                this.loadLibrary(file2);
            }
        }
    }

    protected void loadLibrary(File file) {
        try {
            System.out.println("Loading: " + file.getAbsolutePath());
            System.load(file.getAbsolutePath());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

