/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGNote;

public abstract class TGVoice {
    public static final int DIRECTION_NONE = 0;
    public static final int DIRECTION_UP = 1;
    public static final int DIRECTION_DOWN = 2;
    private TGBeat beat;
    private TGDuration duration;
    private List notes;
    private int index;
    private int direction;
    private boolean empty;

    public TGVoice(TGFactory tGFactory, int n) {
        this.duration = tGFactory.newDuration();
        this.notes = new ArrayList();
        this.index = n;
        this.empty = true;
        this.direction = 0;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean bl) {
        this.empty = bl;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    public TGDuration getDuration() {
        return this.duration;
    }

    public void setDuration(TGDuration tGDuration) {
        this.duration = tGDuration;
    }

    public TGBeat getBeat() {
        return this.beat;
    }

    public void setBeat(TGBeat tGBeat) {
        this.beat = tGBeat;
    }

    public List getNotes() {
        return this.notes;
    }

    public void addNote(TGNote tGNote) {
        tGNote.setVoice(this);
        this.notes.add(tGNote);
        this.setEmpty(false);
    }

    public void moveNote(int n, TGNote tGNote) {
        this.getNotes().remove(tGNote);
        this.getNotes().add(n, tGNote);
    }

    public void removeNote(TGNote tGNote) {
        this.notes.remove(tGNote);
    }

    public TGNote getNote(int n) {
        if (n >= 0 && n < this.countNotes()) {
            return (TGNote)this.notes.get(n);
        }
        return null;
    }

    public int countNotes() {
        return this.notes.size();
    }

    public boolean isRestVoice() {
        return this.notes.isEmpty();
    }

    public TGVoice clone(TGFactory tGFactory) {
        TGVoice tGVoice = tGFactory.newVoice(this.getIndex());
        tGVoice.setEmpty(this.isEmpty());
        tGVoice.setDirection(this.getDirection());
        this.getDuration().copy(tGVoice.getDuration());
        for (int i = 0; i < this.countNotes(); ++i) {
            TGNote tGNote = (TGNote)this.notes.get(i);
            tGVoice.addNote(tGNote.clone(tGFactory));
        }
        return tGVoice;
    }
}

