/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import org.herac.tuxguitar.song.factory.TGFactory;

public abstract class TGChannel {
    public static final short DEFAULT_PERCUSSION_CHANNEL = 9;
    public static final short DEFAULT_INSTRUMENT = 25;
    public static final short DEFAULT_VOLUME = 127;
    public static final short DEFAULT_BALANCE = 64;
    public static final short DEFAULT_CHORUS = 0;
    public static final short DEFAULT_REVERB = 0;
    public static final short DEFAULT_PHASER = 0;
    public static final short DEFAULT_TREMOLO = 0;
    private short channel = 0;
    private short effectChannel = 0;
    private short instrument = (short)25;
    private short volume = (short)127;
    private short balance = (short)64;
    private short chorus = 0;
    private short reverb = 0;
    private short phaser = 0;
    private short tremolo = 0;

    public short getBalance() {
        return this.balance;
    }

    public void setBalance(short s) {
        this.balance = s;
    }

    public short getChannel() {
        return this.channel;
    }

    public void setChannel(short s) {
        this.channel = s;
    }

    public short getEffectChannel() {
        return this.effectChannel;
    }

    public void setEffectChannel(short s) {
        this.effectChannel = s;
    }

    public short getChorus() {
        return this.chorus;
    }

    public void setChorus(short s) {
        this.chorus = s;
    }

    public short getInstrument() {
        return !this.isPercussionChannel() ? this.instrument : (short)0;
    }

    public void setInstrument(short s) {
        this.instrument = s;
    }

    public short getPhaser() {
        return this.phaser;
    }

    public void setPhaser(short s) {
        this.phaser = s;
    }

    public short getReverb() {
        return this.reverb;
    }

    public void setReverb(short s) {
        this.reverb = s;
    }

    public short getTremolo() {
        return this.tremolo;
    }

    public void setTremolo(short s) {
        this.tremolo = s;
    }

    public short getVolume() {
        return this.volume;
    }

    public void setVolume(short s) {
        this.volume = s;
    }

    public boolean isPercussionChannel() {
        return TGChannel.isPercussionChannel(this.getChannel());
    }

    public static boolean isPercussionChannel(int n) {
        return n == 9;
    }

    public static void setPercussionChannel(TGChannel tGChannel) {
        tGChannel.setChannel((short)9);
        tGChannel.setEffectChannel((short)9);
    }

    public static TGChannel newPercussionChannel(TGFactory tGFactory) {
        TGChannel tGChannel = tGFactory.newChannel();
        TGChannel.setPercussionChannel(tGChannel);
        return tGChannel;
    }

    public TGChannel clone(TGFactory tGFactory) {
        TGChannel tGChannel = tGFactory.newChannel();
        this.copy(tGChannel);
        return tGChannel;
    }

    public void copy(TGChannel tGChannel) {
        tGChannel.setChannel(this.getChannel());
        tGChannel.setEffectChannel(this.getEffectChannel());
        tGChannel.setInstrument(this.getInstrument());
        tGChannel.setVolume(this.getVolume());
        tGChannel.setBalance(this.getBalance());
        tGChannel.setChorus(this.getChorus());
        tGChannel.setReverb(this.getReverb());
        tGChannel.setPhaser(this.getPhaser());
        tGChannel.setTremolo(this.getTremolo());
    }
}

