/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.sequencer;

import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.player.base.MidiSequenceHandler;
import org.herac.tuxguitar.player.base.MidiSequencer;
import org.herac.tuxguitar.player.base.MidiTransmitter;
import org.herac.tuxguitar.player.impl.sequencer.MidiEvent;
import org.herac.tuxguitar.player.impl.sequencer.MidiEventDispacher;
import org.herac.tuxguitar.player.impl.sequencer.MidiEventPlayer;
import org.herac.tuxguitar.player.impl.sequencer.MidiSequenceHandlerImpl;
import org.herac.tuxguitar.player.impl.sequencer.MidiTickPlayer;
import org.herac.tuxguitar.player.impl.sequencer.MidiTrackController;

public class MidiSequencerImpl
implements MidiSequencer {
    private boolean reset;
    private boolean running = false;
    private boolean stopped = true;
    private MidiTransmitter transmitter;
    private MidiTickPlayer midiTickPlayer = new MidiTickPlayer();
    private MidiEventPlayer midiEventPlayer = new MidiEventPlayer(this);
    private MidiEventDispacher midiEventDispacher = new MidiEventDispacher(this);
    private MidiTrackController midiTrackController = new MidiTrackController(this);

    public synchronized MidiTrackController getMidiTrackController() {
        return this.midiTrackController;
    }

    public synchronized void setTempo(int n) {
        this.midiTickPlayer.setTempo(n);
    }

    public synchronized long getTickPosition() {
        return this.midiTickPlayer.getTick();
    }

    public synchronized void setTickPosition(long l) {
        this.reset = true;
        this.midiTickPlayer.setTick(l);
    }

    public synchronized long getTickLength() {
        return this.midiTickPlayer.getTickLength();
    }

    public synchronized void sendEvent(MidiEvent midiEvent) throws MidiPlayerException {
        if (!this.reset) {
            this.midiEventDispacher.dispatch(midiEvent);
        }
    }

    public synchronized void addEvent(MidiEvent midiEvent) {
        this.midiEventPlayer.addEvent(midiEvent);
        this.midiTickPlayer.notifyTick(midiEvent.getTick());
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void setRunning(boolean bl) throws MidiPlayerException {
        this.running = bl;
        if (this.running) {
            this.setTempo(120);
            this.setTickPosition(this.getTickPosition());
            new MidiTimer(this).start();
        } else {
            this.process();
        }
    }

    public synchronized void stop() throws MidiPlayerException {
        this.setRunning(false);
    }

    public synchronized void start() throws MidiPlayerException {
        this.setRunning(true);
    }

    public synchronized void reset(boolean bl) throws MidiPlayerException {
        this.getTransmitter().sendAllNotesOff();
        for (int i = 0; i < 16; ++i) {
            this.getTransmitter().sendPitchBend(i, 64);
        }
        if (bl) {
            this.getTransmitter().sendSystemReset();
        }
    }

    protected synchronized boolean process() throws MidiPlayerException {
        boolean bl = this.isRunning();
        if (bl) {
            if (this.reset) {
                this.reset(false);
                this.reset = false;
                this.midiEventPlayer.reset();
            }
            this.stopped = false;
            this.midiTickPlayer.process();
            this.midiEventPlayer.process();
            if (this.getTickPosition() > this.getTickLength()) {
                this.stop();
            }
        } else if (!this.stopped) {
            this.stopped = true;
            this.midiEventPlayer.clearEvents();
            this.midiTickPlayer.clearTick();
            this.reset(true);
        }
        return bl;
    }

    public synchronized MidiTransmitter getTransmitter() {
        return this.transmitter;
    }

    public synchronized void setTransmitter(MidiTransmitter midiTransmitter) {
        this.transmitter = midiTransmitter;
    }

    public void check() {
    }

    public synchronized void open() {
    }

    public synchronized void close() throws MidiPlayerException {
        if (this.isRunning()) {
            this.stop();
        }
    }

    public synchronized MidiSequenceHandler createSequence(int n) throws MidiPlayerException {
        return new MidiSequenceHandlerImpl(this, n);
    }

    public synchronized void setSolo(int n, boolean bl) throws MidiPlayerException {
        this.getMidiTrackController().setSolo(n, bl);
    }

    public synchronized void setMute(int n, boolean bl) throws MidiPlayerException {
        this.getMidiTrackController().setMute(n, bl);
    }

    public String getKey() {
        return "tuxguitar.sequencer";
    }

    public String getName() {
        return "TuxGuitar Sequencer";
    }

    private class MidiTimer
    extends Thread {
        private static final int TIMER_DELAY = 15;
        private MidiSequencerImpl sequencer;

        public MidiTimer(MidiSequencerImpl midiSequencerImpl2) {
            this.sequencer = midiSequencerImpl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                MidiSequencerImpl midiSequencerImpl = this.sequencer;
                synchronized (midiSequencerImpl) {
                    while (this.sequencer.process()) {
                        this.sequencer.wait(15L);
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

