/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.base;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Iterator;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.base.TGFileFormatManager;
import org.herac.tuxguitar.io.base.TGInputStreamBase;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGSong;

public class TGSongLoader {
    public TGSong load(TGFactory tGFactory, InputStream inputStream) throws TGFileFormatException {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            bufferedInputStream.mark(1);
            Iterator iterator = TGFileFormatManager.instance().getInputStreams();
            while (iterator.hasNext()) {
                TGInputStreamBase tGInputStreamBase = (TGInputStreamBase)iterator.next();
                tGInputStreamBase.init(tGFactory, bufferedInputStream);
                if (tGInputStreamBase.isSupportedVersion()) {
                    return tGInputStreamBase.readSong();
                }
                bufferedInputStream.reset();
            }
            bufferedInputStream.close();
        }
        catch (Throwable throwable) {
            throw new TGFileFormatException(throwable);
        }
        throw new TGFileFormatException("Unsupported file format");
    }
}

