/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGInputStreamBase;
import org.herac.tuxguitar.io.base.TGOutputStreamBase;
import org.herac.tuxguitar.io.base.TGRawExporter;
import org.herac.tuxguitar.io.base.TGRawImporter;
import org.herac.tuxguitar.io.base.TGSongLoader;
import org.herac.tuxguitar.io.base.TGSongWriter;
import org.herac.tuxguitar.io.tg.TGInputStream;
import org.herac.tuxguitar.io.tg.TGOutputStream;

public class TGFileFormatManager {
    public static final String DEFAULT_EXTENSION = ".tg";
    private static TGFileFormatManager instance;
    private TGSongLoader loader = new TGSongLoader();
    private TGSongWriter writer = new TGSongWriter();
    private List inputStreams = new ArrayList();
    private List outputStreams = new ArrayList();
    private List exporters = new ArrayList();
    private List importers = new ArrayList();

    private TGFileFormatManager() {
        this.addDefaultStreams();
    }

    public static TGFileFormatManager instance() {
        if (instance == null) {
            instance = new TGFileFormatManager();
        }
        return instance;
    }

    public TGSongLoader getLoader() {
        return this.loader;
    }

    public TGSongWriter getWriter() {
        return this.writer;
    }

    public void addInputStream(TGInputStreamBase tGInputStreamBase) {
        this.inputStreams.add(tGInputStreamBase);
    }

    public void removeInputStream(TGInputStreamBase tGInputStreamBase) {
        this.inputStreams.remove(tGInputStreamBase);
    }

    public int countInputStreams() {
        return this.inputStreams.size();
    }

    public void addOutputStream(TGOutputStreamBase tGOutputStreamBase) {
        this.outputStreams.add(tGOutputStreamBase);
    }

    public void removeOutputStream(TGOutputStreamBase tGOutputStreamBase) {
        this.outputStreams.remove(tGOutputStreamBase);
    }

    public int countOutputStreams() {
        return this.outputStreams.size();
    }

    public void addImporter(TGRawImporter tGRawImporter) {
        this.importers.add(tGRawImporter);
    }

    public void removeImporter(TGRawImporter tGRawImporter) {
        this.importers.remove(tGRawImporter);
    }

    public int countImporters() {
        return this.importers.size();
    }

    public void addExporter(TGRawExporter tGRawExporter) {
        this.exporters.add(tGRawExporter);
    }

    public void removeExporter(TGRawExporter tGRawExporter) {
        this.exporters.remove(tGRawExporter);
    }

    public int countExporters() {
        return this.exporters.size();
    }

    public Iterator getInputStreams() {
        return this.inputStreams.iterator();
    }

    public Iterator getOutputStreams() {
        return this.outputStreams.iterator();
    }

    public Iterator getImporters() {
        return this.importers.iterator();
    }

    public Iterator getExporters() {
        return this.exporters.iterator();
    }

    public List getInputFormats() {
        ArrayList<TGFileFormat> arrayList = new ArrayList<TGFileFormat>();
        Iterator iterator = this.getInputStreams();
        while (iterator.hasNext()) {
            TGInputStreamBase tGInputStreamBase = (TGInputStreamBase)iterator.next();
            TGFileFormat tGFileFormat = tGInputStreamBase.getFileFormat();
            if (this.existsFormat(tGFileFormat, arrayList)) continue;
            arrayList.add(tGFileFormat);
        }
        return arrayList;
    }

    public List getOutputFormats() {
        ArrayList<TGFileFormat> arrayList = new ArrayList<TGFileFormat>();
        Iterator iterator = this.getOutputStreams();
        while (iterator.hasNext()) {
            TGOutputStreamBase tGOutputStreamBase = (TGOutputStreamBase)iterator.next();
            TGFileFormat tGFileFormat = tGOutputStreamBase.getFileFormat();
            if (this.existsFormat(tGFileFormat, arrayList)) continue;
            arrayList.add(tGFileFormat);
        }
        return arrayList;
    }

    private boolean existsFormat(TGFileFormat tGFileFormat, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TGFileFormat tGFileFormat2 = (TGFileFormat)iterator.next();
            if (!tGFileFormat2.getName().equals(tGFileFormat.getName()) && !tGFileFormat2.getSupportedFormats().equals(tGFileFormat.getSupportedFormats())) continue;
            return true;
        }
        return false;
    }

    private void addDefaultStreams() {
        this.addInputStream(new TGInputStream());
        this.addOutputStream(new TGOutputStream());
    }
}

