/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.util;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGPainter;

public class TGSplash {
    private static TGSplash instance;
    private Shell shell;

    private TGSplash() {
    }

    public static TGSplash instance() {
        if (instance == null) {
            instance = new TGSplash();
        }
        return instance;
    }

    public void init() {
        if (TuxGuitar.instance().getConfig().getBooleanConfigValue("show.splash")) {
            final Image image = TuxGuitar.instance().getIconManager().getAppSplash();
            this.shell = new Shell(TuxGuitar.instance().getDisplay(), 262152);
            this.shell.setLayout((Layout)new FillLayout());
            this.shell.setBounds(this.getBounds(image));
            this.shell.setImage(TuxGuitar.instance().getIconManager().getAppIcon());
            this.shell.setText("TuxGuitar");
            this.shell.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent paintEvent) {
                    TGPainter tGPainter = new TGPainter(paintEvent.gc);
                    tGPainter.drawImage(image, 0, 0);
                }
            });
            this.shell.open();
            this.shell.redraw();
            this.shell.update();
        }
    }

    public void finish() {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.close();
            this.shell.dispose();
        }
        instance = null;
    }

    private Rectangle getBounds(Image image) {
        Rectangle rectangle = image.getBounds();
        Rectangle rectangle2 = this.shell.getMonitor().getClientArea();
        int n = (rectangle2.x + rectangle2.width) / 2 - rectangle.width / 2;
        int n2 = (rectangle2.y + rectangle2.height) / 2 - rectangle.height / 2;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        return new Rectangle(n, n2, n3, n4);
    }
}

