/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.util;

import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.ActionLock;
import org.herac.tuxguitar.gui.helper.SyncThread;

public class MessageDialog {
    private int style;
    private String name;
    private String message;

    protected MessageDialog(String string, String string2, int n) {
        this.name = string;
        this.message = string2;
        this.style = n;
    }

    protected void show(Shell shell) {
        MessageBox messageBox = new MessageBox(shell, this.style);
        messageBox.setText(this.name);
        messageBox.setMessage(this.message);
        messageBox.open();
    }

    public static void infoMessage(String string, String string2) {
        MessageDialog.infoMessage(TuxGuitar.instance().getShell(), string, string2);
    }

    public static void infoMessage(final Shell shell, final String string, final String string2) {
        new SyncThread(new Runnable(){

            public void run() {
                if (!shell.isDisposed()) {
                    new MessageDialog(string, string2, 2).show(shell);
                }
            }
        }).start();
    }

    public static void errorMessage(Throwable throwable) {
        MessageDialog.errorMessage(TuxGuitar.instance().getShell(), throwable);
    }

    public static void errorMessage(Shell shell, final Throwable throwable) {
        MessageDialog.errorMessage(shell, throwable.getMessage() != null ? throwable.getMessage() : throwable.getClass().getName());
        new Thread(new Runnable(){

            public void run() {
                throwable.printStackTrace();
            }
        }).start();
    }

    public static void errorMessage(final Shell shell, final String string) {
        if (!shell.isDisposed()) {
            new SyncThread(new Runnable(){

                public void run() {
                    if (!shell.isDisposed()) {
                        ActionLock.unlock();
                        TuxGuitar.instance().unlock();
                        shell.setCursor(shell.getDisplay().getSystemCursor(0));
                        new MessageDialog(TuxGuitar.getProperty("error"), string, 1).show(shell);
                    }
                }
            }).start();
        }
    }
}

