/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.io.base.TGFileFormat;

public class FileChooser {
    public static final String DEFAULT_OPEN_FILENAME = null;
    public static final String DEFAULT_SAVE_FILENAME = "Untitled.tg";
    public static TGFileFormat ALL_FORMATS = new TGFileFormat("All Files", "*.*");
    private static FileChooser instance;

    public static FileChooser instance() {
        if (instance == null) {
            instance = new FileChooser();
        }
        return instance;
    }

    private List list(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        return arrayList;
    }

    public String open(Shell shell, TGFileFormat tGFileFormat) {
        return this.open(shell, this.list(tGFileFormat));
    }

    public String open(Shell shell, List list) {
        String string = TuxGuitar.instance().getFileHistory().getCurrentFilePath();
        String string2 = TuxGuitar.instance().getFileHistory().getOpenPath();
        boolean bl = TuxGuitar.instance().getFileHistory().isLocalFile();
        boolean bl2 = bl && string != null && string2 != null && string.equals(string2);
        FilterList filterList = new FilterList(list);
        FileDialog fileDialog = new FileDialog(shell, 4096);
        fileDialog.setFileName(bl2 ? this.getFileName(list, DEFAULT_OPEN_FILENAME, false) : null);
        fileDialog.setFilterPath(string2);
        fileDialog.setFilterNames(filterList.getFilterNames());
        fileDialog.setFilterExtensions(filterList.getFilterExtensions());
        return this.openDialog(fileDialog);
    }

    public String save(Shell shell, TGFileFormat tGFileFormat) {
        return this.save(shell, this.list(tGFileFormat));
    }

    public String save(Shell shell, List list) {
        String string = TuxGuitar.instance().getFileHistory().getSavePath();
        FilterList filterList = new FilterList(list);
        FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setFileName(this.getFileName(list, DEFAULT_SAVE_FILENAME, true));
        fileDialog.setFilterPath(string);
        fileDialog.setFilterNames(filterList.getFilterNames());
        fileDialog.setFilterExtensions(filterList.getFilterExtensions());
        return this.openDialog(fileDialog);
    }

    private String openDialog(FileDialog fileDialog) {
        File file;
        File file2;
        String string = fileDialog.open();
        if (string != null && (file2 = (file = new File(string)).getParentFile()) != null && file2.exists() && file2.isDirectory()) {
            TuxGuitar.instance().getFileHistory().setChooserPath(file2.getAbsolutePath());
        }
        return string;
    }

    private String getFileName(List list, String string, boolean bl) {
        int n;
        if (list == null || list.isEmpty()) {
            return string;
        }
        String string2 = TuxGuitar.instance().getFileHistory().getCurrentFileName(string);
        if (string2 != null && string2.length() > 0 && (n = string2.lastIndexOf(46)) > 0) {
            String[] stringArray;
            TGFileFormat tGFileFormat;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n).toLowerCase();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                tGFileFormat = (TGFileFormat)iterator.next();
                if (tGFileFormat.getSupportedFormats() == null || (stringArray = tGFileFormat.getSupportedFormats().split(TGFileFormat.EXTENSION_SEPARATOR)) == null || stringArray.length <= 0) continue;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equals("*" + string4)) continue;
                    return string2;
                }
            }
            if (bl && (tGFileFormat = (TGFileFormat)list.get(0)).getSupportedFormats() != null && (stringArray = tGFileFormat.getSupportedFormats().split(TGFileFormat.EXTENSION_SEPARATOR)) != null && stringArray.length > 0 && stringArray[0].length() > 1) {
                return string3 + stringArray[0].substring(1);
            }
        }
        return string;
    }

    private class FilterList {
        private String[] filterExtensions;
        private String[] filterNames;

        public FilterList(List list) {
            int n = list.size() + 2;
            this.filterNames = new String[n];
            this.filterExtensions = new String[n];
            this.filterNames[0] = new String("All Supported Formats");
            this.filterExtensions[0] = new String();
            for (int i = 1; i < n - 1; ++i) {
                TGFileFormat tGFileFormat = (TGFileFormat)list.get(i - 1);
                this.filterNames[i] = tGFileFormat.getName();
                this.filterExtensions[i] = tGFileFormat.getSupportedFormats();
                this.filterExtensions[0] = this.filterExtensions[0] + (i > 1 ? ";" : "");
                this.filterExtensions[0] = this.filterExtensions[0] + tGFileFormat.getSupportedFormats();
            }
            this.filterNames[n - 1] = new String("All Files");
            this.filterExtensions[n - 1] = new String("*.*");
        }

        public String[] getFilterExtensions() {
            return this.filterExtensions;
        }

        public String[] getFilterNames() {
            return this.filterNames;
        }
    }
}

