/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.track;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.models.TGTrack;

public class UndoableAddTrack
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private TGTrack redoableTrack;

    private UndoableAddTrack() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        TuxGuitar.instance().getSongManager().addTrack(UndoableAddTrack.cloneTrack(this.redoableTrack));
        TuxGuitar.instance().fireUpdate();
        TuxGuitar.instance().getMixer().update();
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        TuxGuitar.instance().getSongManager().removeTrack(UndoableAddTrack.cloneTrack(this.redoableTrack));
        TuxGuitar.instance().fireUpdate();
        TuxGuitar.instance().getMixer().update();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableAddTrack startUndo() {
        UndoableAddTrack undoableAddTrack = new UndoableAddTrack();
        undoableAddTrack.doAction = 1;
        undoableAddTrack.undoCaret = new UndoableCaretHelper();
        return undoableAddTrack;
    }

    public UndoableAddTrack endUndo(TGTrack tGTrack) {
        this.redoCaret = new UndoableCaretHelper();
        this.redoableTrack = UndoableAddTrack.cloneTrack(tGTrack);
        return this;
    }

    private static TGTrack cloneTrack(TGTrack tGTrack) {
        return tGTrack.clone(TuxGuitar.instance().getSongManager().getFactory(), TuxGuitar.instance().getSongManager().getSong());
    }
}

