/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.custom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.models.TGTrack;

public class UndoableChangeKeySignature
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private long position;
    private int redoableKeySignature;
    private int undoableKeySignature;
    private List nextKeySignaturePositions;
    private boolean toEnd;
    private TGTrack track;

    private UndoableChangeKeySignature() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        TuxGuitar.instance().getSongManager().getTrackManager().changeKeySignature(this.track, this.position, this.redoableKeySignature, this.toEnd);
        TuxGuitar.instance().fireUpdate();
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        TuxGuitar.instance().getSongManager().getTrackManager().changeKeySignature(this.track, this.position, this.undoableKeySignature, this.toEnd);
        if (this.toEnd) {
            Iterator iterator = this.nextKeySignaturePositions.iterator();
            while (iterator.hasNext()) {
                KeySignaturePosition keySignaturePosition = (KeySignaturePosition)iterator.next();
                TuxGuitar.instance().getSongManager().getTrackManager().changeKeySignature(this.track, keySignaturePosition.getPosition(), keySignaturePosition.getKeySignature(), true);
            }
        }
        TuxGuitar.instance().fireUpdate();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableChangeKeySignature startUndo() {
        UndoableChangeKeySignature undoableChangeKeySignature = new UndoableChangeKeySignature();
        Caret caret = UndoableChangeKeySignature.getCaret();
        undoableChangeKeySignature.doAction = 1;
        undoableChangeKeySignature.undoCaret = new UndoableCaretHelper();
        undoableChangeKeySignature.position = caret.getPosition();
        undoableChangeKeySignature.undoableKeySignature = caret.getMeasure().getKeySignature();
        undoableChangeKeySignature.track = caret.getTrack();
        undoableChangeKeySignature.nextKeySignaturePositions = new ArrayList();
        int n = undoableChangeKeySignature.undoableKeySignature;
        Iterator iterator = caret.getTrack().getMeasures();
        while (iterator.hasNext()) {
            TGMeasureImpl tGMeasureImpl = (TGMeasureImpl)iterator.next();
            if (tGMeasureImpl.getStart() <= undoableChangeKeySignature.position) continue;
            int n2 = tGMeasureImpl.getKeySignature();
            if (n != n2) {
                UndoableChangeKeySignature undoableChangeKeySignature2 = undoableChangeKeySignature;
                undoableChangeKeySignature2.getClass();
                KeySignaturePosition keySignaturePosition = undoableChangeKeySignature2.new KeySignaturePosition(tGMeasureImpl.getStart(), n2);
                undoableChangeKeySignature.nextKeySignaturePositions.add(keySignaturePosition);
            }
            n = n2;
        }
        return undoableChangeKeySignature;
    }

    public UndoableChangeKeySignature endUndo(int n, boolean bl) {
        this.redoCaret = new UndoableCaretHelper();
        this.redoableKeySignature = n;
        this.toEnd = bl;
        return this;
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }

    private class KeySignaturePosition {
        private long position;
        private int keySignature;

        public KeySignaturePosition(long l, int n) {
            this.position = l;
            this.keySignature = n;
        }

        public long getPosition() {
            return this.position;
        }

        public int getKeySignature() {
            return this.keySignature;
        }
    }
}

