/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.transport;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.player.base.MidiPlayerListener;
import org.herac.tuxguitar.util.TGSynchronizer;

public class TGTransportListener
implements MidiPlayerListener {
    protected Object sync = new Object();
    protected TGSynchronizer.TGRunnable startedRunnable = this.getStartedRunnable();
    protected TGSynchronizer.TGRunnable stoppedRunnable = this.getStoppedRunnable();

    public void notifyStarted() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    TuxGuitar.instance().updateCache(true);
                    while (TuxGuitar.instance().getPlayer().isRunning()) {
                        Object object = TGTransportListener.this.sync;
                        synchronized (object) {
                            TGSynchronizer.instance().addRunnable(TGTransportListener.this.startedRunnable);
                            TGTransportListener.this.sync.wait(25L);
                        }
                    }
                    TGTransportListener.this.notifyStopped();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }).start();
    }

    public void notifyStopped() {
        try {
            if (!TuxGuitar.instance().getDisplay().isDisposed()) {
                TGSynchronizer.instance().runLater(this.stoppedRunnable);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void notifyLoop() {
    }

    private TGSynchronizer.TGRunnable getStartedRunnable() {
        return new TGSynchronizer.TGRunnable(){

            public void run() {
                if (TuxGuitar.instance().getPlayer().isRunning()) {
                    TuxGuitar.instance().redrawPlayingMode();
                }
            }
        };
    }

    private TGSynchronizer.TGRunnable getStoppedRunnable() {
        return new TGSynchronizer.TGRunnable(){

            public void run() {
                TuxGuitar.instance().getTransport().gotoPlayerPosition();
            }
        };
    }
}

