/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tools.browser.xml;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.herac.tuxguitar.gui.tools.browser.TGBrowserCollectionInfo;
import org.herac.tuxguitar.gui.tools.browser.TGBrowserManager;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TGBrowserReader {
    private static final String ITEM_TAG = "browser-collection";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_DATA = "data";

    public void loadCollections(TGBrowserManager tGBrowserManager, File file) {
        if (file.exists()) {
            try {
                Document document = TGBrowserReader.getDocument(file);
                TGBrowserReader.loadCollections(tGBrowserManager, document.getFirstChild());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private static void loadCollections(TGBrowserManager tGBrowserManager, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (!string.equals(ITEM_TAG)) continue;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            String string2 = namedNodeMap.getNamedItem(ATTRIBUTE_TYPE).getNodeValue();
            String string3 = namedNodeMap.getNamedItem(ATTRIBUTE_DATA).getNodeValue();
            if (string2 == null) continue;
            TGBrowserCollectionInfo tGBrowserCollectionInfo = new TGBrowserCollectionInfo();
            tGBrowserCollectionInfo.setType(string2);
            tGBrowserCollectionInfo.setData(string3);
            tGBrowserManager.addInfo(tGBrowserCollectionInfo);
        }
    }

    private static Document getDocument(File file) throws ParserConfigurationException, SAXException, IOException {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        document = documentBuilder.parse(file);
        return document;
    }
}

