/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.keybindings.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.herac.tuxguitar.gui.system.keybindings.KeyBindingAction;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyBindingWriter {
    private static final String SHORTCUT_ROOT = "shortcuts";
    private static final String SHORTCUT_TAG = "shortcut";
    private static final String SHORTCUT_ATTRIBUTE_ACTION = "action";
    private static final String SHORTCUT_ATTRIBUTE_KEY = "key";
    private static final String SHORTCUT_ATTRIBUTE_MASK = "mask";

    public static void setBindings(List list, String string) {
        try {
            File file = new File(string);
            Document document = KeyBindingWriter.createDocument();
            KeyBindingWriter.setBindings(list, document);
            KeyBindingWriter.saveDocument(document, file);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static Document createDocument() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            return document;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static void saveDocument(Document document, File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(fileOutputStream);
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(dOMSource, streamResult);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void setBindings(List list, Document document) {
        Element element = document.createElement(SHORTCUT_ROOT);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            KeyBindingAction keyBindingAction = (KeyBindingAction)iterator.next();
            Element element2 = document.createElement(SHORTCUT_TAG);
            element.appendChild(element2);
            Attr attr = document.createAttribute(SHORTCUT_ATTRIBUTE_KEY);
            Attr attr2 = document.createAttribute(SHORTCUT_ATTRIBUTE_MASK);
            Attr attr3 = document.createAttribute(SHORTCUT_ATTRIBUTE_ACTION);
            attr.setNodeValue(Integer.toString(keyBindingAction.getKeyBinding().getKey()));
            attr2.setNodeValue(Integer.toString(keyBindingAction.getKeyBinding().getMask()));
            attr3.setNodeValue(keyBindingAction.getAction());
            element2.getAttributes().setNamedItem(attr);
            element2.getAttributes().setNamedItem(attr2);
            element2.getAttributes().setNamedItem(attr3);
        }
        document.appendChild(element);
    }
}

