/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.config.items;

import java.util.List;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.system.config.TGConfigEditor;
import org.herac.tuxguitar.gui.system.config.items.Option;
import org.herac.tuxguitar.player.base.MidiOutputPort;
import org.herac.tuxguitar.player.base.MidiSequencer;

public class SoundOption
extends Option {
    protected boolean initialized = false;
    protected String msCurrentKey;
    protected List msList;
    protected Combo msCombo;
    protected String mpCurrentKey;
    protected List mpList;
    protected Combo mpCombo;

    public SoundOption(TGConfigEditor tGConfigEditor, ToolBar toolBar, Composite composite) {
        super(tGConfigEditor, toolBar, composite, TuxGuitar.getProperty("settings.config.sound"));
    }

    public void createOption() {
        this.getToolItem().setText(TuxGuitar.getProperty("settings.config.sound"));
        this.getToolItem().setImage(TuxGuitar.instance().getIconManager().getOptionSound());
        this.getToolItem().addSelectionListener((SelectionListener)this);
        this.showLabel(this.getComposite(), 16576, 1, 0, TuxGuitar.getProperty("midi.sequencer"));
        Composite composite = new Composite(this.getComposite(), 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)this.getTabbedData());
        this.msCombo = new Combo(composite, 12);
        this.msCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.showLabel(this.getComposite(), 16576, 1, 0, TuxGuitar.getProperty("midi.port"));
        Composite composite2 = new Composite(this.getComposite(), 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)this.getTabbedData());
        this.mpCombo = new Combo(composite2, 12);
        this.mpCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.loadConfig();
    }

    protected void loadConfig() {
        new Thread(new Runnable(){

            public void run() {
                SoundOption.this.mpList = TuxGuitar.instance().getPlayer().listOutputPorts();
                SoundOption.this.msList = TuxGuitar.instance().getPlayer().listSequencers();
                SoundOption.this.mpCurrentKey = SoundOption.this.getConfig().getStringConfigValue("midi.port");
                SoundOption.this.msCurrentKey = SoundOption.this.getConfig().getStringConfigValue("midi.sequencer");
                MidiSequencer midiSequencer = TuxGuitar.instance().getPlayer().getSequencer();
                MidiOutputPort midiOutputPort = TuxGuitar.instance().getPlayer().getOutputPort();
                final String string = midiSequencer != null ? midiSequencer.getKey() : null;
                final String string2 = midiOutputPort != null ? midiOutputPort.getKey() : null;
                new SyncThread(new Runnable(){

                    public void run() {
                        if (!SoundOption.this.isDisposed()) {
                            String string3 = string;
                            for (int i = 0; i < (this).SoundOption.this.msList.size(); ++i) {
                                MidiSequencer midiSequencer = (MidiSequencer)(this).SoundOption.this.msList.get(i);
                                (this).SoundOption.this.msCombo.add(midiSequencer.getName());
                                if ((this).SoundOption.this.msCurrentKey != null && (this).SoundOption.this.msCurrentKey.equals(midiSequencer.getKey())) {
                                    (this).SoundOption.this.msCombo.select(i);
                                    string3 = null;
                                    continue;
                                }
                                if (string3 == null || !string3.equals(midiSequencer.getKey())) continue;
                                (this).SoundOption.this.msCombo.select(i);
                            }
                            if ((this).SoundOption.this.msCombo.getSelectionIndex() < 0 && (this).SoundOption.this.msCombo.getItemCount() > 0) {
                                (this).SoundOption.this.msCombo.select(0);
                            }
                            String string22 = string2;
                            for (int i = 0; i < (this).SoundOption.this.mpList.size(); ++i) {
                                MidiOutputPort midiOutputPort = (MidiOutputPort)(this).SoundOption.this.mpList.get(i);
                                (this).SoundOption.this.mpCombo.add(midiOutputPort.getName());
                                if ((this).SoundOption.this.mpCurrentKey != null && (this).SoundOption.this.mpCurrentKey.equals(midiOutputPort.getKey())) {
                                    (this).SoundOption.this.mpCombo.select(i);
                                    string22 = null;
                                    continue;
                                }
                                if (string22 == null || !string22.equals(midiOutputPort.getKey())) continue;
                                (this).SoundOption.this.mpCombo.select(i);
                            }
                            if ((this).SoundOption.this.mpCombo.getSelectionIndex() < 0 && (this).SoundOption.this.mpCombo.getItemCount() > 0) {
                                (this).SoundOption.this.mpCombo.select(0);
                            }
                            (this).SoundOption.this.initialized = true;
                            SoundOption.this.pack();
                        }
                    }
                }).start();
            }
        }).start();
    }

    public void updateConfig() {
        if (this.initialized) {
            int n;
            int n2 = this.msCombo.getSelectionIndex();
            if (n2 >= 0 && n2 < this.msList.size()) {
                this.getConfig().setProperty("midi.sequencer", ((MidiSequencer)this.msList.get(n2)).getKey());
            }
            if ((n = this.mpCombo.getSelectionIndex()) >= 0 && n < this.mpList.size()) {
                MidiOutputPort midiOutputPort = (MidiOutputPort)this.mpList.get(n);
                this.getConfig().setProperty("midi.port", midiOutputPort.getKey());
            }
        }
    }

    public void updateDefaults() {
        if (this.initialized) {
            this.getConfig().setProperty("midi.port", this.getDefaults().getProperty("midi.port"));
            this.getConfig().setProperty("midi.sequencer", this.getDefaults().getProperty("midi.sequencer"));
        }
    }

    public void applyConfig(boolean bl) {
        if (bl || this.initialized) {
            String string = this.getConfig().getStringConfigValue("midi.sequencer");
            if (bl || !TuxGuitar.instance().getPlayer().isSequencerOpen(string)) {
                TuxGuitar.instance().getPlayer().openSequencer(string);
            }
            String string2 = this.getConfig().getStringConfigValue("midi.port");
            if (bl || !TuxGuitar.instance().getPlayer().isOutputPortOpen(string2)) {
                TuxGuitar.instance().getPlayer().openOutputPort(string2);
            }
        }
    }
}

