/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.items.MenuItems;
import org.herac.tuxguitar.player.base.MidiPlayerMode;

public class TransportMenuItem
extends MenuItems {
    private static final int STATUS_STOPPED = 1;
    private static final int STATUS_PAUSED = 2;
    private static final int STATUS_RUNNING = 3;
    private MenuItem transportMenuItem;
    private Menu menu;
    private MenuItem play;
    private MenuItem stop;
    private MenuItem metronome;
    private MenuItem mode;
    private MenuItem loopSHeader;
    private MenuItem loopEHeader;
    private int status;

    public TransportMenuItem(Shell shell, Menu menu, int n) {
        this.transportMenuItem = new MenuItem(menu, n);
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.play = new MenuItem(this.menu, 8);
        this.play.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.transport.play"));
        this.stop = new MenuItem(this.menu, 8);
        this.stop.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.transport.stop"));
        new MenuItem(this.menu, 2);
        this.metronome = new MenuItem(this.menu, 32);
        this.metronome.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.transport.metronome"));
        this.mode = new MenuItem(this.menu, 8);
        this.mode.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.transport.mode"));
        new MenuItem(this.menu, 2);
        this.loopSHeader = new MenuItem(this.menu, 32);
        this.loopSHeader.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.transport.set-loop-start"));
        this.loopEHeader = new MenuItem(this.menu, 32);
        this.loopEHeader.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.transport.set-loop-end"));
        this.transportMenuItem.setMenu(this.menu);
        this.status = 1;
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        TGMeasureImpl tGMeasureImpl = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getMeasure();
        MidiPlayerMode midiPlayerMode = TuxGuitar.instance().getPlayer().getMode();
        this.metronome.setSelection(TuxGuitar.instance().getPlayer().isMetronomeEnabled());
        this.loopSHeader.setEnabled(midiPlayerMode.isLoop());
        this.loopSHeader.setSelection(tGMeasureImpl != null && tGMeasureImpl.getNumber() == midiPlayerMode.getLoopSHeader());
        this.loopEHeader.setEnabled(midiPlayerMode.isLoop());
        this.loopEHeader.setSelection(tGMeasureImpl != null && tGMeasureImpl.getNumber() == midiPlayerMode.getLoopEHeader());
        this.loadIcons(false);
    }

    public void loadProperties() {
        this.setMenuItemTextAndAccelerator(this.transportMenuItem, "transport", null);
        this.setMenuItemTextAndAccelerator(this.play, "transport.start", "action.transport.play");
        this.setMenuItemTextAndAccelerator(this.stop, "transport.stop", "action.transport.stop");
        this.setMenuItemTextAndAccelerator(this.mode, "transport.mode", "action.transport.mode");
        this.setMenuItemTextAndAccelerator(this.metronome, "transport.metronome", "action.transport.metronome");
        this.setMenuItemTextAndAccelerator(this.loopSHeader, "transport.set-loop-start", "action.transport.set-loop-start");
        this.setMenuItemTextAndAccelerator(this.loopEHeader, "transport.set-loop-end", "action.transport.set-loop-end");
    }

    public void loadIcons() {
        this.loadIcons(true);
        this.mode.setImage(TuxGuitar.instance().getIconManager().getTransportMode());
        this.metronome.setImage(TuxGuitar.instance().getIconManager().getTransportMetronome());
    }

    public void loadIcons(boolean bl) {
        int n = this.status;
        this.status = TuxGuitar.instance().getPlayer().isRunning() ? 3 : (TuxGuitar.instance().getPlayer().isPaused() ? 2 : 1);
        if (bl || n != this.status) {
            if (this.status == 3) {
                this.stop.setImage(TuxGuitar.instance().getIconManager().getTransportIconStop2());
                this.play.setImage(TuxGuitar.instance().getIconManager().getTransportIconPause());
            } else if (this.status == 2) {
                this.stop.setImage(TuxGuitar.instance().getIconManager().getTransportIconStop2());
                this.play.setImage(TuxGuitar.instance().getIconManager().getTransportIconPlay2());
            } else if (this.status == 1) {
                this.stop.setImage(TuxGuitar.instance().getIconManager().getTransportIconStop1());
                this.play.setImage(TuxGuitar.instance().getIconManager().getTransportIconPlay1());
            }
        }
    }
}

