/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import java.util.Iterator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.MenuItems;
import org.herac.tuxguitar.gui.tools.custom.TGCustomTool;
import org.herac.tuxguitar.gui.tools.custom.TGCustomToolManager;

public class ToolMenuItem
extends MenuItems {
    private MenuItem settingsMenuItem;
    private Menu menu;
    private MenuItem scale;
    private MenuItem browser;
    private MenuItem transpose;
    private MenuItem plugins;
    private MenuItem config;
    private MenuItem keyBindings;

    public ToolMenuItem(Shell shell, Menu menu, int n) {
        this.settingsMenuItem = new MenuItem(menu, n);
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.transpose = new MenuItem(this.menu, 8);
        this.transpose.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.tools.transpose"));
        this.scale = new MenuItem(this.menu, 8);
        this.scale.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.tools.scale"));
        this.browser = new MenuItem(this.menu, 8);
        this.browser.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.tools.browser"));
        Iterator iterator = TGCustomToolManager.instance().getCustomTools();
        while (iterator.hasNext()) {
            TGCustomTool tGCustomTool = (TGCustomTool)iterator.next();
            MenuItem menuItem = new MenuItem(this.menu, 8);
            menuItem.setText(tGCustomTool.getName());
            menuItem.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction(tGCustomTool.getAction()));
        }
        new MenuItem(this.menu, 2);
        this.plugins = new MenuItem(this.menu, 8);
        this.plugins.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.settings.plugins"));
        this.keyBindings = new MenuItem(this.menu, 8);
        this.keyBindings.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.settings.key-bindings"));
        this.config = new MenuItem(this.menu, 8);
        this.config.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.settings.configure"));
        this.settingsMenuItem.setMenu(this.menu);
        this.loadIcons();
        this.loadProperties();
    }

    public void loadProperties() {
        this.setMenuItemTextAndAccelerator(this.settingsMenuItem, "tools", null);
        this.setMenuItemTextAndAccelerator(this.transpose, "tools.transpose", "action.tools.transpose");
        this.setMenuItemTextAndAccelerator(this.scale, "tools.scale", "action.tools.scale");
        this.setMenuItemTextAndAccelerator(this.browser, "tools.browser", "action.tools.browser");
        this.setMenuItemTextAndAccelerator(this.plugins, "tools.plugins", "action.settings.plugins");
        this.setMenuItemTextAndAccelerator(this.keyBindings, "tools.shortcuts", "action.settings.key-bindings");
        this.setMenuItemTextAndAccelerator(this.config, "tools.settings", "action.settings.configure");
    }

    public void loadIcons() {
    }

    public void update() {
        boolean bl = TuxGuitar.instance().getPlayer().isRunning();
        this.transpose.setEnabled(!bl);
    }
}

