/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.MenuItems;
import org.herac.tuxguitar.io.base.TGFileFormatManager;
import org.herac.tuxguitar.io.base.TGLocalFileExporter;
import org.herac.tuxguitar.io.base.TGLocalFileImporter;
import org.herac.tuxguitar.io.base.TGRawExporter;
import org.herac.tuxguitar.io.base.TGRawImporter;

public class FileMenuItem
extends MenuItems {
    private MenuItem fileMenuItem;
    private Menu menu;
    private Menu importMenu;
    private Menu exportMenu;
    private Menu historyMenu;
    private MenuItem newSong;
    private MenuItem open;
    private MenuItem openURL;
    private MenuItem save;
    private MenuItem saveAs;
    private MenuItem importItem;
    private MenuItem exportItem;
    private MenuItem printPreview;
    private MenuItem print;
    private MenuItem historyItem;
    private MenuItem[] historyFiles;
    private MenuItem exit;
    private List importItems;
    private List exportItems;

    public FileMenuItem(Shell shell, Menu menu, int n) {
        this.fileMenuItem = new MenuItem(menu, n);
        this.menu = new Menu((Decorations)shell, 4);
        this.importItems = new ArrayList();
        this.exportItems = new ArrayList();
    }

    public void showItems() {
        this.newSong = new MenuItem(this.menu, 8);
        this.newSong.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.file.new"));
        this.open = new MenuItem(this.menu, 8);
        this.open.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.file.open"));
        this.openURL = new MenuItem(this.menu, 8);
        this.openURL.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.file.open-url"));
        new MenuItem(this.menu, 2);
        this.save = new MenuItem(this.menu, 8);
        this.save.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.file.save"));
        this.saveAs = new MenuItem(this.menu, 8);
        this.saveAs.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.file.save-as"));
        int n = TGFileFormatManager.instance().countImporters();
        int n2 = TGFileFormatManager.instance().countExporters();
        if (n + n2 > 0) {
            new MenuItem(this.menu, 2);
            this.importItems.clear();
            if (n > 0) {
                this.importItem = new MenuItem(this.menu, 64);
                this.importMenu = new Menu((Decorations)this.menu.getShell(), 4);
                this.addImporters();
            }
            this.exportItems.clear();
            if (n2 > 0) {
                this.exportItem = new MenuItem(this.menu, 64);
                this.exportMenu = new Menu((Decorations)this.menu.getShell(), 4);
                this.addExporters();
            }
        }
        new MenuItem(this.menu, 2);
        this.printPreview = new MenuItem(this.menu, 8);
        this.printPreview.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.file.print-preview"));
        this.print = new MenuItem(this.menu, 8);
        this.print.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.file.print"));
        new MenuItem(this.menu, 2);
        this.historyItem = new MenuItem(this.menu, 64);
        this.historyMenu = new Menu((Decorations)this.menu.getShell(), 4);
        this.updateHistoryFiles();
        new MenuItem(this.menu, 2);
        this.exit = new MenuItem(this.menu, 8);
        this.exit.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.file.exit"));
        if (this.importItem != null) {
            this.importItem.setMenu(this.importMenu);
        }
        if (this.exportItem != null) {
            this.exportItem.setMenu(this.exportMenu);
        }
        this.historyItem.setMenu(this.historyMenu);
        this.fileMenuItem.setMenu(this.menu);
        this.loadIcons();
        this.loadProperties();
    }

    private void addImporters() {
        MenuItem menuItem;
        TGRawImporter tGRawImporter;
        int n;
        ArrayList<TGRawImporter> arrayList = new ArrayList<TGRawImporter>();
        ArrayList<TGRawImporter> arrayList2 = new ArrayList<TGRawImporter>();
        Iterator iterator = TGFileFormatManager.instance().getImporters();
        while (iterator.hasNext()) {
            TGRawImporter tGRawImporter2 = (TGRawImporter)iterator.next();
            if (tGRawImporter2 instanceof TGLocalFileImporter) {
                arrayList2.add(tGRawImporter2);
                continue;
            }
            arrayList.add(tGRawImporter2);
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            tGRawImporter = (TGRawImporter)arrayList2.get(n);
            menuItem = new MenuItem(this.importMenu, 8);
            menuItem.setData((Object)tGRawImporter);
            menuItem.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.file.import"));
            this.importItems.add(menuItem);
        }
        if (!arrayList2.isEmpty() && !arrayList.isEmpty()) {
            new MenuItem(this.importMenu, 2);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            tGRawImporter = (TGRawImporter)arrayList.get(n);
            menuItem = new MenuItem(this.importMenu, 8);
            menuItem.setData((Object)tGRawImporter);
            menuItem.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.file.import"));
            this.importItems.add(menuItem);
        }
    }

    private void addExporters() {
        MenuItem menuItem;
        TGRawExporter tGRawExporter;
        int n;
        ArrayList<TGRawExporter> arrayList = new ArrayList<TGRawExporter>();
        ArrayList<TGRawExporter> arrayList2 = new ArrayList<TGRawExporter>();
        Iterator iterator = TGFileFormatManager.instance().getExporters();
        while (iterator.hasNext()) {
            TGRawExporter tGRawExporter2 = (TGRawExporter)iterator.next();
            if (tGRawExporter2 instanceof TGLocalFileExporter) {
                arrayList2.add(tGRawExporter2);
                continue;
            }
            arrayList.add(tGRawExporter2);
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            tGRawExporter = (TGRawExporter)arrayList2.get(n);
            menuItem = new MenuItem(this.exportMenu, 8);
            menuItem.setData((Object)tGRawExporter);
            menuItem.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.file.export"));
            this.exportItems.add(menuItem);
        }
        if (!arrayList2.isEmpty() && !arrayList.isEmpty()) {
            new MenuItem(this.exportMenu, 2);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            tGRawExporter = (TGRawExporter)arrayList.get(n);
            menuItem = new MenuItem(this.exportMenu, 8);
            menuItem.setData((Object)tGRawExporter);
            menuItem.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.file.export"));
            this.exportItems.add(menuItem);
        }
    }

    private void disposeHistoryFiles() {
        for (int i = 0; i < this.historyFiles.length; ++i) {
            this.historyFiles[i].dispose();
        }
    }

    private void updateHistoryFiles() {
        List list = TuxGuitar.instance().getFileHistory().getURLs();
        this.historyFiles = new MenuItem[list.size()];
        for (int i = 0; i < this.historyFiles.length; ++i) {
            URL uRL = (URL)list.get(i);
            this.historyFiles[i] = new MenuItem(this.historyMenu, 8);
            this.historyFiles[i].setText(this.decode(uRL.toString()));
            this.historyFiles[i].setData((Object)uRL);
            this.historyFiles[i].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.file.open"));
        }
        this.historyItem.setEnabled(this.historyFiles.length > 0);
    }

    private String decode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return string;
        }
    }

    public void update() {
        if (TuxGuitar.instance().getFileHistory().isChanged()) {
            this.disposeHistoryFiles();
            this.updateHistoryFiles();
            TuxGuitar.instance().getFileHistory().setChanged(false);
        }
    }

    public void loadProperties() {
        MenuItem menuItem;
        Iterator iterator;
        this.setMenuItemTextAndAccelerator(this.fileMenuItem, "file", null);
        this.setMenuItemTextAndAccelerator(this.newSong, "file.new", "action.file.new");
        this.setMenuItemTextAndAccelerator(this.open, "file.open", "action.file.open");
        this.setMenuItemTextAndAccelerator(this.openURL, "file.open-url", "action.file.open-url");
        this.setMenuItemTextAndAccelerator(this.save, "file.save", "action.file.save");
        this.setMenuItemTextAndAccelerator(this.saveAs, "file.save-as", "action.file.save-as");
        this.setMenuItemTextAndAccelerator(this.printPreview, "file.print-preview", "action.file.print-preview");
        this.setMenuItemTextAndAccelerator(this.print, "file.print", "action.file.print");
        this.setMenuItemTextAndAccelerator(this.historyItem, "file.history", null);
        this.setMenuItemTextAndAccelerator(this.exit, "file.exit", "action.file.exit");
        if (this.importItem != null) {
            this.setMenuItemTextAndAccelerator(this.importItem, "file.import", "action.file.import");
            iterator = this.importItems.iterator();
            while (iterator.hasNext()) {
                menuItem = (MenuItem)iterator.next();
                if (menuItem.getData() instanceof TGLocalFileImporter) {
                    menuItem.setText(TuxGuitar.getProperty("file.import") + " " + ((TGRawImporter)menuItem.getData()).getImportName());
                    continue;
                }
                if (!(menuItem.getData() instanceof TGRawImporter)) continue;
                menuItem.setText(((TGRawImporter)menuItem.getData()).getImportName());
            }
        }
        if (this.exportItem != null) {
            this.setMenuItemTextAndAccelerator(this.exportItem, "file.export", "action.file.export");
            iterator = this.exportItems.iterator();
            while (iterator.hasNext()) {
                menuItem = (MenuItem)iterator.next();
                if (menuItem.getData() instanceof TGLocalFileExporter) {
                    menuItem.setText(TuxGuitar.getProperty("file.export") + " " + ((TGRawExporter)menuItem.getData()).getExportName());
                    continue;
                }
                if (!(menuItem.getData() instanceof TGRawExporter)) continue;
                menuItem.setText(((TGRawExporter)menuItem.getData()).getExportName());
            }
        }
    }

    public void loadIcons() {
        this.newSong.setImage(TuxGuitar.instance().getIconManager().getFileNew());
        this.open.setImage(TuxGuitar.instance().getIconManager().getFileOpen());
        this.save.setImage(TuxGuitar.instance().getIconManager().getFileSave());
        this.saveAs.setImage(TuxGuitar.instance().getIconManager().getFileSaveAs());
        this.printPreview.setImage(TuxGuitar.instance().getIconManager().getFilePrintPreview());
        this.print.setImage(TuxGuitar.instance().getIconManager().getFilePrint());
    }
}

