/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.MenuItems;

public class DurationMenuItem
extends MenuItems {
    private MenuItem durationMenuItem;
    private Menu menu;
    private MenuItem whole;
    private MenuItem half;
    private MenuItem quarter;
    private MenuItem eighth;
    private MenuItem sixteenth;
    private MenuItem thirtySecond;
    private MenuItem sixtyFourth;
    private MenuItem dotted;
    private MenuItem doubleDotted;
    private MenuItem division;

    public DurationMenuItem(Shell shell, Menu menu, int n) {
        this.durationMenuItem = new MenuItem(menu, n);
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.whole = new MenuItem(this.menu, 8);
        this.whole.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.set-whole"));
        this.half = new MenuItem(this.menu, 8);
        this.half.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.set-half"));
        this.quarter = new MenuItem(this.menu, 8);
        this.quarter.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.set-quarter"));
        this.eighth = new MenuItem(this.menu, 8);
        this.eighth.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.set-eighth"));
        this.sixteenth = new MenuItem(this.menu, 8);
        this.sixteenth.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.set-sixteenth"));
        this.thirtySecond = new MenuItem(this.menu, 8);
        this.thirtySecond.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.set-thirty-second"));
        this.sixtyFourth = new MenuItem(this.menu, 8);
        this.sixtyFourth.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.set-sixty-fourth"));
        new MenuItem(this.menu, 2);
        this.dotted = new MenuItem(this.menu, 8);
        this.dotted.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.change-dotted"));
        this.doubleDotted = new MenuItem(this.menu, 8);
        this.doubleDotted.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.change-double-dotted"));
        this.division = new MenuItem(this.menu, 8);
        this.division.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.change-division-type"));
        this.durationMenuItem.setMenu(this.menu);
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        boolean bl = TuxGuitar.instance().getPlayer().isRunning();
        this.whole.setEnabled(!bl);
        this.half.setEnabled(!bl);
        this.quarter.setEnabled(!bl);
        this.eighth.setEnabled(!bl);
        this.sixteenth.setEnabled(!bl);
        this.thirtySecond.setEnabled(!bl);
        this.sixtyFourth.setEnabled(!bl);
        this.dotted.setEnabled(!bl);
        this.doubleDotted.setEnabled(!bl);
        this.division.setEnabled(!bl);
    }

    public void loadProperties() {
        this.setMenuItemTextAndAccelerator(this.durationMenuItem, "duration", null);
        this.setMenuItemTextAndAccelerator(this.whole, "duration.whole", "action.note.duration.set-whole");
        this.setMenuItemTextAndAccelerator(this.half, "duration.half", "action.note.duration.set-half");
        this.setMenuItemTextAndAccelerator(this.quarter, "duration.quarter", "action.note.duration.set-quarter");
        this.setMenuItemTextAndAccelerator(this.eighth, "duration.eighth", "action.note.duration.set-eighth");
        this.setMenuItemTextAndAccelerator(this.sixteenth, "duration.sixteenth", "action.note.duration.set-sixteenth");
        this.setMenuItemTextAndAccelerator(this.thirtySecond, "duration.thirtysecond", "action.note.duration.set-thirty-second");
        this.setMenuItemTextAndAccelerator(this.sixtyFourth, "duration.sixtyfourth", "action.note.duration.set-sixty-fourth");
        this.setMenuItemTextAndAccelerator(this.dotted, "duration.dotted", "action.note.duration.change-dotted");
        this.setMenuItemTextAndAccelerator(this.doubleDotted, "duration.doubledotted", "action.note.duration.change-double-dotted");
        this.setMenuItemTextAndAccelerator(this.division, "duration.division-type", "action.note.duration.change-division-type");
    }

    public void loadIcons() {
        this.whole.setImage(TuxGuitar.instance().getIconManager().getDuration(1));
        this.half.setImage(TuxGuitar.instance().getIconManager().getDuration(2));
        this.quarter.setImage(TuxGuitar.instance().getIconManager().getDuration(4));
        this.eighth.setImage(TuxGuitar.instance().getIconManager().getDuration(8));
        this.sixteenth.setImage(TuxGuitar.instance().getIconManager().getDuration(16));
        this.thirtySecond.setImage(TuxGuitar.instance().getIconManager().getDuration(32));
        this.sixtyFourth.setImage(TuxGuitar.instance().getIconManager().getDuration(64));
        this.dotted.setImage(TuxGuitar.instance().getIconManager().getDurationDotted());
        this.doubleDotted.setImage(TuxGuitar.instance().getIconManager().getDurationDoubleDotted());
        this.division.setImage(TuxGuitar.instance().getIconManager().getDivisionType());
    }
}

