/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.TGBeatImpl;
import org.herac.tuxguitar.gui.items.MenuItems;
import org.herac.tuxguitar.gui.items.menu.ChordMenuItem;
import org.herac.tuxguitar.gui.items.menu.DurationMenuItem;
import org.herac.tuxguitar.gui.items.menu.DynamicMenuItem;
import org.herac.tuxguitar.gui.items.menu.NoteEffectsMenuItem;
import org.herac.tuxguitar.song.models.TGNote;

public class BeatMenuItem
extends MenuItems {
    private MenuItem noteMenuItem;
    private Menu menu;
    private MenuItem tiedNote;
    private MenuItem cleanBeat;
    private MenuItem removeVoice;
    private MenuItem insertText;
    private MenuItem voiceAuto;
    private MenuItem voiceUp;
    private MenuItem voiceDown;
    private MenuItem strokeUp;
    private MenuItem strokeDown;
    private MenuItem shiftUp;
    private MenuItem shiftDown;
    private MenuItem semitoneUp;
    private MenuItem semitoneDown;
    private MenuItem moveBeatsLeft;
    private MenuItem moveBeatsRight;
    private MenuItem moveBeatsCustom;
    private DurationMenuItem durationMenuItem;
    private ChordMenuItem chordMenuItem;
    private NoteEffectsMenuItem effectMenuItem;
    private DynamicMenuItem dynamicMenuItem;

    public BeatMenuItem(Shell shell, Menu menu, int n) {
        this.noteMenuItem = new MenuItem(menu, n);
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.tiedNote = new MenuItem(this.menu, 32);
        this.tiedNote.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.general.tied"));
        this.cleanBeat = new MenuItem(this.menu, 8);
        this.cleanBeat.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.general.clean-beat"));
        this.removeVoice = new MenuItem(this.menu, 8);
        this.removeVoice.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.beat.general.remove-unused-voice"));
        this.durationMenuItem = new DurationMenuItem(this.menu.getShell(), this.menu, 64);
        this.durationMenuItem.showItems();
        this.chordMenuItem = new ChordMenuItem(this.menu.getShell(), this.menu, 64);
        this.chordMenuItem.showItems();
        this.effectMenuItem = new NoteEffectsMenuItem(this.menu.getShell(), this.menu, 64);
        this.effectMenuItem.showItems();
        this.dynamicMenuItem = new DynamicMenuItem(this.menu.getShell(), this.menu, 64);
        this.dynamicMenuItem.showItems();
        new MenuItem(this.menu, 2);
        this.insertText = new MenuItem(this.menu, 8);
        this.insertText.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.insert.text"));
        new MenuItem(this.menu, 2);
        this.voiceAuto = new MenuItem(this.menu, 8);
        this.voiceAuto.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.beat.general.voice-auto"));
        this.voiceUp = new MenuItem(this.menu, 8);
        this.voiceUp.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.beat.general.voice-up"));
        this.voiceDown = new MenuItem(this.menu, 8);
        this.voiceDown.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.beat.general.voice-down"));
        new MenuItem(this.menu, 2);
        this.strokeUp = new MenuItem(this.menu, 32);
        this.strokeUp.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.beat.general.set-stroke-up"));
        this.strokeDown = new MenuItem(this.menu, 32);
        this.strokeDown.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.beat.general.set-stroke-down"));
        new MenuItem(this.menu, 2);
        this.semitoneUp = new MenuItem(this.menu, 8);
        this.semitoneUp.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.general.increment-semitone"));
        this.semitoneDown = new MenuItem(this.menu, 8);
        this.semitoneDown.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.general.decrement-semitone"));
        new MenuItem(this.menu, 2);
        this.shiftUp = new MenuItem(this.menu, 8);
        this.shiftUp.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.general.shift-up"));
        this.shiftDown = new MenuItem(this.menu, 8);
        this.shiftDown.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.general.shift-down"));
        new MenuItem(this.menu, 2);
        this.moveBeatsLeft = new MenuItem(this.menu, 8);
        this.moveBeatsLeft.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.beat.general.move-left"));
        this.moveBeatsRight = new MenuItem(this.menu, 8);
        this.moveBeatsRight.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.beat.general.move-right"));
        this.moveBeatsCustom = new MenuItem(this.menu, 8);
        this.moveBeatsCustom.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.beat.general.move-custom"));
        this.noteMenuItem.setMenu(this.menu);
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        Caret caret = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
        TGBeatImpl tGBeatImpl = caret.getSelectedBeat();
        TGNote tGNote = caret.getSelectedNote();
        boolean bl = caret.isRestBeatSelected();
        boolean bl2 = TuxGuitar.instance().getPlayer().isRunning();
        this.tiedNote.setEnabled(!bl2);
        this.tiedNote.setSelection(tGNote != null && tGNote.isTiedNote());
        this.cleanBeat.setEnabled(!bl2);
        this.removeVoice.setEnabled(!bl2);
        this.voiceAuto.setEnabled(!bl2 && !bl);
        this.voiceUp.setEnabled(!bl2 && !bl);
        this.voiceDown.setEnabled(!bl2 && !bl);
        this.strokeUp.setEnabled(!bl2 && !bl);
        this.strokeUp.setSelection(tGBeatImpl != null && tGBeatImpl.getStroke().getDirection() == 1);
        this.strokeDown.setEnabled(!bl2 && !bl);
        this.strokeDown.setSelection(tGBeatImpl != null && tGBeatImpl.getStroke().getDirection() == -1);
        this.semitoneUp.setEnabled(!bl2 && tGNote != null);
        this.semitoneDown.setEnabled(!bl2 && tGNote != null);
        this.shiftUp.setEnabled(!bl2 && tGNote != null);
        this.shiftDown.setEnabled(!bl2 && tGNote != null);
        this.insertText.setEnabled(!bl2);
        this.moveBeatsLeft.setEnabled(!bl2);
        this.moveBeatsRight.setEnabled(!bl2);
        this.moveBeatsCustom.setEnabled(!bl2);
        this.durationMenuItem.update();
        this.chordMenuItem.update();
        this.effectMenuItem.update();
        this.dynamicMenuItem.update();
    }

    public void loadProperties() {
        this.setMenuItemTextAndAccelerator(this.noteMenuItem, "beat", null);
        this.setMenuItemTextAndAccelerator(this.cleanBeat, "beat.clean", "action.note.general.clean-beat");
        this.setMenuItemTextAndAccelerator(this.removeVoice, "beat.voice.remove-unused", "action.beat.general.remove-unused-voice");
        this.setMenuItemTextAndAccelerator(this.tiedNote, "note.tiednote", "action.note.general.tied");
        this.setMenuItemTextAndAccelerator(this.voiceAuto, "beat.voice-auto", "action.beat.general.voice-auto");
        this.setMenuItemTextAndAccelerator(this.voiceUp, "beat.voice-up", "action.beat.general.voice-up");
        this.setMenuItemTextAndAccelerator(this.voiceDown, "beat.voice-down", "action.beat.general.voice-down");
        this.setMenuItemTextAndAccelerator(this.strokeUp, "beat.stroke-up", "action.beat.general.set-stroke-up");
        this.setMenuItemTextAndAccelerator(this.strokeDown, "beat.stroke-down", "action.beat.general.set-stroke-down");
        this.setMenuItemTextAndAccelerator(this.semitoneUp, "note.semitone-up", "action.note.general.increment-semitone");
        this.setMenuItemTextAndAccelerator(this.semitoneDown, "note.semitone-down", "action.note.general.decrement-semitone");
        this.setMenuItemTextAndAccelerator(this.shiftUp, "note.shift-up", "action.note.general.shift-up");
        this.setMenuItemTextAndAccelerator(this.shiftDown, "note.shift-down", "action.note.general.shift-down");
        this.setMenuItemTextAndAccelerator(this.insertText, "text.insert", "action.insert.text");
        this.setMenuItemTextAndAccelerator(this.moveBeatsLeft, "beat.move-left", "action.beat.general.move-left");
        this.setMenuItemTextAndAccelerator(this.moveBeatsRight, "beat.move-right", "action.beat.general.move-right");
        this.setMenuItemTextAndAccelerator(this.moveBeatsCustom, "beat.move-custom", "action.beat.general.move-custom");
        this.durationMenuItem.loadProperties();
        this.chordMenuItem.loadProperties();
        this.effectMenuItem.loadProperties();
        this.dynamicMenuItem.loadProperties();
    }

    public void loadIcons() {
        this.tiedNote.setImage(TuxGuitar.instance().getIconManager().getNoteTied());
    }
}

