/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab.layout;

import java.util.Iterator;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.editors.tab.TGLyricImpl;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.editors.tab.TGTrackImpl;
import org.herac.tuxguitar.gui.editors.tab.TGTrackSpacing;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;

public class LinearViewLayout
extends ViewLayout {
    public LinearViewLayout(Tablature tablature, int n) {
        super(tablature, n);
    }

    public int getMode() {
        return 2;
    }

    public void paintSong(TGPainter tGPainter, Rectangle rectangle, int n, int n2) {
        this.setWidth(0);
        this.setHeight(0);
        this.clearTrackPositions();
        int n3 = this.getStyle();
        int n4 = (n3 & 2) == 0 ? this.getTablature().getCaret().getTrack().getNumber() : -1;
        int n5 = n2 + this.getFirstTrackSpacing();
        int n6 = this.getFirstTrackSpacing();
        Iterator iterator = this.getSongManager().getSong().getTracks();
        while (iterator.hasNext()) {
            TGTrackImpl tGTrackImpl = (TGTrackImpl)iterator.next();
            if (n4 >= 0 && tGTrackImpl.getNumber() != n4) continue;
            TGTrackSpacing tGTrackSpacing = new TGTrackSpacing(this);
            tGTrackSpacing.setSize(8, (n3 & 4) != 0 ? this.getScoreLineSpacing() * 5 : 0);
            ((TGLyricImpl)tGTrackImpl.getLyrics()).start();
            int n7 = 0;
            int n8 = 0;
            if ((n3 & 8) == 0 && (n3 & 4) != 0) {
                n7 = this.getScoreLineSpacing() * 4 + this.getScoreLineSpacing() * 4;
                n8 = -(this.getScoreLineSpacing() * 3);
            }
            Iterator iterator2 = tGTrackImpl.getMeasures();
            while (iterator2.hasNext()) {
                TGMeasureImpl tGMeasureImpl = (TGMeasureImpl)iterator2.next();
                n7 = tGMeasureImpl.getMaxY() > n7 ? tGMeasureImpl.getMaxY() : n7;
                n8 = tGMeasureImpl.getMinY() < n8 ? tGMeasureImpl.getMinY() : n8;
                tGMeasureImpl.registerSpacing(this, tGTrackSpacing);
            }
            tGTrackSpacing.setSize(7, (n3 & 4) != 0 ? Math.abs(n8) : 0);
            if ((n3 & 4) != 0 && n7 + this.getMinScoreTabSpacing() > this.getScoreSpacing()) {
                tGTrackSpacing.setSize(9, n7 - this.getScoreLineSpacing() * 4);
            }
            if ((n3 & 8) != 0) {
                tGTrackSpacing.setSize(12, (n3 & 4) != 0 ? this.getMinScoreTabSpacing() : Math.max(Math.abs(n8), this.getStringSpacing()));
                tGTrackSpacing.setSize(13, (n3 & 4) != 0 ? tGTrackImpl.getTabHeight() + this.getStringSpacing() + 1 : Math.max(n7, tGTrackImpl.getTabHeight() + this.getStringSpacing() + 1));
            }
            tGTrackSpacing.setSize(14, 10);
            this.checkDefaultSpacing(tGTrackSpacing);
            this.paintMeasures(tGTrackImpl, tGPainter, n, n5, tGTrackSpacing, rectangle);
            this.paintLines(tGTrackImpl, tGTrackSpacing, tGPainter, n + (this.getWidth() + 2), n5, rectangle.width - (n + this.getWidth()));
            int n9 = tGTrackSpacing.getSize();
            this.addTrackPosition(tGTrackImpl.getNumber(), n5, n9);
            n5 += n9 + this.getTrackSpacing();
            n6 += n9 + this.getTrackSpacing();
        }
        if (this.getWidth() > rectangle.width) {
            this.setWidth(this.getWidth() + this.getFirstMeasureSpacing());
        }
        this.setHeight(n6);
        this.paintCaret(tGPainter);
    }

    public void paintMeasures(TGTrackImpl tGTrackImpl, TGPainter tGPainter, int n, int n2, TGTrackSpacing tGTrackSpacing, Rectangle rectangle) {
        int n3 = n + this.getFirstMeasureSpacing();
        int n4 = n2;
        int n5 = this.getFirstMeasureSpacing();
        Iterator iterator = tGTrackImpl.getMeasures();
        while (iterator.hasNext()) {
            boolean bl;
            TGMeasureImpl tGMeasureImpl = (TGMeasureImpl)iterator.next();
            tGMeasureImpl.setPosX(n3);
            tGMeasureImpl.setPosY(n4);
            tGMeasureImpl.setTs(tGTrackSpacing);
            ((TGLyricImpl)tGTrackImpl.getLyrics()).setCurrentMeasure(tGMeasureImpl);
            boolean bl2 = n3 + tGMeasureImpl.getWidth(this) > rectangle.x - 100 && n3 < rectangle.x + rectangle.width + tGMeasureImpl.getWidth(this) + 100;
            boolean bl3 = bl = n4 + tGTrackSpacing.getSize() > rectangle.y && n4 < rectangle.y + rectangle.height + 80;
            if (bl2 && bl) {
                this.paintMeasure(tGMeasureImpl, tGPainter, 0);
                ((TGLyricImpl)tGTrackImpl.getLyrics()).paintCurrentNoteBeats(tGPainter, this, tGMeasureImpl, n3, n4);
            } else {
                tGMeasureImpl.setOutOfBounds(true);
            }
            int n6 = tGMeasureImpl.getWidth(this);
            n3 += n6;
            n5 += n6;
        }
        this.setWidth(Math.max(this.getWidth(), n5));
    }
}

