/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab.edit;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.ActionLock;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.TGBeatImpl;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.editors.tab.TGNoteImpl;
import org.herac.tuxguitar.gui.editors.tab.TGTrackImpl;
import org.herac.tuxguitar.gui.editors.tab.TGVoiceImpl;
import org.herac.tuxguitar.gui.editors.tab.edit.EditorKit;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGVoice;

public class MouseKit {
    private static final int[] FIRST_LINE_VALUES = new int[]{65, 45, 52, 55};
    private EditorKit kit;
    private Image back = null;
    private int lastx;
    private int lasty;

    public MouseKit(EditorKit editorKit) {
        this.kit = editorKit;
    }

    private ViewLayout.TrackPosition getTrackPosition(int n) {
        return this.kit.getTablature().getViewLayout().getTrackPositionAt(n);
    }

    public void tryBack() {
        if (!(TuxGuitar.instance().isLocked() || ActionLock.isLocked() || this.kit.getTablature().isPainting())) {
            TGPainter tGPainter = new TGPainter(new GC((Drawable)this.kit.getTablature()));
            if (this.back != null && !this.back.isDisposed()) {
                tGPainter.drawImage(this.back, this.lastx, this.lasty);
            }
            tGPainter.dispose();
        }
        if (this.back != null) {
            this.back.dispose();
        }
    }

    public void mouseExit() {
        this.tryBack();
    }

    public void mouseMove(MouseEvent mouseEvent) {
        TGMeasureImpl tGMeasureImpl;
        TGTrackImpl tGTrackImpl;
        this.tryBack();
        if (!(TuxGuitar.instance().isLocked() || ActionLock.isLocked() || this.kit.getTablature().isPainting() || (tGTrackImpl = this.kit.findSelectedTrack(mouseEvent.y)) == null || (tGMeasureImpl = this.kit.findSelectedMeasure(tGTrackImpl, mouseEvent.x, mouseEvent.y)) == null || tGMeasureImpl.getTs() == null)) {
            float f = this.kit.getTablature().getViewLayout().getScale();
            int n = tGTrackImpl.getString(tGTrackImpl.stringCount()).getValue();
            int n2 = tGTrackImpl.getString(1).getValue() + 29;
            int n3 = FIRST_LINE_VALUES[tGMeasureImpl.getClef() - 1];
            int n4 = this.kit.getTablature().getViewLayout().getScoreLineSpacing();
            int n5 = (int)(10.0f * f);
            int n6 = tGMeasureImpl.getTs().getPosition(8);
            int n7 = tGMeasureImpl.getTs().getPosition(13) - tGMeasureImpl.getTs().getPosition(9);
            int n8 = (int)((float)mouseEvent.x - (float)n5 / 2.0f);
            int n9 = (int)((float)mouseEvent.x + (float)n5 / 2.0f);
            int n10 = tGMeasureImpl.getPosY() + tGMeasureImpl.getTs().getPosition(8);
            int n11 = n10 + n4 * 5;
            if (mouseEvent.y < n10 + 3 && mouseEvent.y >= n10 - n6) {
                this.back = new Image((Device)TuxGuitar.instance().getDisplay(), n5 + 1, n6 + 1);
                TGPainter tGPainter = new TGPainter(new GC((Drawable)this.kit.getTablature()));
                tGPainter.copyArea(this.back, n8, n10 - n6);
                tGPainter.setForeground(this.kit.getTablature().getViewLayout().getResources().getLineColor());
                for (int i = n10 - n4; i >= n10 - n6 && i >= mouseEvent.y - 5 && (n3 += TGMeasureImpl.ACCIDENTAL_NOTES[((n3 += TGMeasureImpl.ACCIDENTAL_NOTES[(n3 + 1) % 12] ? 2 : 1) + 1) % 12] ? 2 : 1) <= n2; i -= n4) {
                    tGPainter.initPath();
                    tGPainter.setAntialias(false);
                    tGPainter.moveTo(n8, i);
                    tGPainter.lineTo(n9, i);
                    tGPainter.closePath();
                }
                tGPainter.dispose();
                this.lastx = n8;
                this.lasty = n10 - n6;
            } else if (mouseEvent.y > n11 - 3 && mouseEvent.y < n11 + n7) {
                this.back = new Image((Device)TuxGuitar.instance().getDisplay(), n5 + 1, n7 + 1);
                TGPainter tGPainter = new TGPainter(new GC((Drawable)this.kit.getTablature()));
                tGPainter.copyArea(this.back, n8, n11);
                tGPainter.setForeground(this.kit.getTablature().getViewLayout().getResources().getLineColor());
                n3 -= 14;
                for (int i = n11; i <= n11 + n7; i += n4) {
                    if (n3 <= 0) continue;
                    if (i > mouseEvent.y + 5 || (n3 -= TGMeasureImpl.ACCIDENTAL_NOTES[((n3 -= TGMeasureImpl.ACCIDENTAL_NOTES[(n3 - 1) % 12] ? 2 : 1) - 1) % 12] ? 2 : 1) < n) break;
                    tGPainter.initPath();
                    tGPainter.setAntialias(false);
                    tGPainter.moveTo(n8, i);
                    tGPainter.lineTo(n9, i);
                    tGPainter.closePath();
                }
                tGPainter.dispose();
                this.lastx = n8;
                this.lasty = n11;
            }
        }
    }

    public void mouseUp(MouseEvent mouseEvent) {
        if (!(TuxGuitar.instance().isLocked() || ActionLock.isLocked() || this.kit.getTablature().isPainting())) {
            ActionLock.lock();
            ViewLayout.TrackPosition trackPosition = this.getTrackPosition(mouseEvent.y);
            if (trackPosition != null) {
                TGTrackImpl tGTrackImpl = this.kit.getTablature().getCaret().getTrack();
                TGMeasureImpl tGMeasureImpl = this.kit.getTablature().getCaret().getMeasure();
                if (tGMeasureImpl.getTs() != null) {
                    int n = tGTrackImpl.getString(tGTrackImpl.stringCount()).getValue();
                    int n2 = tGTrackImpl.getString(1).getValue() + 29;
                    int n3 = this.kit.getTablature().getViewLayout().getScoreLineSpacing();
                    int n4 = tGMeasureImpl.getTs().getPosition(8);
                    int n5 = tGMeasureImpl.getTs().getPosition(13) - tGMeasureImpl.getTs().getPosition(9);
                    int n6 = trackPosition.getPosY() + tGMeasureImpl.getTs().getPosition(8);
                    int n7 = n6 + n3 * 5;
                    if (mouseEvent.y >= n6 - n4 && mouseEvent.y < n7 + n5) {
                        int n8 = 0;
                        int n9 = FIRST_LINE_VALUES[tGMeasureImpl.getClef() - 1];
                        double d = (double)n4 / ((double)n3 / 2.0);
                        int n10 = 0;
                        while ((double)n10 < d) {
                            n9 += TGMeasureImpl.ACCIDENTAL_NOTES[(n9 + 1) % 12] ? 2 : 1;
                            ++n10;
                        }
                        float f = 0.0f;
                        float f2 = n6 - n4;
                        while (f2 <= (float)(n7 + n5)) {
                            if (n9 > 0) {
                                float f3 = Math.abs((float)mouseEvent.y - f2);
                                if (n8 == 0 || f3 < f) {
                                    n8 = n9;
                                    f = f3;
                                }
                                n9 -= TGMeasureImpl.ACCIDENTAL_NOTES[(n9 - 1) % 12] ? 2 : 1;
                            }
                            f2 = (float)((double)f2 + (double)n3 / 2.0);
                        }
                        if (n8 >= n && n8 <= n2) {
                            TGVoiceImpl tGVoiceImpl = this.findBestVoice(tGMeasureImpl, mouseEvent.x);
                            if (tGVoiceImpl != null && !this.removeNote(n8 = this.getRealValue(n8), tGVoiceImpl)) {
                                this.makeNote(tGVoiceImpl, this.getRealStart(tGVoiceImpl, mouseEvent.x), n8);
                            }
                            this.redrawTablature();
                        }
                    }
                }
            }
            ActionLock.unlock();
        }
    }

    private long getRealStart(TGVoiceImpl tGVoiceImpl, int n) {
        if (tGVoiceImpl.isEmpty()) {
            return tGVoiceImpl.getBeat().getStart();
        }
        TGMeasureImpl tGMeasureImpl = tGVoiceImpl.getBeatImpl().getMeasureImpl();
        long l = tGMeasureImpl.getHeaderImpl().getLeftSpacing(this.kit.getTablature().getViewLayout()) + tGMeasureImpl.getPosX() + tGVoiceImpl.getBeatImpl().getPosX() + tGVoiceImpl.getBeatImpl().getSpacing();
        long l2 = tGVoiceImpl.getBeat().getStart();
        long l3 = tGVoiceImpl.getDuration().getTime();
        long l4 = l2 + l3;
        if ((long)n > l) {
            return Math.min(l2 + ((long)n - l) * l3 / (long)tGVoiceImpl.getWidth(), l4 - 1L);
        }
        return l2;
    }

    private int getRealValue(int n) {
        int n2 = n;
        int n3 = this.kit.getTablature().getCaret().getMeasure().getKeySignature();
        if (n3 <= 7) {
            if (TGMeasureImpl.KEY_SIGNATURES[n3][TGMeasureImpl.ACCIDENTAL_SHARP_NOTES[n2 % 12]] == 2 && this.kit.isNatural()) {
                ++n2;
            } else if (TGMeasureImpl.KEY_SIGNATURES[n3][TGMeasureImpl.ACCIDENTAL_SHARP_NOTES[n2 % 12]] != 2 && !this.kit.isNatural() && TGMeasureImpl.ACCIDENTAL_NOTES[(n2 + 1) % 12]) {
                ++n2;
            }
        } else if (n3 > 7) {
            if (TGMeasureImpl.KEY_SIGNATURES[n3][TGMeasureImpl.ACCIDENTAL_FLAT_NOTES[n2 % 12]] == 3 && this.kit.isNatural()) {
                --n2;
            } else if (TGMeasureImpl.KEY_SIGNATURES[n3][TGMeasureImpl.ACCIDENTAL_FLAT_NOTES[n2 % 12]] != 3 && !this.kit.isNatural() && TGMeasureImpl.ACCIDENTAL_NOTES[(n2 - 1) % 12]) {
                --n2;
            }
        }
        return n2;
    }

    private boolean removeNote(int n, TGVoice tGVoice) {
        Iterator iterator = tGVoice.getNotes().iterator();
        while (iterator.hasNext()) {
            TGNoteImpl tGNoteImpl = (TGNoteImpl)iterator.next();
            if (tGNoteImpl.getRealValue() != n) continue;
            UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
            TGSongManager tGSongManager = this.kit.getTablature().getSongManager();
            tGSongManager.getMeasureManager().removeNote(tGNoteImpl);
            TuxGuitar.instance().getUndoableManager().addEdit(undoableMeasureGeneric.endUndo());
            TuxGuitar.instance().getFileHistory().setUnsavedFile();
            return true;
        }
        return false;
    }

    private void makeNote(TGVoice tGVoice, long l, int n) {
        Caret caret = this.kit.getTablature().getCaret();
        TGSongManager tGSongManager = this.kit.getTablature().getSongManager();
        TGTrackImpl tGTrackImpl = caret.getTrack();
        int n2 = this.findBestString(tGTrackImpl, tGVoice, n);
        if (n2 > 0) {
            UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
            TGNote tGNote = tGSongManager.getFactory().newNote();
            tGNote.setValue(n - tGTrackImpl.getString(n2).getValue());
            tGNote.setVelocity(caret.getVelocity());
            tGNote.setString(n2);
            TGDuration tGDuration = tGSongManager.getFactory().newDuration();
            caret.getDuration().copy(tGDuration);
            tGSongManager.getMeasureManager().addNote(tGVoice.getBeat(), tGNote, tGDuration, l, tGVoice.getIndex());
            caret.moveTo(caret.getTrack(), caret.getMeasure(), tGNote.getVoice().getBeat(), tGNote.getString());
            TuxGuitar.instance().getUndoableManager().addEdit(undoableMeasureGeneric.endUndo());
            TuxGuitar.instance().getFileHistory().setUnsavedFile();
            caret.getSelectedBeat().play();
        }
    }

    private void redrawTablature() {
        Caret caret = this.kit.getTablature().getCaret();
        this.kit.getTablature().getViewLayout().fireUpdate(caret.getMeasure().getNumber());
        TuxGuitar.instance().updateCache(true);
    }

    private int findBestString(TGTrack tGTrack, TGVoice tGVoice, int n) {
        Object object;
        int n2;
        int n3;
        ArrayList<TGString> arrayList = new ArrayList<TGString>();
        for (n3 = 1; n3 <= tGTrack.stringCount(); ++n3) {
            n2 = 0;
            TGString tGString = tGTrack.getString(n3);
            object = tGVoice.getNotes().iterator();
            while (object.hasNext()) {
                TGNote tGNote = (TGNote)object.next();
                if (tGNote.getString() != tGString.getNumber()) continue;
                n2 = 1;
            }
            if (n2 != 0) continue;
            arrayList.add(tGString);
        }
        n3 = -1;
        n2 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (TGString)arrayList.get(i);
            int n4 = n - ((TGString)object).getValue();
            if (n4 < 0 || n3 >= 0 && n4 >= n3) continue;
            n2 = ((TGString)object).getNumber();
            n3 = n4;
        }
        return n2;
    }

    public TGVoiceImpl findBestVoice(TGMeasureImpl tGMeasureImpl, int n) {
        TGBeat tGBeat;
        int n2 = this.kit.getTablature().getCaret().getVoice();
        int n3 = tGMeasureImpl.getHeaderImpl().getLeftSpacing(this.kit.getTablature().getViewLayout()) + tGMeasureImpl.getPosX();
        int n4 = -1;
        TGVoiceImpl tGVoiceImpl = null;
        TGDuration tGDuration = this.kit.getTablature().getCaret().getDuration();
        Iterator iterator = tGMeasureImpl.getBeats().iterator();
        while (iterator.hasNext()) {
            tGBeat = (TGBeatImpl)iterator.next();
            TGVoiceImpl tGVoiceImpl2 = ((TGBeatImpl)tGBeat).getVoiceImpl(n2);
            if (tGVoiceImpl2.isEmpty()) continue;
            int n5 = ((TGBeatImpl)tGBeat).getPosX() + ((TGBeatImpl)tGBeat).getSpacing();
            int n6 = n5 + tGVoiceImpl2.getWidth();
            long l = tGVoiceImpl2.getWidth();
            if (tGVoiceImpl2.isRestVoice()) {
                l = tGDuration.getTime() * (long)tGVoiceImpl2.getWidth() / tGVoiceImpl2.getDuration().getTime();
            }
            int n7 = n5;
            while (n7 < n6) {
                int n8 = Math.abs(n - (n3 + n7));
                if (n4 == -1 || n8 < n4) {
                    tGVoiceImpl = tGVoiceImpl2;
                    n4 = n8;
                }
                n7 = (int)((long)n7 + l);
            }
        }
        if (tGVoiceImpl == null && (tGBeat = this.kit.getTablature().getViewLayout().getSongManager().getMeasureManager().getFirstBeat(tGMeasureImpl.getBeats())) != null) {
            tGVoiceImpl = (TGVoiceImpl)tGBeat.getVoice(n2);
        }
        return tGVoiceImpl;
    }
}

