/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab.edit;

import java.util.Iterator;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.TGBeatImpl;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.editors.tab.TGTrackImpl;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.editors.tab.edit.MouseKit;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.models.TGString;

public class EditorKit
implements MouseListener,
MouseMoveListener,
MouseTrackListener,
MenuListener {
    public static final int MOUSE_MODE_SELECTION = 1;
    public static final int MOUSE_MODE_EDITION = 2;
    private int mouseMode;
    private boolean natural;
    private Tablature tablature;
    private MouseKit mouseKit;
    private Point position;
    private boolean menuOpen;

    public EditorKit(Tablature tablature) {
        this.tablature = tablature;
        this.mouseKit = new MouseKit(this);
        this.position = new Point(0, 0);
        this.menuOpen = false;
        this.tablature.addMouseListener(this);
        this.tablature.addMouseMoveListener(this);
        this.tablature.addMouseTrackListener(this);
        this.setDefaults();
    }

    private void setDefaults() {
        this.setMouseMode(TuxGuitar.instance().getConfig().getIntConfigValue("editor.mouse.mode", 2));
        this.setNatural(TuxGuitar.instance().getConfig().getBooleanConfigValue("editor.natural.key.mode", true));
    }

    public int getMouseMode() {
        return this.mouseMode;
    }

    public void setMouseMode(int n) {
        this.mouseMode = n;
    }

    public boolean isNatural() {
        return this.natural;
    }

    public void setNatural(boolean bl) {
        this.natural = bl;
    }

    public Tablature getTablature() {
        return this.tablature;
    }

    public void tryBack() {
        this.mouseKit.tryBack();
    }

    public boolean select() {
        TGMeasureImpl tGMeasureImpl;
        TGTrackImpl tGTrackImpl;
        int n = this.position.x;
        int n2 = this.position.y;
        if (n >= 0 && n2 >= 0 && (tGTrackImpl = this.findSelectedTrack(n2)) != null && (tGMeasureImpl = this.findSelectedMeasure(tGTrackImpl, n, n2)) != null) {
            TGBeatImpl tGBeatImpl = this.findSelectedBeat(tGMeasureImpl, n);
            TGString tGString = this.findSelectedString(tGMeasureImpl, n2);
            if (tGBeatImpl != null) {
                int n3 = tGString != null ? tGString.getNumber() : this.getTablature().getCaret().getSelectedString().getNumber();
                this.getTablature().getCaret().moveTo(tGTrackImpl, tGMeasureImpl, tGBeatImpl, n3);
            }
            return true;
        }
        return false;
    }

    private boolean isScoreEnabled() {
        return (this.getTablature().getViewLayout().getStyle() & 4) != 0;
    }

    public TGTrackImpl findSelectedTrack(int n) {
        ViewLayout viewLayout = this.getTablature().getViewLayout();
        int n2 = viewLayout.getTrackNumberAt(n);
        if (n2 >= 0) {
            return (TGTrackImpl)viewLayout.getSongManager().getTrack(n2);
        }
        return null;
    }

    public TGMeasureImpl findSelectedMeasure(TGTrackImpl tGTrackImpl, int n, int n2) {
        TGMeasureImpl tGMeasureImpl = null;
        int n3 = 0;
        Iterator iterator = tGTrackImpl.getMeasures();
        while (iterator.hasNext()) {
            boolean bl;
            TGMeasureImpl tGMeasureImpl2 = (TGMeasureImpl)iterator.next();
            if (tGMeasureImpl2.isOutOfBounds() || tGMeasureImpl2.getTs() == null || !(bl = n >= tGMeasureImpl2.getPosX() && n <= tGMeasureImpl2.getPosX() + tGMeasureImpl2.getWidth(this.getTablature().getViewLayout()) + tGMeasureImpl2.getSpacing())) continue;
            int n4 = tGMeasureImpl2.getTs().getSize();
            int n5 = Math.min(Math.abs(n2 - tGMeasureImpl2.getPosY()), Math.abs(n2 - (tGMeasureImpl2.getPosY() + n4 - 10)));
            if (tGMeasureImpl != null && n5 >= n3) continue;
            tGMeasureImpl = tGMeasureImpl2;
            n3 = n5;
        }
        return tGMeasureImpl;
    }

    public TGBeatImpl findSelectedBeat(TGMeasureImpl tGMeasureImpl, int n) {
        int n2 = this.getTablature().getCaret().getVoice();
        int n3 = tGMeasureImpl.getHeaderImpl().getLeftSpacing(this.getTablature().getViewLayout()) + tGMeasureImpl.getPosX();
        int n4 = -1;
        TGBeatImpl tGBeatImpl = null;
        Iterator iterator = tGMeasureImpl.getBeats().iterator();
        while (iterator.hasNext()) {
            TGBeatImpl tGBeatImpl2 = (TGBeatImpl)iterator.next();
            if (tGBeatImpl2.getVoice(n2).isEmpty()) continue;
            int n5 = Math.abs(n - (n3 + (tGBeatImpl2.getPosX() + tGBeatImpl2.getSpacing())));
            if (n4 != -1 && n5 >= n4) continue;
            tGBeatImpl = tGBeatImpl2;
            n4 = n5;
        }
        if (tGBeatImpl == null) {
            tGBeatImpl = (TGBeatImpl)this.getTablature().getViewLayout().getSongManager().getMeasureManager().getFirstBeat(tGMeasureImpl.getBeats());
        }
        return tGBeatImpl;
    }

    public TGString findSelectedString(TGMeasureImpl tGMeasureImpl, int n) {
        TGString tGString = null;
        int n2 = this.getTablature().getViewLayout().getStringSpacing();
        int n3 = 0;
        int n4 = tGMeasureImpl.getPosY() + tGMeasureImpl.getTs().getPosition(13);
        Iterator iterator = tGMeasureImpl.getTrack().getStrings().iterator();
        while (iterator.hasNext()) {
            TGString tGString2 = (TGString)iterator.next();
            int n5 = Math.abs(n - (n4 + (tGString2.getNumber() * n2 - n2)));
            if (tGString != null && n5 >= n3) continue;
            tGString = tGString2;
            n3 = n5;
        }
        return tGString;
    }

    public void mouseDown(MouseEvent mouseEvent) {
        this.position.x = mouseEvent.x;
        this.position.y = mouseEvent.y;
    }

    public void mouseUp(MouseEvent mouseEvent) {
        this.position.x = mouseEvent.x;
        this.position.y = mouseEvent.y;
        this.tablature.setFocus();
        if (this.select()) {
            TuxGuitar.instance().updateCache(true);
            if (!this.menuOpen && mouseEvent.button == 1 && !TuxGuitar.instance().getPlayer().isRunning() && this.isScoreEnabled() && this.getMouseMode() == 2) {
                this.mouseKit.mouseUp(mouseEvent);
            }
        }
    }

    public void mouseMove(MouseEvent mouseEvent) {
        if (!this.menuOpen && !TuxGuitar.instance().getPlayer().isRunning() && this.isScoreEnabled() && this.getMouseMode() == 2) {
            this.mouseKit.mouseMove(mouseEvent);
        }
    }

    public void mouseExit(MouseEvent mouseEvent) {
        if (!this.menuOpen && !TuxGuitar.instance().getPlayer().isRunning() && this.isScoreEnabled() && this.getMouseMode() == 2) {
            this.mouseKit.mouseExit();
        }
    }

    public void menuShown(MenuEvent menuEvent) {
        this.menuOpen = true;
        this.select();
        TuxGuitar.instance().updateCache(true);
    }

    public void menuHidden(MenuEvent menuEvent) {
        this.menuOpen = false;
        TuxGuitar.instance().updateCache(true);
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void mouseEnter(MouseEvent mouseEvent) {
    }

    public void mouseHover(MouseEvent mouseEvent) {
    }
}

