/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.piano;

import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.ActionLock;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.editors.piano.PianoConfig;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.TGNoteImpl;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGVoice;

public class Piano
extends Composite {
    private static final boolean[] TYPE_NOTES = new boolean[]{true, false, true, false, true, true, false, true, false, true, false, true};
    private static final int NATURAL_NOTES = 7;
    private static final int MAX_OCTAVES = 8;
    private static final int NATURAL_WIDTH = 15;
    private static final int SHARP_WIDTH = 8;
    private static final int NATURAL_HEIGHT = 60;
    private static final int SHARP_HEIGHT = 40;
    private int duration;
    private boolean changes;
    private PianoListener listener;
    private PianoConfig config;
    private Composite pianoComposite;
    private Composite toolComposite;
    private Label durationLabel;
    private Label scaleName;
    private Button scale;
    private Button settings;
    protected TGBeat beat;
    protected TGBeat externalBeat;
    protected Image image;

    public Piano(Composite composite, int n) {
        super(composite, n);
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(4, 4, true, true));
        this.listener = new PianoListener();
        this.config = new PianoConfig();
        this.config.load();
        this.initToolBar();
        this.makePiano();
        this.loadIcons();
        this.loadProperties();
        TuxGuitar.instance().getkeyBindingManager().appendListenersTo((Control)this.toolComposite);
        TuxGuitar.instance().getkeyBindingManager().appendListenersTo((Control)this.pianoComposite);
    }

    private void initToolBar() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.numColumns = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.toolComposite = new Composite((Composite)this, 0);
        ++gridLayout.numColumns;
        Button button = new Button(this.toolComposite, 16388);
        button.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.caret.go-left"));
        ++gridLayout.numColumns;
        Button button2 = new Button(this.toolComposite, 131076);
        button2.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.caret.go-right"));
        ++gridLayout.numColumns;
        this.makeToolSeparator(this.toolComposite);
        ++gridLayout.numColumns;
        Button button3 = new Button(this.toolComposite, 132);
        button3.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.decrement-duration"));
        ++gridLayout.numColumns;
        this.durationLabel = new Label(this.toolComposite, 2048);
        ++gridLayout.numColumns;
        Button button4 = new Button(this.toolComposite, 1028);
        button4.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.increment-duration"));
        ++gridLayout.numColumns;
        this.makeToolSeparator(this.toolComposite);
        ++gridLayout.numColumns;
        this.scale = new Button(this.toolComposite, 8);
        this.scale.setText(TuxGuitar.getProperty("scale"));
        this.scale.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.tools.scale"));
        ++gridLayout.numColumns;
        this.scaleName = new Label(this.toolComposite, 16384);
        ++gridLayout.numColumns;
        this.settings = new Button(this.toolComposite, 8);
        this.settings.setImage(TuxGuitar.instance().getIconManager().getSettings());
        this.settings.setToolTipText(TuxGuitar.getProperty("settings"));
        this.settings.setLayoutData((Object)new GridData(131072, 4, true, true));
        this.settings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Piano.this.configure();
            }
        });
        this.toolComposite.setLayout((Layout)gridLayout);
        this.toolComposite.setLayoutData((Object)new GridData(4, 128, true, true));
    }

    private void makeToolSeparator(Composite composite) {
        Label label = new Label(composite, 2);
        label.setLayoutData((Object)new GridData(20, 20));
    }

    private void loadDurationImage(boolean bl) {
        int n = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getDuration().getValue();
        if (bl || this.duration != n) {
            this.duration = n;
            this.durationLabel.setImage(TuxGuitar.instance().getIconManager().getDuration(this.duration));
        }
    }

    private void loadScaleName() {
        int n = TuxGuitar.instance().getScaleManager().getSelectionKey();
        int n2 = TuxGuitar.instance().getScaleManager().getSelectionIndex();
        String string = TuxGuitar.instance().getScaleManager().getKeyName(n);
        String string2 = TuxGuitar.instance().getScaleManager().getScaleName(n2);
        this.scaleName.setText(string != null && string2 != null ? string + " - " + string2 : "");
        this.scaleName.pack();
    }

    private void makePiano() {
        this.image = this.makePianoImage();
        this.pianoComposite = new Composite((Composite)this, 0x20000800);
        this.pianoComposite.setLayout((Layout)new GridLayout());
        this.pianoComposite.setLayoutData((Object)new GridData(840, 60));
        this.pianoComposite.addPaintListener((PaintListener)this.listener);
        this.pianoComposite.addMouseListener((MouseListener)this.listener);
        this.pianoComposite.setFocus();
    }

    private Image makePianoImage() {
        Image image = new Image((Device)this.getDisplay(), 840, 60);
        TGPainter tGPainter = new TGPainter(new GC((Drawable)image));
        int n = 0;
        boolean bl = false;
        tGPainter.setBackground(this.config.getColorNatural());
        tGPainter.initPath(2);
        tGPainter.addRectangle(n, (float)bl, 840.0f, 60.0f);
        tGPainter.closePath();
        for (int i = 0; i < 8 * TYPE_NOTES.length; ++i) {
            if (TYPE_NOTES[i % TYPE_NOTES.length]) {
                tGPainter.setForeground(this.config.getColorNotNatural());
                tGPainter.initPath();
                tGPainter.setAntialias(false);
                tGPainter.addRectangle(n, (float)bl, 15.0f, 60.0f);
                tGPainter.closePath();
                n += 15;
                continue;
            }
            tGPainter.setBackground(this.config.getColorNotNatural());
            tGPainter.initPath(2);
            tGPainter.setAntialias(false);
            tGPainter.addRectangle(n - 4, (float)bl, 8.0f, 40.0f);
            tGPainter.closePath();
        }
        this.paintScale(tGPainter);
        tGPainter.dispose();
        return image;
    }

    private void paintScale(TGPainter tGPainter) {
        tGPainter.setBackground(this.config.getColorScale());
        tGPainter.setForeground(this.config.getColorScale());
        int n = 0;
        for (int i = 0; i < 8 * TYPE_NOTES.length; ++i) {
            int n2 = 0;
            if (TYPE_NOTES[i % TYPE_NOTES.length]) {
                n2 = 15;
                if (i > 0 && !TYPE_NOTES[(i - 1) % TYPE_NOTES.length]) {
                    n2 -= 4;
                }
                if (!TYPE_NOTES[(i + 1) % TYPE_NOTES.length]) {
                    n2 -= 4;
                }
            } else {
                n2 = 8;
            }
            if (TuxGuitar.instance().getScaleManager().getScale().getNote(i)) {
                if (TYPE_NOTES[i % TYPE_NOTES.length]) {
                    int n3 = n;
                    if (i > 0 && !TYPE_NOTES[(i - 1) % TYPE_NOTES.length]) {
                        n3 -= 4;
                    }
                    int n4 = 8;
                    tGPainter.initPath(2);
                    tGPainter.setAntialias(false);
                    tGPainter.addRectangle(n3 + 1 + (15 - n4) / 2, 60 - n4 - (15 - n4) / 2, n4, n4);
                    tGPainter.closePath();
                } else {
                    tGPainter.initPath(2);
                    tGPainter.setAntialias(false);
                    tGPainter.addRectangle(n + 1, 33.0f, 6.0f, 6.0f);
                    tGPainter.closePath();
                }
            }
            n += n2;
        }
    }

    protected void paintNote(TGPainter tGPainter, int n) {
        tGPainter.setBackground(this.config.getColorNote());
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < 8 * TYPE_NOTES.length; ++i) {
            int n4 = 0;
            if (TYPE_NOTES[i % TYPE_NOTES.length]) {
                n4 = 15;
                if (i > 0 && !TYPE_NOTES[(i - 1) % TYPE_NOTES.length]) {
                    n4 -= 4;
                }
                if (!TYPE_NOTES[(i + 1) % TYPE_NOTES.length]) {
                    n4 -= 4;
                }
            } else {
                n4 = 8;
            }
            if (i == n) {
                if (TYPE_NOTES[i % TYPE_NOTES.length]) {
                    tGPainter.initPath(2);
                    tGPainter.setAntialias(false);
                    tGPainter.addRectangle(n2 + 1, n3 + 1, n4 - 1, 40.0f);
                    int n5 = n2;
                    if (i > 0 && !TYPE_NOTES[(i - 1) % TYPE_NOTES.length]) {
                        n5 -= 4;
                    }
                    tGPainter.addRectangle(n5 + 1, n3 + 40 + 1, 14.0f, 19.0f);
                    tGPainter.closePath();
                } else {
                    tGPainter.initPath(2);
                    tGPainter.setAntialias(false);
                    tGPainter.addRectangle(n2 + 1, n3 + 1, n4 - 1, 39.0f);
                    tGPainter.closePath();
                }
            }
            n2 += n4;
        }
    }

    private int getSelection(Point point) {
        int n = 0;
        for (int i = 0; i < 8 * TYPE_NOTES.length; ++i) {
            int n2 = 0;
            if (TYPE_NOTES[i % TYPE_NOTES.length]) {
                n2 = 15;
                if (i > 0 && !TYPE_NOTES[(i - 1) % TYPE_NOTES.length]) {
                    n2 -= 4;
                }
                if (!TYPE_NOTES[(i + 1) % TYPE_NOTES.length]) {
                    n2 -= 4;
                }
            } else {
                n2 = 8;
            }
            if (point.x >= n && point.x < n + n2) {
                return i;
            }
            n += n2;
        }
        return -1;
    }

    protected void hit(int n, int n2) {
        int n3 = this.getSelection(new Point(n, n2));
        if (!this.removeNote(n3)) {
            this.addNote(n3);
        }
    }

    private boolean removeNote(int n) {
        if (this.beat != null) {
            for (int i = 0; i < this.beat.countVoices(); ++i) {
                TGVoice tGVoice = this.beat.getVoice(i);
                Iterator iterator = tGVoice.getNotes().iterator();
                while (iterator.hasNext()) {
                    TGNote tGNote = (TGNote)iterator.next();
                    if (this.getRealNoteValue(tGNote) != n) continue;
                    UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
                    TGSongManager tGSongManager = TuxGuitar.instance().getSongManager();
                    tGSongManager.getMeasureManager().removeNote(tGNote);
                    TuxGuitar.instance().getUndoableManager().addEdit(undoableMeasureGeneric.endUndo());
                    TuxGuitar.instance().getFileHistory().setUnsavedFile();
                    return true;
                }
            }
        }
        return false;
    }

    private boolean addNote(int n) {
        Caret caret = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
        List list = caret.getTrack().getStrings();
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            Object object2;
            Object object3;
            TGString tGString = (TGString)list.get(i);
            if (n < tGString.getValue()) continue;
            boolean bl = true;
            if (this.beat != null) {
                block1: for (int j = 0; j < this.beat.countVoices(); ++j) {
                    object3 = this.beat.getVoice(j);
                    object2 = ((TGVoice)object3).getNotes().iterator();
                    while (object2.hasNext()) {
                        object = (TGNoteImpl)object2.next();
                        if (((TGNote)object).getString() != tGString.getNumber()) continue;
                        bl = false;
                        continue block1;
                    }
                }
            }
            if (!bl) continue;
            TGSongManager tGSongManager = TuxGuitar.instance().getSongManager();
            object3 = UndoableMeasureGeneric.startUndo();
            object2 = tGSongManager.getFactory().newNote();
            ((TGNote)object2).setValue(n - tGString.getValue());
            ((TGNote)object2).setVelocity(caret.getVelocity());
            ((TGNote)object2).setString(tGString.getNumber());
            object = tGSongManager.getFactory().newDuration();
            caret.getDuration().copy((TGDuration)object);
            tGSongManager.getMeasureManager().addNote(caret.getMeasure(), caret.getPosition(), (TGNote)object2, (TGDuration)object, caret.getVoice());
            TuxGuitar.instance().getUndoableManager().addEdit(((UndoableMeasureGeneric)object3).endUndo());
            TuxGuitar.instance().getFileHistory().setUnsavedFile();
            caret.getSelectedBeat().play();
            return true;
        }
        return false;
    }

    protected void afterAction() {
        int n = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getMeasure().getNumber();
        TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(n);
        TuxGuitar.instance().updateCache(true);
    }

    protected int getRealNoteValue(TGNote tGNote) {
        TGTrack tGTrack;
        Object object;
        Object object2;
        TGVoice tGVoice = tGNote.getVoice();
        if (tGVoice != null && (object2 = tGVoice.getBeat()) != null && (object = ((TGBeat)object2).getMeasure()) != null && (tGTrack = ((TGMeasure)object).getTrack()) != null) {
            return tGNote.getValue() + tGTrack.getString(tGNote.getString()).getValue();
        }
        object2 = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
        object = ((Caret)object2).getTrack();
        if (object != null) {
            return tGNote.getValue() + ((TGTrack)object).getString(tGNote.getString()).getValue();
        }
        return 0;
    }

    public boolean hasChanges() {
        return this.changes;
    }

    public void setChanges(boolean bl) {
        this.changes = bl;
    }

    public void setExternalBeat(TGBeat tGBeat) {
        this.externalBeat = tGBeat;
    }

    public TGBeat getExternalBeat() {
        return this.externalBeat;
    }

    protected void updateEditor() {
        if (this.isVisible()) {
            if (this.hasChanges()) {
                this.image.dispose();
                this.image = this.makePianoImage();
            }
            this.beat = TuxGuitar.instance().getPlayer().isRunning() ? TuxGuitar.instance().getEditorCache().getPlayBeat() : (this.externalBeat != null ? this.externalBeat : TuxGuitar.instance().getEditorCache().getEditBeat());
        }
    }

    public void redraw() {
        if (!super.isDisposed() && !TuxGuitar.instance().isLocked()) {
            super.redraw();
            this.pianoComposite.redraw();
            this.loadDurationImage(false);
        }
    }

    public void redrawPlayingMode() {
        if (!super.isDisposed() && !TuxGuitar.instance().isLocked()) {
            this.pianoComposite.redraw();
        }
    }

    public void dispose() {
        super.dispose();
        this.image.dispose();
        this.config.dispose();
    }

    public void loadProperties() {
        this.scale.setText(TuxGuitar.getProperty("scale"));
        this.settings.setToolTipText(TuxGuitar.getProperty("settings"));
        this.loadScaleName();
        this.layout(true, true);
    }

    public void loadIcons() {
        this.getShell().setImage(TuxGuitar.instance().getIconManager().getAppIcon());
        this.settings.setImage(TuxGuitar.instance().getIconManager().getSettings());
        this.loadDurationImage(true);
        this.layout(true, true);
    }

    public void loadScale() {
        this.loadScaleName();
        this.setChanges(true);
    }

    protected void configure() {
        this.config.configure(this.getShell());
        this.setChanges(true);
        this.redraw();
    }

    public Composite getPianoComposite() {
        return this.pianoComposite;
    }

    private class PianoListener
    implements PaintListener,
    MouseListener {
        public void paintControl(PaintEvent paintEvent) {
            if (!TuxGuitar.instance().isLocked()) {
                TuxGuitar.instance().lock();
                Piano.this.updateEditor();
                TGPainter tGPainter = new TGPainter(paintEvent.gc);
                tGPainter.drawImage(Piano.this.image, 0, 0);
                if (Piano.this.beat != null) {
                    for (int i = 0; i < Piano.this.beat.countVoices(); ++i) {
                        TGVoice tGVoice = Piano.this.beat.getVoice(i);
                        Iterator iterator = tGVoice.getNotes().iterator();
                        while (iterator.hasNext()) {
                            TGNote tGNote = (TGNote)iterator.next();
                            Piano.this.paintNote(tGPainter, Piano.this.getRealNoteValue(tGNote));
                        }
                    }
                }
                TuxGuitar.instance().unlock();
            }
        }

        public void mouseUp(MouseEvent mouseEvent) {
            Piano.this.getPianoComposite().setFocus();
            if (mouseEvent.button == 1) {
                if (!(TuxGuitar.instance().getPlayer().isRunning() || TuxGuitar.instance().isLocked() || ActionLock.isLocked())) {
                    ActionLock.lock();
                    if (Piano.this.getExternalBeat() == null) {
                        Piano.this.hit(mouseEvent.x, mouseEvent.y);
                    } else {
                        Piano.this.setExternalBeat(null);
                    }
                    Piano.this.afterAction();
                    ActionLock.unlock();
                }
            } else {
                TuxGuitar.instance().getAction("action.caret.go-right").process((TypedEvent)mouseEvent);
            }
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
        }

        public void mouseDown(MouseEvent mouseEvent) {
        }
    }
}

