/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.effects;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.song.models.TGBeat;

public class StrokeEditor
extends SelectionAdapter {
    public static final int WIDTH = 400;
    public static final int HEIGHT = 0;
    public static final int STATUS_OK = 1;
    public static final int STATUS_CLEAN = 2;
    public static final int STATUS_CANCEL = 3;
    private Button duration4;
    private Button duration8;
    private Button duration16;
    private Button duration32;
    private Button duration64;
    private int status;
    private int value;

    public void open(TGBeat tGBeat) {
        this.status = 3;
        final Shell shell = DialogUtils.newDialog(TuxGuitar.instance().getShell(), 67680);
        shell.setLayout((Layout)new GridLayout());
        shell.setText(TuxGuitar.getProperty("beat.stroke"));
        int n = 16;
        if (tGBeat.getStroke().getDirection() != 0) {
            n = tGBeat.getStroke().getValue();
        }
        Group group = new Group((Composite)shell, 16);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new GridLayout(5, false));
        group.setText(TuxGuitar.getProperty("duration"));
        this.duration64 = new Button((Composite)group, 16);
        this.duration64.setImage(TuxGuitar.instance().getIconManager().getDuration(64));
        this.duration64.setLayoutData((Object)new GridData(4, 4, true, true));
        this.duration64.setSelection(n == 64);
        this.duration32 = new Button((Composite)group, 16);
        this.duration32.setImage(TuxGuitar.instance().getIconManager().getDuration(32));
        this.duration32.setLayoutData((Object)new GridData(4, 4, true, true));
        this.duration32.setSelection(n == 32);
        this.duration16 = new Button((Composite)group, 16);
        this.duration16.setImage(TuxGuitar.instance().getIconManager().getDuration(16));
        this.duration16.setLayoutData((Object)new GridData(4, 4, true, true));
        this.duration16.setSelection(n == 16);
        this.duration8 = new Button((Composite)group, 16);
        this.duration8.setImage(TuxGuitar.instance().getIconManager().getDuration(8));
        this.duration8.setLayoutData((Object)new GridData(4, 4, true, true));
        this.duration8.setSelection(n == 8);
        this.duration4 = new Button((Composite)group, 16);
        this.duration4.setImage(TuxGuitar.instance().getIconManager().getDuration(4));
        this.duration4.setLayoutData((Object)new GridData(4, 4, true, true));
        this.duration4.setSelection(n == 4);
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(0x1000008, 1024, true, true));
        Button button = new Button(composite, 8);
        button.setText(TuxGuitar.getProperty("ok"));
        button.setLayoutData((Object)this.getButtonData());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StrokeEditor.this.setStatus(1);
                StrokeEditor.this.setValue(StrokeEditor.this.getSelection());
                shell.dispose();
            }
        });
        Button button2 = new Button(composite, 8);
        button2.setText(TuxGuitar.getProperty("clean"));
        button2.setLayoutData((Object)this.getButtonData());
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StrokeEditor.this.setStatus(2);
                shell.dispose();
            }
        });
        Button button3 = new Button(composite, 8);
        button3.setText(TuxGuitar.getProperty("cancel"));
        button3.setLayoutData((Object)this.getButtonData());
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StrokeEditor.this.setStatus(3);
                shell.dispose();
            }
        });
        shell.setDefaultButton(button);
        DialogUtils.openDialog(shell, 11);
    }

    protected GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    protected int getSelection() {
        if (this.duration4.getSelection()) {
            return 4;
        }
        if (this.duration8.getSelection()) {
            return 8;
        }
        if (this.duration16.getSelection()) {
            return 16;
        }
        if (this.duration32.getSelection()) {
            return 32;
        }
        if (this.duration64.getSelection()) {
            return 64;
        }
        return 0;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = n;
    }
}

