/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.chord;

public class ChordSettings {
    private static ChordSettings instance;
    private boolean emptyStringChords = false;
    private float bassGrade = 200.0f;
    private float fingeringGrade = 150.0f;
    private float subsequentGrade = 200.0f;
    private float requiredBasicsGrade = 150.0f;
    private float manyStringsGrade = 100.0f;
    private float goodChordSemanticsGrade = 200.0f;
    private int chordsToDisplay = 30;
    private int howManyIncompleteChords = 4;
    private int chordTypeIndex = 0;
    private int findChordsMin = 0;
    private int findChordsMax = 15;

    private ChordSettings() {
    }

    public static ChordSettings instance() {
        if (instance == null) {
            instance = new ChordSettings();
        }
        return instance;
    }

    public float getBassGrade() {
        return this.bassGrade;
    }

    public void setBassGrade(float f) {
        this.bassGrade = f;
    }

    public int getChordsToDisplay() {
        return this.chordsToDisplay;
    }

    public void setChordsToDisplay(int n) {
        this.chordsToDisplay = n;
    }

    public boolean isEmptyStringChords() {
        return this.emptyStringChords;
    }

    public void setEmptyStringChords(boolean bl) {
        this.emptyStringChords = bl;
    }

    public float getFingeringGrade() {
        return this.fingeringGrade;
    }

    public void setFingeringGrade(float f) {
        this.fingeringGrade = f;
    }

    public float getGoodChordSemanticsGrade() {
        return this.goodChordSemanticsGrade;
    }

    public void setGoodChordSemanticsGrade(float f) {
        this.goodChordSemanticsGrade = f;
    }

    public float getManyStringsGrade() {
        return this.manyStringsGrade;
    }

    public void setManyStringsGrade(float f) {
        this.manyStringsGrade = f;
    }

    public float getRequiredBasicsGrade() {
        return this.requiredBasicsGrade;
    }

    public void setRequiredBasicsGrade(float f) {
        this.requiredBasicsGrade = f;
    }

    public float getSubsequentGrade() {
        return this.subsequentGrade;
    }

    public void setSubsequentGrade(float f) {
        this.subsequentGrade = f;
    }

    public int getIncompleteChords() {
        return this.howManyIncompleteChords;
    }

    public void setIncompleteChords(int n) {
        this.howManyIncompleteChords = n;
    }

    public int getFindChordsMin() {
        return this.findChordsMin;
    }

    public void setFindChordsMin(int n) {
        this.findChordsMin = n;
    }

    public int getFindChordsMax() {
        return this.findChordsMax;
    }

    public void setFindChordsMax(int n) {
        this.findChordsMax = n;
    }

    public int getChordTypeIndex() {
        return this.chordTypeIndex;
    }

    public void setChordTypeIndex(int n) {
        switch (n) {
            case 0: {
                this.bassGrade = 200.0f;
                this.fingeringGrade = 150.0f;
                this.subsequentGrade = 200.0f;
                this.requiredBasicsGrade = 150.0f;
                this.manyStringsGrade = 100.0f;
                this.goodChordSemanticsGrade = 200.0f;
                break;
            }
            case 1: {
                this.bassGrade = -100.0f;
                this.fingeringGrade = 150.0f;
                this.subsequentGrade = 200.0f;
                this.requiredBasicsGrade = 150.0f;
                this.manyStringsGrade = 50.0f;
                this.goodChordSemanticsGrade = 200.0f;
                break;
            }
            case 2: {
                this.bassGrade = 50.0f;
                this.fingeringGrade = 200.0f;
                this.subsequentGrade = 350.0f;
                this.requiredBasicsGrade = 150.0f;
                this.manyStringsGrade = -100.0f;
                this.goodChordSemanticsGrade = 200.0f;
                break;
            }
            case 3: {
                this.bassGrade = 100.0f;
                this.fingeringGrade = 100.0f;
                this.subsequentGrade = -80.0f;
                this.requiredBasicsGrade = 100.0f;
                this.manyStringsGrade = -80.0f;
                this.goodChordSemanticsGrade = 200.0f;
            }
        }
        this.chordTypeIndex = n;
    }
}

