/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.chord;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.herac.tuxguitar.gui.editors.chord.ChordDatabase;
import org.herac.tuxguitar.gui.editors.chord.ChordDialog;
import org.herac.tuxguitar.gui.editors.chord.ChordNamingConvention;
import org.herac.tuxguitar.gui.editors.chord.ChordSettings;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.util.TGSynchronizer;

public class ChordRecognizer
extends Composite {
    protected static final int TONIC_INDEX = 0;
    protected static final int CHORD_INDEX = 1;
    protected static final int ALTERATION_INDEX = 2;
    protected static final int PLUSMINUS_INDEX = 3;
    protected static final int BASS_INDEX = 4;
    protected static final int ADDCHK_INDEX = 5;
    protected static final int I5_INDEX = 6;
    protected static final int I9_INDEX = 7;
    protected static final int I11_INDEX = 8;
    private ChordDialog dialog;
    private org.eclipse.swt.widgets.List proposalList;
    private List proposalParameters;
    private long runningProcess;

    public ChordRecognizer(ChordDialog chordDialog, Composite composite, int n) {
        super(composite, n);
        this.setLayout((Layout)chordDialog.gridLayout(1, false, 0, 0));
        this.setLayoutData(this.makeGridData());
        this.runningProcess = 0L;
        this.dialog = chordDialog;
        this.init();
    }

    public GridData makeGridData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 180;
        return gridData;
    }

    public void init() {
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.proposalParameters = new ArrayList();
        this.proposalList = new org.eclipse.swt.widgets.List(composite, 2816);
        this.proposalList.setLayoutData((Object)new GridData(4, 4, true, true));
        this.proposalList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ChordRecognizer.this.getDialog().getEditor() != null) {
                    ChordRecognizer.this.showChord(ChordRecognizer.this.getProposalList().getSelectionIndex());
                }
            }
        });
    }

    protected void showChord(int n) {
        int[] nArray = (int[])this.proposalParameters.get(n);
        this.dialog.getSelector().adjustWidgets(nArray[0], nArray[1], nArray[2], nArray[4], nArray[3], nArray[5], nArray[6], nArray[7], nArray[8]);
        String string = this.proposalList.getItem(n);
        string = string.substring(0, string.indexOf(40) - 1);
        this.dialog.getEditor().getChordName().setText(string);
        this.dialog.getEditor().redraw();
    }

    public void recognize(final TGChord tGChord, final boolean bl, final boolean bl2) {
        final long l = ++this.runningProcess;
        final boolean bl3 = this.dialog.getSelector().getSharpButton().getSelection();
        this.clearProposals();
        new Thread(new Runnable(){

            public void run() {
                if (!ChordRecognizer.this.getDialog().isDisposed() && ChordRecognizer.this.isValidProcess(l)) {
                    final int[] nArray = ChordRecognizer.this.makeProposals(l, tGChord, bl3);
                    if (nArray == null) {
                        if (ChordRecognizer.this.isValidProcess(l) && bl2) {
                            try {
                                TGSynchronizer.instance().addRunnable(new TGSynchronizer.TGRunnable(){

                                    public void run() {
                                        if (!ChordRecognizer.this.getDialog().isDisposed() && ChordRecognizer.this.isValidProcess(l)) {
                                            ChordRecognizer.this.getDialog().getEditor().setChordName("");
                                        }
                                    }
                                });
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                            }
                        }
                        return;
                    }
                    final String string = ChordRecognizer.this.getChordName(nArray, bl3);
                    if (ChordRecognizer.this.isValidProcess(l) && bl) {
                        try {
                            TGSynchronizer.instance().addRunnable(new TGSynchronizer.TGRunnable(){

                                public void run() {
                                    if (!ChordRecognizer.this.getDialog().isDisposed()) {
                                        ChordRecognizer.this.redecorate(nArray);
                                    }
                                }
                            });
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                    if (ChordRecognizer.this.isValidProcess(l) && bl2) {
                        try {
                            TGSynchronizer.instance().addRunnable(new TGSynchronizer.TGRunnable(){

                                public void run() {
                                    if (!ChordRecognizer.this.getDialog().isDisposed()) {
                                        ChordRecognizer.this.getDialog().getEditor().setChordName(string != null ? string : "");
                                    }
                                }
                            });
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                }
            }
        }).start();
    }

    protected int[] makeProposals(final long l, TGChord tGChord, final boolean bl) {
        int n;
        int n2;
        List<Proposal> list;
        int n3;
        int[] nArray = this.dialog.getSelector().getTuning();
        ArrayList<List<Proposal>> arrayList = new ArrayList<List<Proposal>>();
        for (int i = 0; i < nArray.length; ++i) {
            n3 = tGChord.getStrings()[i];
            if (n3 == -1) continue;
            list = new Integer((nArray[nArray.length - 1 - i] + n3) % 12);
            Iterator iterator = arrayList.iterator();
            boolean bl2 = false;
            while (iterator.hasNext()) {
                if (!iterator.next().equals(list)) continue;
                bl2 = true;
            }
            if (bl2) continue;
            arrayList.add(list);
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>(10);
        for (n3 = 0; n3 < 12; ++n3) {
            list = null;
            for (int i = 0; i < ChordDatabase.length(); ++i) {
                Object object;
                ChordDatabase.ChordInfo chordInfo = ChordDatabase.get(i);
                list = new Proposal(arrayList);
                ((Proposal)((Object)list)).unusualGrade = ((Proposal)((Object)list)).unusualGrade - (i != ChordDatabase.length() && i != 4 ? 2 * i : 0);
                n2 = 0;
                for (n = 0; n < chordInfo.getRequiredNotes().length; ++n) {
                    object = arrayList.iterator();
                    while (object.hasNext()) {
                        if ((Integer)object.next() != (n3 + chordInfo.getRequiredNotes()[n] - 1) % 12) continue;
                        n2 = 1;
                        if (n3 + chordInfo.getRequiredNotes()[n] - 1 == n3) {
                            ((Proposal)((Object)list)).dontHaveGrade += 15;
                        }
                        ((Proposal)((Object)list)).foundNote(n3 + chordInfo.getRequiredNotes()[n] - 1);
                    }
                }
                if (n2 != 0) {
                    ((Proposal)((Object)list)).params[0] = n3;
                    ((Proposal)((Object)list)).params[1] = i;
                    n = ((Proposal)((Object)list)).missingNotes.length - ((Proposal)((Object)list)).missingCount;
                    if (!(chordInfo.getName().startsWith("dim") || chordInfo.getName().startsWith("aug") || ((Proposal)((Object)list)).isFound(n3 + 8 - 1))) {
                        if (((Proposal)((Object)list)).isNeeded(n3 + 7 - 1) || ((Proposal)((Object)list)).isNeeded(n3 + 9 - 1)) {
                            object = (Proposal)((Proposal)((Object)list)).clone();
                            if (((Proposal)object).isNeeded(n3 + 9 - 1)) {
                                ((Proposal)object).params[6] = 1;
                                ((Proposal)object).foundNote(n3 + 8);
                            } else {
                                ((Proposal)object).params[6] = 2;
                                ((Proposal)object).foundNote(n3 + 6);
                            }
                            ((Proposal)object).unusualGrade -= 35;
                            if (n + 1 >= chordInfo.getRequiredNotes().length - 1) {
                                ((Proposal)object).dontHaveGrade -= (chordInfo.getRequiredNotes().length - (n + 1)) * 50;
                                arrayList2.add(object);
                            }
                        } else {
                            ((Proposal)((Object)list)).params[6] = 0;
                            ((Proposal)((Object)list)).dontHaveGrade += 30;
                        }
                    }
                    ((Proposal)((Object)list)).params[6] = 0;
                    if (n >= chordInfo.getRequiredNotes().length - 1) {
                        ((Proposal)((Object)list)).dontHaveGrade -= (chordInfo.getRequiredNotes().length - n) * 50;
                        arrayList2.add(list);
                    }
                }
                list = null;
            }
        }
        Iterator iterator = arrayList2.iterator();
        list = new ArrayList(5);
        while (iterator.hasNext()) {
            Proposal proposal = (Proposal)iterator.next();
            boolean bl3 = true;
            for (n2 = tGChord.getStrings().length - 1; n2 >= 0; --n2) {
                if (tGChord.getStrings()[n2] == -1) continue;
                if (proposal.params[4] == -1) {
                    proposal.params[4] = (nArray[nArray.length - 1 - n2] + tGChord.getStrings()[n2]) % 12;
                    if (proposal.params[4] != proposal.params[0]) {
                        proposal.unusualGrade -= 20;
                    }
                }
                if (proposal.params[4] != (nArray[nArray.length - 1 - n2] + tGChord.getStrings()[n2]) % 12) continue;
                bl3 = false;
            }
            if (proposal.isNeeded(proposal.params[4]) && bl3) {
                proposal.foundNote(proposal.params[4]);
                proposal.unusualGrade -= 20;
            }
            if (proposal.missingCount > 0 && proposal.params[1] <= 11) {
                n2 = proposal.params[1] == 2 ? proposal.params[0] + 12 - 1 : proposal.params[0] + 11 - 1;
                if (proposal.isExisting(n2) && !proposal.isFound(n2)) {
                    proposal.filled[3] = true;
                    proposal.foundNote(n2);
                }
                for (n = 0; n <= 2; ++n) {
                    for (int i = 2; i >= 0; --i) {
                        if (!proposal.isNeeded(proposal.params[0] + this.getAddNote(i, n)) || proposal.filled[i]) continue;
                        proposal.filled[i] = true;
                        proposal.plusminusValue[i] = n;
                        if (n != 0) {
                            proposal.unusualGrade -= 15;
                        }
                        proposal.foundNote(proposal.params[0] + this.getAddNote(i, n));
                    }
                }
            }
            if (proposal.filled[3] && !proposal.filled[0] && !proposal.filled[1] && !proposal.filled[2] || proposal.missingCount != 0 || proposal.dontHaveGrade <= -51) continue;
            this.findChordLogic(proposal);
            list.add(proposal);
        }
        this.shellsort(list, 1);
        int n4 = -1;
        int n5 = ChordSettings.instance().getIncompleteChords();
        for (n2 = 0; n2 < list.size() && n4 == -1; ++n2) {
            n = ((Proposal)list.get((int)n2)).dontHaveGrade;
            if (n >= 0) continue;
            n4 = n2 + n5;
        }
        list = list.subList(0, n4 > 0 && n4 < list.size() ? n4 : list.size());
        this.shellsort(list, 2);
        n2 = 0;
        for (n = 0; n < list.size(); ++n) {
            final Proposal proposal = (Proposal)list.get(n);
            if (n2 == 0 && proposal.unusualGrade < 0) {
                n2 = proposal.unusualGrade;
            }
            if (proposal.unusualGrade <= (n2 >= 0 ? 0 : n2) - 60) continue;
            try {
                TGSynchronizer.instance().addRunnable(new TGSynchronizer.TGRunnable(){

                    public void run() {
                        if (!ChordRecognizer.this.getDialog().isDisposed() && ChordRecognizer.this.isValidProcess(l)) {
                            ChordRecognizer.this.addProposal(proposal.params, ChordRecognizer.this.getChordName(proposal.params, bl) + " (" + Math.round(100 + proposal.dontHaveGrade * 7 / 10) + "%)");
                        }
                    }
                });
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if (this.proposalParameters.size() == 0) {
            return null;
        }
        return (int[])this.proposalParameters.get(0);
    }

    protected void redecorate(int[] nArray) {
        this.dialog.getSelector().adjustWidgets(nArray[0], nArray[1], nArray[2], nArray[4], nArray[3], nArray[5], nArray[6], nArray[7], nArray[8]);
    }

    protected String getChordName(int[] nArray, boolean bl) {
        return new ChordNamingConvention().createChordName(nArray[0], nArray[1], nArray[2], nArray[3], nArray[5] != 0, nArray[6], nArray[7], nArray[8], nArray[4], bl);
    }

    protected int getAddNote(int n, int n2) {
        int n3 = 0;
        switch (n) {
            case 0: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 6;
                break;
            }
            case 2: {
                n3 = 10;
            }
        }
        switch (n2) {
            case 1: {
                ++n3;
                break;
            }
            case 2: {
                --n3;
                break;
            }
        }
        return --n3;
    }

    void findChordLogic(Proposal proposal) {
        boolean[] blArray = proposal.filled;
        int[] nArray = proposal.plusminusValue;
        proposal.params[2] = 0;
        proposal.params[7] = nArray[0];
        proposal.params[8] = nArray[1];
        proposal.params[5] = 0;
        proposal.params[3] = 0;
        if (blArray[2]) {
            proposal.params[2] = 3;
            proposal.params[3] = nArray[2];
            if (!(blArray[1] && blArray[0] && blArray[3])) {
                proposal.unusualGrade -= 10;
                if (!(blArray[1] || blArray[0] || blArray[3])) {
                    proposal.params[5] = 1;
                } else {
                    if (!blArray[3]) {
                        proposal.dontHaveGrade -= 25;
                    }
                    if (!blArray[1]) {
                        proposal.unusualGrade -= 30;
                        proposal.dontHaveGrade -= 10;
                    }
                    if (!blArray[0]) {
                        proposal.unusualGrade -= 30;
                        proposal.dontHaveGrade -= 10;
                    }
                }
            }
        } else if (blArray[1]) {
            proposal.params[2] = 2;
            proposal.params[3] = nArray[1];
            proposal.params[8] = 0;
            proposal.unusualGrade -= 10;
            if (!blArray[0] || !blArray[3]) {
                if (!blArray[0] && !blArray[3]) {
                    proposal.params[5] = 1;
                } else {
                    if (!blArray[3]) {
                        proposal.dontHaveGrade -= 25;
                    }
                    if (!blArray[0]) {
                        proposal.unusualGrade -= 30;
                        proposal.dontHaveGrade -= 10;
                    }
                }
            }
        } else if (blArray[0]) {
            proposal.params[2] = 1;
            proposal.params[7] = 0;
            proposal.params[8] = 0;
            proposal.params[3] = nArray[0];
            proposal.unusualGrade -= 10;
            if (!blArray[3]) {
                proposal.params[5] = 1;
            }
        }
    }

    public void shellsort(List list, int n) {
        int n2 = list.size();
        int n3 = n2 / 2;
        while (n3 > 0) {
            for (int i = n3; i < n2; ++i) {
                int n4;
                Proposal proposal = (Proposal)list.get(i);
                for (n4 = i; n4 >= n3 && (n == 1 ? proposal.dontHaveGrade > ((Proposal)list.get((int)(n4 - n3))).dontHaveGrade : proposal.unusualGrade > ((Proposal)list.get((int)(n4 - n3))).unusualGrade); n4 -= n3) {
                    list.set(n4, list.get(n4 - n3));
                }
                list.set(n4, proposal);
            }
            n3 = n3 == 2 ? 1 : (int)((double)n3 / 2.2);
        }
    }

    protected void addProposal(int[] nArray, String string) {
        this.proposalParameters.add(nArray);
        this.proposalList.add(string);
    }

    protected void clearProposals() {
        this.proposalList.removeAll();
        this.proposalParameters.clear();
    }

    protected ChordDialog getDialog() {
        return this.dialog;
    }

    protected org.eclipse.swt.widgets.List getProposalList() {
        return this.proposalList;
    }

    protected boolean isValidProcess(long l) {
        return this.runningProcess == l;
    }

    protected class Proposal
    implements Cloneable {
        int[] params;
        int unusualGrade = 0;
        int dontHaveGrade = -15;
        int missingCount;
        int[] missingNotes;
        boolean[] filled = new boolean[]{false, false, false, false};
        int[] plusminusValue = new int[]{0, 0, 0};

        private Proposal() {
            this.params = new int[9];
            for (int i = 0; i < 9; ++i) {
                this.params[i] = -1;
            }
        }

        public Proposal(List list) {
            int n;
            this.params = new int[9];
            for (n = 0; n < 9; ++n) {
                this.params[n] = -1;
            }
            n = list.size();
            this.missingNotes = new int[n];
            for (int i = 0; i < n; ++i) {
                this.missingNotes[i] = (Integer)list.get(i);
            }
            this.missingCount = n;
        }

        void foundNote(int n) {
            int n2 = n % 12;
            if (this.missingCount != 0) {
                for (int i = 0; i < this.missingCount; ++i) {
                    if (this.missingNotes[i] != n2) continue;
                    --this.missingCount;
                    int n3 = this.missingNotes[i];
                    this.missingNotes[i] = this.missingNotes[this.missingCount];
                    this.missingNotes[this.missingCount] = n3;
                    return;
                }
            }
        }

        boolean isFound(int n) {
            int n2 = n % 12;
            for (int i = this.missingCount; i < this.missingNotes.length; ++i) {
                if (this.missingNotes[i] != n2) continue;
                return true;
            }
            return false;
        }

        boolean isNeeded(int n) {
            int n2 = n % 12;
            if (this.missingCount != 0) {
                for (int i = 0; i < this.missingCount; ++i) {
                    if (this.missingNotes[i] != n2) continue;
                    return true;
                }
            }
            return false;
        }

        boolean isExisting(int n) {
            int n2 = n % 12;
            for (int i = 0; i < this.missingNotes.length; ++i) {
                if (this.missingNotes[i] != n2) continue;
                return true;
            }
            return false;
        }

        public Object clone() {
            int n;
            Proposal proposal = new Proposal();
            for (n = 0; n < 9; ++n) {
                proposal.params[n] = this.params[n];
            }
            proposal.unusualGrade = this.unusualGrade;
            proposal.dontHaveGrade = this.dontHaveGrade;
            proposal.missingCount = this.missingCount;
            proposal.missingNotes = new int[this.missingNotes.length];
            for (n = 0; n < proposal.missingNotes.length; ++n) {
                proposal.missingNotes[n] = this.missingNotes[n];
            }
            proposal.filled = new boolean[this.filled.length];
            for (n = 0; n < proposal.filled.length; ++n) {
                proposal.filled[n] = this.filled[n];
            }
            proposal.plusminusValue = new int[this.plusminusValue.length];
            for (n = 0; n < proposal.plusminusValue.length; ++n) {
                proposal.plusminusValue[n] = this.plusminusValue[n];
            }
            return proposal;
        }

        public boolean equals(Object object) {
            Proposal proposal = (Proposal)object;
            for (int i = 0; i < 9; ++i) {
                if (this.params[i] == proposal.params[i]) continue;
                return false;
            }
            return true;
        }
    }
}

