/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.chord;

import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.chord.ChordCustomList;
import org.herac.tuxguitar.gui.editors.chord.ChordEditor;
import org.herac.tuxguitar.gui.editors.chord.ChordList;
import org.herac.tuxguitar.gui.editors.chord.ChordRecognizer;
import org.herac.tuxguitar.gui.editors.chord.ChordSelector;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;

public class ChordDialog {
    public static final String NAME = "action.insert.chord";
    public static final int RESULT_SAVE = 1;
    public static final int RESULT_CLEAN = 2;
    public static final int RESULT_CANCEL = 3;
    private static final int DEFAULT_STYLE = 2048;
    private Shell dialog;
    private TGChord chord;
    private ChordEditor editor;
    private ChordSelector selector;
    private ChordList list;
    private ChordRecognizer recognizer;
    private int result;

    public int open(Shell shell, TGMeasureImpl tGMeasureImpl, TGBeat tGBeat, long l) {
        this.setResult(3);
        this.dialog = DialogUtils.newDialog(shell, 67680);
        this.dialog.setLayout((Layout)new GridLayout());
        this.dialog.setText(TuxGuitar.getProperty("chord.editor"));
        this.dialog.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                TuxGuitar.instance().getCustomChordManager().write();
            }
        });
        Composite composite = new Composite((Composite)this.dialog, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite2 = new Composite((Composite)this.dialog, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        int[] nArray = this.findCurrentTuning(tGMeasureImpl.getTrack());
        this.selector = new ChordSelector(this, composite, 2048, nArray);
        this.selector.pack();
        this.editor = new ChordEditor(this, composite, 2048, (short)nArray.length);
        this.editor.pack();
        this.editor.setCurrentTrack(tGMeasureImpl.getTrack());
        this.recognizer = new ChordRecognizer(this, composite, 2048);
        new ChordCustomList(this, composite, 2048, Math.max(this.selector.getBounds().height, this.editor.getBounds().height));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)this.gridLayout(1, false, 0, 0));
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        this.list = new ChordList(this, composite3, tGBeat);
        Composite composite4 = new Composite((Composite)this.dialog, 0);
        composite4.setLayout((Layout)this.gridLayout(3, false, 0, 0));
        composite4.setLayoutData((Object)new GridData(131072, 4, true, true));
        Button button = new Button(composite4, 8);
        button.setText(TuxGuitar.getProperty("ok"));
        button.setLayoutData((Object)this.getButtonData());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChordDialog.this.setChord(ChordDialog.this.getEditor().getChord());
                ChordDialog.this.setResult(1);
                ChordDialog.this.getDialog().dispose();
            }
        });
        Button button2 = new Button(composite4, 8);
        button2.setText(TuxGuitar.getProperty("clean"));
        button2.setLayoutData((Object)this.getButtonData());
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChordDialog.this.setResult(2);
                ChordDialog.this.getDialog().dispose();
            }
        });
        Button button3 = new Button(composite4, 8);
        button3.setText(TuxGuitar.getProperty("cancel"));
        button3.setLayoutData((Object)this.getButtonData());
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChordDialog.this.getDialog().dispose();
            }
        });
        this.editor.setChord(this.findCurrentChord(tGMeasureImpl, l));
        this.dialog.setDefaultButton(button);
        DialogUtils.openDialog(this.dialog, 11);
        return this.getResult();
    }

    public ChordEditor getEditor() {
        return this.editor;
    }

    public ChordSelector getSelector() {
        return this.selector;
    }

    public ChordList getList() {
        return this.list;
    }

    public ChordRecognizer getRecognizer() {
        return this.recognizer;
    }

    public TGChord getChord() {
        return this.chord;
    }

    public void setChord(TGChord tGChord) {
        this.chord = tGChord;
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int n) {
        this.result = n;
    }

    public boolean isDisposed() {
        return this.dialog.isDisposed();
    }

    public Shell getDialog() {
        return this.dialog;
    }

    public GridLayout gridLayout(int n, boolean bl, int n2, int n3) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        gridLayout.makeColumnsEqualWidth = bl;
        gridLayout.marginWidth = n2 >= 0 ? n2 : gridLayout.marginWidth;
        gridLayout.marginHeight = n3 >= 0 ? n3 : gridLayout.marginHeight;
        return gridLayout;
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    private int[] findCurrentTuning(TGTrack tGTrack) {
        int[] nArray = new int[tGTrack.stringCount()];
        Iterator iterator = tGTrack.getStrings().iterator();
        while (iterator.hasNext()) {
            TGString tGString = (TGString)iterator.next();
            nArray[nArray.length - tGString.getNumber()] = tGString.getValue();
        }
        return nArray;
    }

    protected TGChord findCurrentChord(TGMeasure tGMeasure, long l) {
        TGSongManager tGSongManager = TuxGuitar.instance().getSongManager();
        TGChord tGChord = tGSongManager.getMeasureManager().getChord(tGMeasure, l);
        if (tGChord == null) {
            tGChord = tGSongManager.getFactory().newChord(tGMeasure.getTrack().stringCount());
            tGChord.setFirstFret(1);
            List list = tGSongManager.getMeasureManager().getNotes(tGMeasure, l);
            if (!list.isEmpty()) {
                TGNote tGNote;
                int n = -1;
                int n2 = -1;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    tGNote = (TGNote)iterator.next();
                    if (n < 0 || n < tGNote.getValue()) {
                        n = tGNote.getValue();
                    }
                    if (tGNote.getValue() <= 0 || n2 >= 0 && n2 <= tGNote.getValue()) continue;
                    n2 = tGNote.getValue();
                }
                if (n > 6 && n2 > 0) {
                    tGChord.setFirstFret((short)n2);
                }
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    tGNote = (TGNote)iterator.next();
                    tGChord.addFretValue(tGNote.getString() - 1, tGNote.getValue());
                }
            }
        }
        return tGChord;
    }
}

