/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.measure;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.editors.tab.TGTrackImpl;
import org.herac.tuxguitar.gui.undo.undoables.UndoableJoined;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.song.models.TGMeasure;

public class CleanMeasureAction
extends Action {
    public static final String NAME = "action.measure.clean";

    public CleanMeasureAction() {
        super(NAME, 31);
    }

    protected int execute(TypedEvent typedEvent) {
        this.showDialog(TuxGuitar.instance().getShell());
        return 0;
    }

    public void showDialog(Shell shell) {
        TGTrackImpl tGTrackImpl = this.getEditor().getTablature().getCaret().getTrack();
        TGMeasureImpl tGMeasureImpl = this.getEditor().getTablature().getCaret().getMeasure();
        if (tGMeasureImpl != null) {
            final Shell shell2 = DialogUtils.newDialog(shell, 67680);
            shell2.setLayout((Layout)new GridLayout());
            shell2.setText(TuxGuitar.getProperty("measure.clean"));
            Group group = new Group((Composite)shell2, 16);
            group.setLayout((Layout)new GridLayout(2, false));
            group.setLayoutData((Object)new GridData(4, 4, true, true));
            group.setText(TuxGuitar.getProperty("measure.clean"));
            int n = this.getSongManager().getSong().countMeasureHeaders();
            Label label = new Label((Composite)group, 0);
            label.setText(TuxGuitar.getProperty("edit.from"));
            final Spinner spinner = new Spinner((Composite)group, 2048);
            spinner.setLayoutData((Object)this.getSpinnerData());
            spinner.setMinimum(1);
            spinner.setMaximum(n);
            spinner.setSelection(tGMeasureImpl.getNumber());
            Label label2 = new Label((Composite)group, 0);
            label2.setText(TuxGuitar.getProperty("edit.to"));
            final Spinner spinner2 = new Spinner((Composite)group, 2048);
            spinner2.setLayoutData((Object)this.getSpinnerData());
            spinner2.setMinimum(1);
            spinner2.setMaximum(n);
            spinner2.setSelection(tGMeasureImpl.getNumber());
            final int n2 = tGTrackImpl.countMeasures();
            spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    int n = spinner.getSelection();
                    int n2 = spinner2.getSelection();
                    if (n < 1) {
                        spinner.setSelection(1);
                    } else if (n > n2) {
                        spinner.setSelection(n2);
                    }
                }
            });
            spinner2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    int n;
                    int n22 = spinner2.getSelection();
                    if (n22 < (n = spinner.getSelection())) {
                        spinner2.setSelection(n);
                    } else if (n22 > n2) {
                        spinner2.setSelection(n2);
                    }
                }
            });
            Composite composite = new Composite((Composite)shell2, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
            Button button = new Button(composite, 8);
            button.setText(TuxGuitar.getProperty("ok"));
            button.setLayoutData((Object)this.getButtonData());
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    CleanMeasureAction.this.cleanMeasures(spinner.getSelection(), spinner2.getSelection());
                    shell2.dispose();
                }
            });
            Button button2 = new Button(composite, 8);
            button2.setText(TuxGuitar.getProperty("cancel"));
            button2.setLayoutData((Object)this.getButtonData());
            button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.dispose();
                }
            });
            shell2.setDefaultButton(button);
            DialogUtils.openDialog(shell2, 11);
        }
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    protected GridData getSpinnerData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 180;
        return gridData;
    }

    public void cleanMeasures(int n, int n2) {
        if (n > 0 && n <= n2) {
            UndoableJoined undoableJoined = new UndoableJoined();
            Caret caret = this.getEditor().getTablature().getCaret();
            for (int i = n; i <= n2; ++i) {
                TGMeasure tGMeasure = this.getSongManager().getTrackManager().getMeasure(caret.getTrack(), i);
                if (tGMeasure == null) continue;
                UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo(tGMeasure);
                this.getSongManager().getMeasureManager().cleanMeasure(tGMeasure);
                undoableJoined.addUndoableEdit(undoableMeasureGeneric.endUndo(tGMeasure));
            }
            if (!undoableJoined.isEmpty()) {
                this.addUndoableEdit(undoableJoined.endUndo());
            }
            TuxGuitar.instance().getFileHistory().setUnsavedFile();
            this.updateTablature();
        }
    }
}

