/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.tg.v08;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.base.TGInputStreamBase;
import org.herac.tuxguitar.io.tg.v08.TGStream;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGDivisionType;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMarker;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGNoteEffect;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;

public class TGInputStream
extends TGStream
implements TGInputStreamBase {
    private DataInputStream dataInputStream;
    private TGFactory factory;
    private String version;

    public void init(TGFactory tGFactory, InputStream inputStream) {
        this.factory = tGFactory;
        this.dataInputStream = new DataInputStream(inputStream);
        this.version = null;
    }

    public TGFileFormat getFileFormat() {
        return new TGFileFormat("TuxGuitar", "*.tg");
    }

    public boolean isSupportedVersion(String string) {
        return string.equals("TG_DEVEL-0.8");
    }

    public boolean isSupportedVersion() {
        try {
            this.readVersion();
            return this.isSupportedVersion(this.version);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private void readVersion() {
        if (this.version == null) {
            this.version = this.readString();
        }
    }

    public TGSong readSong() throws TGFileFormatException {
        try {
            if (this.isSupportedVersion()) {
                TGSong tGSong = this.read();
                this.dataInputStream.close();
                return tGSong;
            }
            throw new TGFileFormatException("Unsopported Version");
        }
        catch (Throwable throwable) {
            throw new TGFileFormatException(throwable);
        }
    }

    private TGSong read() {
        int n;
        TGSong tGSong = this.factory.newSong();
        tGSong.setName(this.readString());
        tGSong.setArtist(this.readString());
        tGSong.setAlbum(this.readString());
        tGSong.setAuthor(this.readString());
        int n2 = this.readShort();
        long l = 960L;
        TGMeasureHeader tGMeasureHeader = null;
        for (n = 0; n < n2; ++n) {
            TGMeasureHeader tGMeasureHeader2 = this.readMeasureHeader(n + 1, l, tGMeasureHeader);
            tGSong.addMeasureHeader(tGMeasureHeader2);
            l += tGMeasureHeader2.getLength();
            tGMeasureHeader = tGMeasureHeader2;
        }
        n = this.readByte();
        for (int i = 0; i < n; ++i) {
            tGSong.addTrack(this.readTrack(i + 1, tGSong));
        }
        return tGSong;
    }

    private TGTrack readTrack(int n, TGSong tGSong) {
        int n2;
        TGTrack tGTrack = this.factory.newTrack();
        tGTrack.setNumber(n);
        tGTrack.setName(this.readString());
        this.readChannel(tGTrack);
        int n3 = tGSong.countMeasureHeaders();
        TGMeasure tGMeasure = null;
        for (n2 = 0; n2 < n3; ++n2) {
            TGMeasure tGMeasure2 = this.readMeasure(tGSong.getMeasureHeader(n2), tGMeasure);
            tGTrack.addMeasure(tGMeasure2);
            tGMeasure = tGMeasure2;
        }
        n2 = this.readByte();
        for (int i = 0; i < n2; ++i) {
            tGTrack.getStrings().add(this.readInstrumentString(i + 1));
        }
        tGTrack.setOffset(-24 + this.readByte());
        this.readColor(tGTrack.getColor());
        return tGTrack;
    }

    private TGMeasureHeader readMeasureHeader(int n, long l, TGMeasureHeader tGMeasureHeader) {
        int n2 = this.readHeader();
        TGMeasureHeader tGMeasureHeader2 = this.factory.newHeader();
        tGMeasureHeader2.setNumber(n);
        tGMeasureHeader2.setStart(l);
        if ((n2 & 1) != 0) {
            this.readTimeSignature(tGMeasureHeader2.getTimeSignature());
        } else if (tGMeasureHeader != null) {
            tGMeasureHeader.getTimeSignature().copy(tGMeasureHeader2.getTimeSignature());
        }
        if ((n2 & 2) != 0) {
            this.readTempo(tGMeasureHeader2.getTempo());
        } else if (tGMeasureHeader != null) {
            tGMeasureHeader.getTempo().copy(tGMeasureHeader2.getTempo());
        }
        tGMeasureHeader2.setRepeatOpen((n2 & 4) != 0);
        if ((n2 & 8) != 0) {
            tGMeasureHeader2.setRepeatClose((int)this.readShort());
        }
        if ((n2 & 0x10) != 0) {
            tGMeasureHeader2.setMarker(this.readMarker(n));
        }
        tGMeasureHeader2.setTripletFeel(tGMeasureHeader != null ? tGMeasureHeader.getTripletFeel() : 1);
        if ((n2 & 0x20) != 0) {
            tGMeasureHeader2.setTripletFeel(this.readByte());
        }
        return tGMeasureHeader2;
    }

    private TGMeasure readMeasure(TGMeasureHeader tGMeasureHeader, TGMeasure tGMeasure) {
        int n = this.readHeader();
        TGMeasure tGMeasure2 = this.factory.newMeasure(tGMeasureHeader);
        TGBeat tGBeat = null;
        int n2 = this.readShort();
        for (int i = 0; i < n2; ++i) {
            tGBeat = this.readComponent(tGMeasure2, tGBeat);
        }
        tGMeasure2.setClef(tGMeasure == null ? 1 : tGMeasure.getClef());
        if ((n & 1) != 0) {
            tGMeasure2.setClef(this.readByte());
        }
        tGMeasure2.setKeySignature(tGMeasure == null ? 0 : tGMeasure.getKeySignature());
        if ((n & 2) != 0) {
            tGMeasure2.setKeySignature(this.readByte());
        }
        return tGMeasure2;
    }

    private void readChannel(TGTrack tGTrack) {
        int n = this.readHeader();
        tGTrack.getChannel().setChannel((short)this.readByte());
        tGTrack.getChannel().setEffectChannel((short)this.readByte());
        tGTrack.getChannel().setInstrument((short)this.readByte());
        tGTrack.getChannel().setVolume((short)this.readByte());
        tGTrack.getChannel().setBalance((short)this.readByte());
        tGTrack.getChannel().setChorus((short)this.readByte());
        tGTrack.getChannel().setReverb((short)this.readByte());
        tGTrack.getChannel().setPhaser((short)this.readByte());
        tGTrack.getChannel().setTremolo((short)this.readByte());
        tGTrack.setSolo((n & 1) != 0);
        tGTrack.setMute((n & 2) != 0);
    }

    private TGBeat readComponent(TGMeasure tGMeasure, TGBeat tGBeat) {
        TGBeat tGBeat2 = tGBeat;
        int n = this.readHeader();
        if (tGBeat2 == null) {
            tGBeat2 = this.factory.newBeat();
            tGBeat2.setStart(tGMeasure.getStart());
            tGMeasure.addBeat(tGBeat2);
        } else if ((n & 0x10) != 0) {
            tGBeat2 = this.factory.newBeat();
            tGBeat2.setStart(tGBeat.getStart() + tGBeat.getVoice(0).getDuration().getTime());
            tGMeasure.addBeat(tGBeat2);
        }
        TGVoice tGVoice = tGBeat2.getVoice(0);
        tGVoice.setEmpty(false);
        if ((n & 0x20) != 0) {
            this.readDuration(tGVoice.getDuration());
        } else if (tGBeat != null && !tGBeat.equals(tGBeat2)) {
            tGBeat.getVoice(0).getDuration().copy(tGVoice.getDuration());
        }
        if ((n & 1) != 0) {
            TGNote tGNote = this.factory.newNote();
            tGNote.setValue(this.readByte());
            tGNote.setVelocity(this.readByte());
            tGNote.setString(this.readByte());
            tGNote.setTiedNote((n & 4) != 0);
            if ((n & 8) != 0) {
                this.readNoteEffect(tGNote.getEffect());
            }
            tGVoice.addNote(tGNote);
        }
        return tGBeat2;
    }

    private TGString readInstrumentString(int n) {
        TGString tGString = this.factory.newString();
        tGString.setNumber(n);
        tGString.setValue(this.readByte());
        return tGString;
    }

    private void readTempo(TGTempo tGTempo) {
        tGTempo.setValue((int)this.readShort());
    }

    private void readTimeSignature(TGTimeSignature tGTimeSignature) {
        tGTimeSignature.setNumerator(this.readByte());
        this.readDuration(tGTimeSignature.getDenominator());
    }

    private void readDuration(TGDuration tGDuration) {
        int n = this.readHeader();
        tGDuration.setDotted((n & 1) != 0);
        tGDuration.setDoubleDotted((n & 2) != 0);
        tGDuration.setValue(this.readByte());
        if ((n & 4) != 0) {
            this.readDivisionType(tGDuration.getDivision());
        }
    }

    private void readDivisionType(TGDivisionType tGDivisionType) {
        tGDivisionType.setEnters(this.readByte());
        tGDivisionType.setTimes(this.readByte());
    }

    private void readNoteEffect(TGNoteEffect tGNoteEffect) {
        int n = this.readHeader();
        tGNoteEffect.setVibrato((n & 1) != 0);
        tGNoteEffect.setDeadNote((n & 4) != 0);
        tGNoteEffect.setSlide((n & 8) != 0);
        tGNoteEffect.setHammer((n & 0x10) != 0);
        if ((n & 2) != 0) {
            tGNoteEffect.setBend(this.readBendEffect());
        }
    }

    private TGEffectBend readBendEffect() {
        TGEffectBend tGEffectBend = this.factory.newEffectBend();
        int n = this.readByte();
        for (int i = 0; i < n; ++i) {
            int n2 = this.readByte();
            int n3 = this.readByte();
            tGEffectBend.addPoint(n2, n3 > 0 ? n3 / 2 : n3);
        }
        return tGEffectBend;
    }

    private TGMarker readMarker(int n) {
        TGMarker tGMarker = this.factory.newMarker();
        tGMarker.setMeasure(n);
        tGMarker.setTitle(this.readString());
        this.readColor(tGMarker.getColor());
        return tGMarker;
    }

    private void readColor(TGColor tGColor) {
        tGColor.setR((int)this.readShort());
        tGColor.setG((int)this.readShort());
        tGColor.setB((int)this.readShort());
    }

    private int readByte() {
        try {
            return this.dataInputStream.read();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    private int readHeader() {
        try {
            return this.dataInputStream.read();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    private short readShort() {
        try {
            return this.dataInputStream.readShort();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    private String readString() {
        try {
            int n = this.dataInputStream.read();
            char[] cArray = new char[n];
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = this.dataInputStream.readChar();
            }
            return String.copyValueOf(cArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }
}

