/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.midi;

import java.io.OutputStream;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGLocalFileExporter;
import org.herac.tuxguitar.io.midi.MidiSequenceHandlerImpl;
import org.herac.tuxguitar.io.midi.MidiSettings;
import org.herac.tuxguitar.io.midi.MidiSettingsDialog;
import org.herac.tuxguitar.player.base.MidiSequenceHandler;
import org.herac.tuxguitar.player.base.MidiSequenceParser;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGSong;

public class MidiSongExporter
implements TGLocalFileExporter {
    private OutputStream stream;
    private MidiSettings settings;

    public String getExportName() {
        return "Midi";
    }

    public TGFileFormat getFileFormat() {
        return new TGFileFormat("Midi", "*.mid;*.midi");
    }

    public boolean configure(boolean bl) {
        this.settings = bl ? MidiSettings.getDefaults() : new MidiSettingsDialog().open();
        return this.settings != null;
    }

    public void init(TGFactory tGFactory, OutputStream outputStream) {
        this.stream = outputStream;
    }

    public void exportSong(TGSong tGSong) {
        if (this.stream != null && this.settings != null) {
            TGSongManager tGSongManager = new TGSongManager();
            tGSongManager.setSong(tGSong);
            MidiSequenceParser midiSequenceParser = new MidiSequenceParser(tGSongManager, 11, 100, this.settings.getTranspose());
            MidiSequenceHandlerImpl midiSequenceHandlerImpl = new MidiSequenceHandlerImpl(tGSong.countTracks() + 1, this.stream);
            midiSequenceParser.parse((MidiSequenceHandler)midiSequenceHandlerImpl);
        }
    }
}

