/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gervill;

import org.herac.tuxguitar.gui.system.plugins.TGPluginException;
import org.herac.tuxguitar.gui.system.plugins.base.TGExporterPlugin;
import org.herac.tuxguitar.io.base.TGRawExporter;
import org.herac.tuxguitar.io.gervill.MidiToAudioExporter;
import org.herac.tuxguitar.io.gervill.MidiToAudioSynth;

public class MidiToAudioPlugin
extends TGExporterPlugin {
    private boolean available = MidiToAudioSynth.instance().isAvailable();

    public void init() throws TGPluginException {
        if (this.available) {
            super.init();
        }
    }

    public void close() throws TGPluginException {
        if (this.available) {
            super.close();
        }
    }

    public void setEnabled(boolean bl) throws TGPluginException {
        if (this.available) {
            super.setEnabled(bl);
        }
    }

    protected TGRawExporter getExporter() throws TGPluginException {
        if (this.available) {
            return new MidiToAudioExporter();
        }
        return null;
    }

    public String getVersion() {
        return "1.1";
    }

    public String getAuthor() {
        return "Julian Casadesus <julian@casadesus.com.ar>";
    }

    public String getName() {
        return "Gervill Plugin";
    }

    public String getDescription() {
        String string = new String();
        string = string + "The purpose of this plugin is to add gervill support to tuxguitar.\n";
        string = string + "The current version of this plugin includes \"Export to Audio\" feature.\n";
        string = string + "See more about Gervill: https://gervill.dev.java.net/\n\n";
        string = string + "This plugin will only work if gervill synthesizer is installed in your JVM";
        return string;
    }
}

