/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tools.browser.ftp;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.herac.tuxguitar.gui.tools.browser.TGBrowserException;
import org.herac.tuxguitar.gui.tools.browser.base.TGBrowser;
import org.herac.tuxguitar.gui.tools.browser.base.TGBrowserElement;
import org.herac.tuxguitar.gui.tools.browser.ftp.TGBrowserDataImpl;
import org.herac.tuxguitar.gui.tools.browser.ftp.TGBrowserElementComparator;
import org.herac.tuxguitar.gui.tools.browser.ftp.TGBrowserElementImpl;
import org.herac.tuxguitar.gui.tools.browser.ftp.TGBrowserFTPClient;

public class TGBrowserImpl
extends TGBrowser {
    private TGBrowserDataImpl data;
    private String root;
    private String path;
    private TGBrowserFTPClient client;

    public TGBrowserImpl(TGBrowserDataImpl tGBrowserDataImpl) {
        this.data = tGBrowserDataImpl;
    }

    private String getRoot() {
        if (this.root == null) {
            this.root = "/";
            if (this.data.getPath() != null && this.data.getPath().length() > 0) {
                this.root = this.data.getPath();
                if (this.root.indexOf("/") != 0) {
                    this.root = "/" + this.root;
                }
            }
        }
        return this.root;
    }

    public void open() throws TGBrowserException {
        try {
            this.checkForProxy();
            this.client = new TGBrowserFTPClient();
            this.client.open(this.data.getHost(), 21);
            this.client.login(this.data.getUsername(), this.data.getPassword());
            this.cdRoot();
        }
        catch (Throwable throwable) {
            throw new TGBrowserException(throwable);
        }
    }

    public void close() throws TGBrowserException {
        try {
            this.closeProxy();
            this.client.close();
        }
        catch (Throwable throwable) {
            throw new TGBrowserException(throwable);
        }
    }

    public void cdElement(TGBrowserElement tGBrowserElement) throws TGBrowserException {
        try {
            boolean bl = this.client.cd(tGBrowserElement.getName());
            if (!bl) {
                throw new TGBrowserException("could not cd to " + tGBrowserElement.getName());
            }
            this.path = this.client.pwd();
        }
        catch (Throwable throwable) {
            throw new TGBrowserException(throwable);
        }
    }

    public void cdRoot() throws TGBrowserException {
        try {
            this.client.cd(this.getRoot());
            this.path = this.client.pwd();
        }
        catch (Throwable throwable) {
            throw new TGBrowserException(throwable);
        }
    }

    public void cdUp() throws TGBrowserException {
        try {
            this.client.cdUp();
            this.path = this.client.pwd();
        }
        catch (Throwable throwable) {
            throw new TGBrowserException(throwable);
        }
    }

    public List listElements() throws TGBrowserException {
        ArrayList<TGBrowserElementImpl> arrayList = new ArrayList<TGBrowserElementImpl>();
        try {
            this.client.binary();
            String[] stringArray = this.client.listNames();
            String[] stringArray2 = this.client.listDetails();
            if (stringArray.length > 0 && stringArray2.length > 0) {
                block2: for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i].trim();
                    if (string.indexOf(this.path) == 0 && string.length() > this.path.length()) {
                        string = string.substring(this.path.length());
                    }
                    while (string.indexOf("/") == 0) {
                        string = string.substring(1);
                    }
                    if (string.length() <= 0) continue;
                    for (int j = 0; j < stringArray2.length; ++j) {
                        String string2 = stringArray2[j].trim();
                        if (string2.indexOf(string) <= 0) continue;
                        arrayList.add(new TGBrowserElementImpl(this, string, string2, this.path));
                        continue block2;
                    }
                }
            }
            if (!arrayList.isEmpty()) {
                Collections.sort(arrayList, new TGBrowserElementComparator());
            }
        }
        catch (Throwable throwable) {
            throw new TGBrowserException(throwable);
        }
        return arrayList;
    }

    public InputStream getInputStream(String string, TGBrowserElement tGBrowserElement) throws TGBrowserException {
        try {
            this.client.cd(string);
            this.client.binary();
            byte[] byArray = this.client.get(tGBrowserElement.getName());
            return new ByteArrayInputStream(byArray);
        }
        catch (Throwable throwable) {
            throw new TGBrowserException(throwable);
        }
    }

    private void checkForProxy() {
        if (this.data.getProxyHost() != null && this.data.getProxyPort() > 0) {
            System.setProperty("socksProxyHost", this.data.getProxyHost());
            System.setProperty("socksProxyPort", String.valueOf(this.data.getProxyPort()));
            if (this.data.getProxyUser() != null && this.data.getProxyUser().trim().length() > 0) {
                System.setProperty("java.net.socks.username", this.data.getProxyUser());
                System.setProperty("java.net.socks.password", this.data.getProxyPwd());
                Authenticator.setDefault(new ProxyAuthenticator(this.data.getProxyUser(), this.data.getProxyPwd()));
            }
        } else {
            this.closeProxy();
        }
    }

    private void closeProxy() {
        Properties properties = System.getProperties();
        properties.remove("socksProxyHost");
        properties.remove("socksProxyPort");
        properties.remove("java.net.socks.username");
        properties.remove("java.net.socks.password");
    }

    private final class ProxyAuthenticator
    extends Authenticator {
        private PasswordAuthentication auth;

        protected ProxyAuthenticator(String string, String string2) {
            this.auth = new PasswordAuthentication(string, string2.toCharArray());
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return this.auth;
        }
    }
}

