/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.jack.synthesizer;

import org.herac.tuxguitar.gui.system.config.TGConfigManager;

public class JackOutputPortRouter {
    public static final int CREATE_UNIQUE_PORT = 0;
    public static final int CREATE_MULTIPLE_PORTS_BY_CHANNEL = 1;
    public static final int CREATE_MULTIPLE_PORTS_BY_PROGRAM = 2;
    private static final int PORT_INDEX = 0;
    private static final int CHANNEL_INDEX = 1;
    private static final int PROGRAM_INDEX = 2;
    private int ports = 1;
    private int[][] channels = new int[16][3];
    private int[][] programs = new int[128][3];

    public int getPortCount() {
        return this.ports;
    }

    public int getPortRoute(int n) {
        if (n >= 0 && n < this.channels.length) {
            int n2 = this.channels[n][0];
            return n2 >= 0 ? n2 : 0;
        }
        return 0;
    }

    public int getChannelRoute(int n) {
        if (n >= 0 && n < this.channels.length) {
            int n2 = this.channels[n][1];
            return n2 >= 0 ? n2 : n;
        }
        return 0;
    }

    public int getProgramRoute(int n, int n2) {
        if (n >= 0 && n < this.channels.length) {
            int n3 = this.channels[n][2];
            return n3 >= 0 ? n3 : n2;
        }
        return 0;
    }

    public void setProgram(int n, int n2) {
        if (n >= 0 && n < this.channels.length && n2 >= 0 && n2 < this.programs.length && this.channels[n][2] >= 0 && n != 9) {
            int n3 = this.programs[n2][0];
            int n4 = this.programs[n2][1];
            int n5 = this.programs[n2][2];
            if (n3 >= 0) {
                this.channels[n][0] = n3;
            }
            if (n4 >= 0) {
                this.channels[n][1] = n4;
            }
            if (n5 >= 0) {
                this.channels[n][2] = n5;
            }
        }
    }

    protected void createUniquePort() {
        int n;
        this.ports = 1;
        for (n = 0; n < this.channels.length; ++n) {
            this.channels[n][0] = 0;
            this.channels[n][1] = n;
            this.channels[n][2] = -1;
        }
        for (n = 0; n < this.programs.length; ++n) {
            this.programs[n][0] = -1;
            this.programs[n][2] = -1;
            this.programs[n][1] = -1;
        }
    }

    protected void createMultiplePortsByChannel(int[][] nArray) {
        int n;
        this.ports = this.channels.length;
        for (n = 0; n < this.channels.length; ++n) {
            this.channels[n][0] = n;
            this.channels[n][1] = n;
            this.channels[n][2] = -1;
        }
        for (n = 0; n < this.programs.length; ++n) {
            this.programs[n][0] = -1;
            this.programs[n][2] = -1;
            this.programs[n][1] = -1;
        }
        for (n = 0; n < nArray.length; ++n) {
            int n2;
            if (nArray[n].length != 3 || (n2 = nArray[n][0]) < 0 || n2 >= this.channels.length) continue;
            this.channels[n2][1] = nArray[n][1];
            this.channels[n2][2] = nArray[n][2];
        }
    }

    protected void createMultiplePortsByProgram(int[][] nArray) {
        int n;
        this.ports = 1;
        for (n = 0; n < this.channels.length; ++n) {
            this.channels[n][0] = -1;
            this.channels[n][1] = -1;
            this.channels[n][2] = 0;
        }
        for (n = 0; n < this.programs.length; ++n) {
            this.programs[n][0] = 0;
            this.programs[n][2] = n;
            this.programs[n][1] = -1;
        }
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n].length != 4) continue;
            int n2 = nArray[n][0];
            if (n2 >= 0 && n2 < this.programs.length) {
                if (nArray[n][1] > 0) {
                    this.programs[n2][0] = this.ports++;
                }
                this.programs[n2][1] = nArray[n][2];
                this.programs[n2][2] = nArray[n][3] >= 0 ? nArray[n][3] : n2;
                continue;
            }
            if (n2 != 128) continue;
            if (nArray[n][1] > 0) {
                this.channels[9][0] = this.ports++;
            }
            this.channels[9][1] = nArray[n][2];
            this.channels[9][2] = nArray[n][3];
        }
    }

    public void loadSettings(TGConfigManager tGConfigManager) {
        int n = tGConfigManager.getIntConfigValue("jack.midi.ports.type", 0);
        if (n == 2) {
            int[][] nArrayArray = new int[129][];
            for (int i = 0; i < nArrayArray.length; ++i) {
                nArrayArray[i] = new int[4];
                nArrayArray[i][0] = i;
                nArrayArray[i][1] = tGConfigManager.getIntConfigValue("jack.midi.port.program-routing.port-" + i, 0);
                nArrayArray[i][2] = tGConfigManager.getIntConfigValue("jack.midi.port.program-routing.to-channel-" + i, -1);
                nArrayArray[i][3] = tGConfigManager.getIntConfigValue("jack.midi.port.program-routing.to-program-" + i, -1);
            }
            this.createMultiplePortsByProgram(nArrayArray);
        } else if (n == 1) {
            int[][] nArrayArray = new int[16][];
            for (int i = 0; i < nArrayArray.length; ++i) {
                nArrayArray[i] = new int[3];
                nArrayArray[i][0] = i;
                nArrayArray[i][1] = tGConfigManager.getIntConfigValue("jack.midi.port.channel-routing.to-channel-" + i, -1);
                nArrayArray[i][2] = tGConfigManager.getIntConfigValue("jack.midi.port.channel-routing.to-program-" + i, -1);
            }
            this.createMultiplePortsByChannel(nArrayArray);
        } else {
            this.createUniquePort();
        }
    }
}

