/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.jack.settings;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.jack.settings.JackSettings;

public class JackSettingsDialog {
    private static final int TAB_WIDTH = 550;
    private static final int TAB_HEIGHT = 350;
    private JackSettings settings;

    public JackSettingsDialog(JackSettings jackSettings) {
        this.settings = jackSettings;
    }

    public void open(Shell shell) {
        final int[][] nArray = this.getChannelRoutingSettings();
        final int[][] nArray2 = this.getProgramRoutingSettings();
        final Shell shell2 = DialogUtils.newDialog((Shell)shell, (int)67680);
        shell2.setText(TuxGuitar.getProperty((String)"jack.settings.dialog"));
        shell2.setLayout((Layout)new GridLayout());
        shell2.setLayoutData((Object)new GridData(4, 4, true, true));
        final TabFolder tabFolder = new TabFolder((Composite)shell2, 128);
        tabFolder.setLayout((Layout)new FormLayout());
        final TabItem[] tabItemArray = new TabItem[2];
        int n = this.settings.getConfig().getIntConfigValue("jack.midi.ports.type", 0);
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new FormData(550, 350));
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(TuxGuitar.getProperty((String)"jack.settings.dialog.options"));
        tabItem.setControl((Control)composite);
        Group group = new Group(composite, 16);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port"));
        Button button = new Button((Composite)group, 16);
        final Button button2 = new Button((Composite)group, 16);
        final Button button3 = new Button((Composite)group, 16);
        button.setText(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.type.single"));
        button2.setText(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.type.multiple-by-channel"));
        button3.setText(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.type.multiple-by-program"));
        if (n == 1) {
            button2.setSelection(true);
            tabItemArray[0] = this.openChannelRoutingTab(tabFolder, nArray);
        } else if (n == 2) {
            button3.setSelection(true);
            tabItemArray[1] = this.openProgramRoutingTab(tabFolder, nArray2);
        } else {
            button.setSelection(true);
        }
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = button2.getSelection();
                boolean bl2 = button3.getSelection();
                if (bl && tabItemArray[0] == null) {
                    tabItemArray[0] = JackSettingsDialog.this.openChannelRoutingTab(tabFolder, nArray);
                } else if (!bl && tabItemArray[0] != null) {
                    tabItemArray[0].dispose();
                    tabItemArray[0] = null;
                }
                if (bl2 && tabItemArray[1] == null) {
                    tabItemArray[1] = JackSettingsDialog.this.openProgramRoutingTab(tabFolder, nArray2);
                } else if (!bl2 && tabItemArray[1] != null) {
                    tabItemArray[1].dispose();
                    tabItemArray[1] = null;
                }
            }
        };
        button.addSelectionListener((SelectionListener)selectionAdapter);
        button2.addSelectionListener((SelectionListener)selectionAdapter);
        button3.addSelectionListener((SelectionListener)selectionAdapter);
        Composite composite2 = new Composite((Composite)shell2, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(131072, 4, true, true));
        Button button4 = new Button(composite2, 8);
        button4.setText(TuxGuitar.getProperty((String)"ok"));
        button4.setLayoutData((Object)this.getButtonData());
        button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = 0;
                if (button2.getSelection()) {
                    n = 1;
                } else if (button3.getSelection()) {
                    n = 2;
                }
                JackSettingsDialog.this.saveChanges(n, nArray, nArray2);
                shell2.dispose();
            }
        });
        Button button5 = new Button(composite2, 8);
        button5.setText(TuxGuitar.getProperty((String)"cancel"));
        button5.setLayoutData((Object)this.getButtonData());
        button5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        shell2.setDefaultButton(button4);
        DialogUtils.openDialog((Shell)shell2, (int)11);
    }

    protected GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    protected void saveChanges(int n, int[][] nArray, int[][] nArray2) {
        if (n == 1) {
            this.setChannelRoutingSettings(nArray);
        } else if (n == 2) {
            this.setProgramRoutingSettings(nArray2);
        }
        this.settings.getConfig().setProperty("jack.midi.ports.type", n);
        this.settings.notifyChanges();
    }

    protected int[][] getChannelRoutingSettings() {
        int[][] nArrayArray = new int[16][];
        for (int i = 0; i < nArrayArray.length; ++i) {
            nArrayArray[i] = new int[3];
            nArrayArray[i][0] = i;
            nArrayArray[i][1] = this.settings.getConfig().getIntConfigValue("jack.midi.port.channel-routing.to-channel-" + i, -1);
            nArrayArray[i][2] = this.settings.getConfig().getIntConfigValue("jack.midi.port.channel-routing.to-program-" + i, -1);
        }
        return nArrayArray;
    }

    protected void setChannelRoutingSettings(int[][] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i].length != 3) continue;
            this.settings.getConfig().setProperty("jack.midi.port.channel-routing.to-channel-" + nArray[i][0], nArray[i][1]);
            this.settings.getConfig().setProperty("jack.midi.port.channel-routing.to-program-" + nArray[i][0], nArray[i][2]);
        }
    }

    protected int[][] getProgramRoutingSettings() {
        int[][] nArrayArray = new int[129][];
        for (int i = 0; i < nArrayArray.length; ++i) {
            nArrayArray[i] = new int[4];
            nArrayArray[i][0] = i;
            nArrayArray[i][1] = this.settings.getConfig().getIntConfigValue("jack.midi.port.program-routing.port-" + i, 0);
            nArrayArray[i][2] = this.settings.getConfig().getIntConfigValue("jack.midi.port.program-routing.to-channel-" + i, -1);
            nArrayArray[i][3] = this.settings.getConfig().getIntConfigValue("jack.midi.port.program-routing.to-program-" + i, -1);
        }
        return nArrayArray;
    }

    protected void setProgramRoutingSettings(int[][] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i].length != 4) continue;
            this.settings.getConfig().setProperty("jack.midi.port.program-routing.port-" + nArray[i][0], nArray[i][1]);
            this.settings.getConfig().setProperty("jack.midi.port.program-routing.to-channel-" + nArray[i][0], nArray[i][2]);
            this.settings.getConfig().setProperty("jack.midi.port.program-routing.to-program-" + nArray[i][0], nArray[i][3]);
        }
    }

    public TabItem openProgramRoutingTab(TabFolder tabFolder, int[][] nArray) {
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new FormData(550, 350));
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.program-router.options"));
        tabItem.setControl((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        final Table table = new Table(composite2, 67584);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(table, 16384);
        TableColumn tableColumn2 = new TableColumn(table, 16384);
        TableColumn tableColumn3 = new TableColumn(table, 16384);
        TableColumn tableColumn4 = new TableColumn(table, 16384);
        tableColumn.setText(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.program-router.src-program"));
        tableColumn2.setText(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.program-router.dst-port"));
        tableColumn3.setText(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.program-router.dst-channel"));
        tableColumn4.setText(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.program-router.dst-program"));
        tableColumn.setWidth(125);
        tableColumn2.setWidth(125);
        tableColumn3.setWidth(125);
        tableColumn4.setWidth(125);
        this.loadProgramRoutingItems(table, nArray);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(1, false));
        composite3.setLayoutData((Object)new GridData(131072, 1024, true, false));
        Button button = new Button(composite3, 8);
        button.setText(TuxGuitar.getProperty((String)"edit"));
        button.setLayoutData((Object)this.getButtonData());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = table.getSelectionIndex();
                if (n >= 0 && n < table.getItemCount()) {
                    JackSettingsDialog.this.editProgramRoutingItem(table.getShell(), table.getItem(n));
                }
            }
        });
        return tabItem;
    }

    protected void loadProgramRoutingItems(Table table, int[][] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.addProgramRoutingItem(table, nArray[i]);
        }
    }

    protected void addProgramRoutingItem(Table table, int[] nArray) {
        TableItem tableItem = new TableItem(table, 0);
        this.addProgramRoutingItem(tableItem, nArray);
    }

    protected void addProgramRoutingItem(TableItem tableItem, int[] nArray) {
        if (nArray.length == 4) {
            String[] stringArray = new String[]{nArray[0] < 128 ? TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.program-router.src-program.item", (String[])new String[]{Integer.toString(nArray[0])}) : TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.program-router.src-program.percussion"), nArray[1] > 0 ? TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.program-router.dst-port.dedicated") : TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.program-router.dst-port.default"), nArray[2] >= 0 ? TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.program-router.dst-channel.item", (String[])new String[]{Integer.toString(nArray[2])}) : TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.program-router.dst-channel.default"), nArray[3] >= 0 ? TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.program-router.dst-program.item", (String[])new String[]{Integer.toString(nArray[3])}) : TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.program-router.dst-program.default")};
            tableItem.setText(stringArray);
            tableItem.setData((Object)nArray);
        }
    }

    public void editProgramRoutingItem(Shell shell, final TableItem tableItem) {
        final int[] nArray = (int[])tableItem.getData();
        final Shell shell2 = DialogUtils.newDialog((Shell)shell, (int)2144);
        shell2.setLayout((Layout)new GridLayout(1, false));
        shell2.setLayoutData((Object)new GridData(4, 4, true, true));
        shell2.setText(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.program-router.options"));
        Group group = new Group((Composite)shell2, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.program-router.options"));
        Label label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, true));
        label.setText(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.program-router.src-program") + ":");
        Label label2 = new Label((Composite)group, 0);
        label2.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        if (nArray[0] < 128) {
            label2.setText(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.program-router.src-program.item", (String[])new String[]{Integer.toString(nArray[0])}));
        } else {
            label2.setText(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.program-router.src-program.percussion"));
        }
        Label label3 = new Label((Composite)group, 0);
        label3.setLayoutData((Object)new GridData(131072, 0x1000000, false, true));
        label3.setText(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.program-router.dst-port") + ":");
        final Combo combo = new Combo((Composite)group, 12);
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        combo.add(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.program-router.dst-port.default"));
        combo.add(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.program-router.dst-port.dedicated"));
        combo.select(nArray[1]);
        Label label4 = new Label((Composite)group, 0);
        label4.setLayoutData((Object)new GridData(131072, 0x1000000, false, true));
        label4.setText(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.program-router.dst-channel") + ":");
        final Combo combo2 = new Combo((Composite)group, 12);
        combo2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        combo2.add(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.program-router.dst-channel.default"));
        for (int i = 0; i < 16; ++i) {
            combo2.add(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.program-router.dst-channel.item", (String[])new String[]{Integer.toString(i)}));
        }
        combo2.select(nArray[2] + 1);
        Label label5 = new Label((Composite)group, 0);
        label5.setLayoutData((Object)new GridData(131072, 0x1000000, false, true));
        label5.setText(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.program-router.dst-program") + ":");
        final Combo combo3 = new Combo((Composite)group, 12);
        combo3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        combo3.add(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.program-router.dst-program.default"));
        for (int i = 0; i < 128; ++i) {
            combo3.add(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.program-router.dst-program.item", (String[])new String[]{Integer.toString(i)}));
        }
        combo3.select(nArray[3] + 1);
        Composite composite = new Composite((Composite)shell2, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(131072, 4, true, true));
        Button button = new Button(composite, 8);
        button.setText(TuxGuitar.getProperty((String)"ok"));
        button.setLayoutData((Object)this.getButtonData());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                nArray[1] = combo.getSelectionIndex();
                nArray[2] = combo2.getSelectionIndex() - 1;
                nArray[3] = combo3.getSelectionIndex() - 1;
                JackSettingsDialog.this.addProgramRoutingItem(tableItem, nArray);
                shell2.dispose();
            }
        });
        Button button2 = new Button(composite, 8);
        button2.setText(TuxGuitar.getProperty((String)"cancel"));
        button2.setLayoutData((Object)this.getButtonData());
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        shell2.setDefaultButton(button2);
        DialogUtils.openDialog((Shell)shell2, (int)10);
    }

    public TabItem openChannelRoutingTab(TabFolder tabFolder, int[][] nArray) {
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new FormData(550, 350));
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.channel-router.options"));
        tabItem.setControl((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        final Table table = new Table(composite2, 67584);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(table, 16384);
        TableColumn tableColumn2 = new TableColumn(table, 16384);
        TableColumn tableColumn3 = new TableColumn(table, 16384);
        tableColumn.setText(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.channel-router.src-channel"));
        tableColumn2.setText(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.channel-router.dst-channel"));
        tableColumn3.setText(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.channel-router.dst-program"));
        tableColumn.setWidth(166);
        tableColumn2.setWidth(166);
        tableColumn3.setWidth(166);
        this.loadChannelRoutingItems(table, nArray);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(1, false));
        composite3.setLayoutData((Object)new GridData(131072, 1024, true, false));
        Button button = new Button(composite3, 8);
        button.setText(TuxGuitar.getProperty((String)"edit"));
        button.setLayoutData((Object)this.getButtonData());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = table.getSelectionIndex();
                if (n >= 0 && n < table.getItemCount()) {
                    JackSettingsDialog.this.editChannelRoutingItem(table.getShell(), table.getItem(n));
                }
            }
        });
        return tabItem;
    }

    protected void loadChannelRoutingItems(Table table, int[][] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.addChannelRoutingItem(table, nArray[i]);
        }
    }

    protected void addChannelRoutingItem(Table table, int[] nArray) {
        TableItem tableItem = new TableItem(table, 0);
        this.addChannelRoutingItem(tableItem, nArray);
    }

    protected void addChannelRoutingItem(TableItem tableItem, int[] nArray) {
        if (nArray.length == 3) {
            String[] stringArray = new String[]{TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.channel-router.src-channel.item", (String[])new String[]{Integer.toString(nArray[0])}), nArray[1] >= 0 ? TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.channel-router.dst-channel.item", (String[])new String[]{Integer.toString(nArray[1])}) : TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.channel-router.dst-channel.default"), nArray[2] >= 0 ? TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.channel-router.dst-program.item", (String[])new String[]{Integer.toString(nArray[2])}) : TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.channel-router.dst-program.default")};
            tableItem.setText(stringArray);
            tableItem.setData((Object)nArray);
        }
    }

    public void editChannelRoutingItem(Shell shell, final TableItem tableItem) {
        final int[] nArray = (int[])tableItem.getData();
        final Shell shell2 = DialogUtils.newDialog((Shell)shell, (int)2144);
        shell2.setLayout((Layout)new GridLayout(1, false));
        shell2.setLayoutData((Object)new GridData(4, 4, true, true));
        shell2.setText(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.channel-router.options"));
        Group group = new Group((Composite)shell2, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.channel-router.options"));
        Label label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, true));
        label.setText(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.channel-router.src-channel") + ":");
        Label label2 = new Label((Composite)group, 0);
        label2.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        label2.setText(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.channel-router.src-channel.item", (String[])new String[]{Integer.toString(nArray[0])}));
        Label label3 = new Label((Composite)group, 0);
        label3.setLayoutData((Object)new GridData(131072, 0x1000000, false, true));
        label3.setText(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.channel-router.dst-channel") + ":");
        final Combo combo = new Combo((Composite)group, 12);
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        combo.add(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.channel-router.dst-channel.default"));
        for (int i = 0; i < 16; ++i) {
            combo.add(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.channel-router.dst-channel.item", (String[])new String[]{Integer.toString(i)}));
        }
        combo.select(nArray[1] + 1);
        Label label4 = new Label((Composite)group, 0);
        label4.setLayoutData((Object)new GridData(131072, 0x1000000, false, true));
        label4.setText(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.channel-router.dst-program") + ":");
        final Combo combo2 = new Combo((Composite)group, 12);
        combo2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        combo2.add(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.channel-router.dst-program.default"));
        for (int i = 0; i < 127; ++i) {
            combo2.add(TuxGuitar.getProperty((String)"jack.settings.dialog.options.midi-port.channel-router.dst-program.item", (String[])new String[]{Integer.toString(i)}));
        }
        combo2.select(nArray[2] + 1);
        Composite composite = new Composite((Composite)shell2, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(131072, 4, true, true));
        Button button = new Button(composite, 8);
        button.setText(TuxGuitar.getProperty((String)"ok"));
        button.setLayoutData((Object)this.getButtonData());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                nArray[1] = combo.getSelectionIndex() - 1;
                nArray[2] = combo2.getSelectionIndex() - 1;
                JackSettingsDialog.this.addChannelRoutingItem(tableItem, nArray);
                shell2.dispose();
            }
        });
        Button button2 = new Button(composite, 8);
        button2.setText(TuxGuitar.getProperty((String)"cancel"));
        button2.setLayoutData((Object)this.getButtonData());
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        shell2.setDefaultButton(button2);
        DialogUtils.openDialog((Shell)shell2, (int)10);
    }
}

