/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.community.io;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.herac.tuxguitar.community.auth.TGCommunityAuthDialog;
import org.herac.tuxguitar.community.io.TGShareFile;
import org.herac.tuxguitar.community.io.TGShareFileDialog;
import org.herac.tuxguitar.community.io.TGShareSongConnection;
import org.herac.tuxguitar.community.io.TGShareSongResponse;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.ActionLock;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.io.tg.TGOutputStream;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.util.TGSynchronizer;

public class TGShareSong {
    public void process(TGSong tGSong) {
        try {
            TGShareFile tGShareFile = new TGShareFile();
            tGShareFile.setFile(this.getSongBytes(tGSong));
            this.processDialog(tGShareFile, null);
        }
        catch (Throwable throwable) {
            MessageDialog.errorMessage((Throwable)throwable);
        }
    }

    public void processDialog(final TGShareFile tGShareFile, final String string) {
        try {
            TGSynchronizer.instance().runLater(new TGSynchronizer.TGRunnable(){

                public void run() throws Throwable {
                    TGShareFileDialog tGShareFileDialog = new TGShareFileDialog(tGShareFile, string);
                    tGShareFileDialog.open();
                    if (tGShareFileDialog.isAccepted()) {
                        TGShareSong.this.processUpload(tGShareFile);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            MessageDialog.errorMessage((Throwable)throwable);
        }
    }

    public void processAuthDialog(final TGShareFile tGShareFile) {
        try {
            TGSynchronizer.instance().runLater(new TGSynchronizer.TGRunnable(){

                public void run() throws Throwable {
                    TGCommunityAuthDialog tGCommunityAuthDialog = new TGCommunityAuthDialog();
                    tGCommunityAuthDialog.open();
                    if (tGCommunityAuthDialog.isAccepted()) {
                        TGShareSong.this.processUpload(tGShareFile);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            MessageDialog.errorMessage((Throwable)throwable);
        }
    }

    public void processUpload(final TGShareFile tGShareFile) {
        this.setActiveMode();
        new Thread(new Runnable(){

            public void run() {
                try {
                    TGShareSongConnection tGShareSongConnection = new TGShareSongConnection();
                    tGShareSongConnection.uploadFile(tGShareFile, TGShareSong.this);
                }
                catch (Throwable throwable) {
                    MessageDialog.errorMessage((Throwable)throwable);
                }
            }
        }).start();
    }

    public void processResult(TGShareSongResponse tGShareSongResponse, TGShareFile tGShareFile) {
        this.setPasiveMode();
        try {
            String string = tGShareSongResponse.getStatus();
            if (string != null && string.equals("200")) {
                MessageDialog.infoMessage((String)"File Uploaded", (String)"File upload completed!!");
            } else if (string != null && string.equals("401")) {
                this.processAuthDialog(tGShareFile);
            } else if (string != null && string.equals("400")) {
                String string2 = new String();
                ArrayList arrayList = new ArrayList();
                tGShareSongResponse.loadMessages(arrayList);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    string2 = string2 + (String)iterator.next() + "\r\n";
                }
                this.processDialog(tGShareFile, string2);
            } else {
                this.processDialog(tGShareFile, "Error: " + string);
            }
        }
        catch (Throwable throwable) {
            MessageDialog.errorMessage((Throwable)throwable);
        }
    }

    private byte[] getSongBytes(TGSong tGSong) throws Throwable {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TGOutputStream tGOutputStream = new TGOutputStream();
        tGOutputStream.init(new TGFactory(), (OutputStream)byteArrayOutputStream);
        tGOutputStream.writeSong(tGSong);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public void setActiveMode() {
        TuxGuitar.instance().lock();
        TuxGuitar.instance().loadCursor(1);
        ActionLock.lock();
    }

    public void setPasiveMode() {
        ActionLock.unlock();
        TuxGuitar.instance().loadCursor(0);
        TuxGuitar.instance().unlock();
    }
}

