/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.community.auth;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.community.TGCommunitySingleton;
import org.herac.tuxguitar.community.auth.TGCommunityAuth;
import org.herac.tuxguitar.community.utils.TGCommunityWeb;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.util.TGSynchronizer;

public class TGCommunityAuthDialog {
    private boolean accepted = false;
    private TGCommunityAuth auth = TGCommunitySingleton.getInstance().getAuth();

    public void open() {
        this.open(TuxGuitar.instance().getShell());
    }

    public void open(final Shell shell) {
        try {
            if (shell != null && !shell.isDisposed()) {
                TGSynchronizer.instance().addRunnable(new TGSynchronizer.TGRunnable(){

                    public void run() throws Throwable {
                        if (!shell.isDisposed()) {
                            TGCommunityAuthDialog.this.doOpen(shell);
                        }
                    }
                });
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void doOpen(Shell shell) {
        this.accepted = false;
        final Shell shell2 = DialogUtils.newDialog((Shell)shell, (int)67680);
        shell2.setLayout((Layout)new GridLayout());
        shell2.setLayoutData((Object)new GridData(4, 4, true, true));
        shell2.setImage(TuxGuitar.instance().getIconManager().getAppIcon());
        shell2.setText(TuxGuitar.getProperty((String)"tuxguitar-community.auth-dialog.title"));
        Group group = new Group((Composite)shell2, 16);
        group.setLayout((Layout)this.makeGroupLayout(2, 5));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty((String)"tuxguitar-community.auth-dialog.signin"));
        Label label = new Label((Composite)group, 0);
        label.setLayoutData((Object)this.makeLabelData());
        label.setText(TuxGuitar.getProperty((String)"tuxguitar-community.auth-dialog.signin.username") + ":");
        final Text text = new Text((Composite)group, 2048);
        text.setLayoutData((Object)this.makeTextData());
        text.setText(this.auth.getUsername());
        Label label2 = new Label((Composite)group, 0);
        label2.setLayoutData((Object)this.makeLabelData());
        label2.setText(TuxGuitar.getProperty((String)"tuxguitar-community.auth-dialog.signin.password") + ":");
        final Text text2 = new Text((Composite)group, 0x400800);
        text2.setLayoutData((Object)this.makeTextData());
        text2.setText(this.auth.getPassword());
        Group group2 = new Group((Composite)shell2, 16);
        group2.setLayout((Layout)this.makeGroupLayout(1, 5));
        group2.setLayoutData((Object)new GridData(group.computeSize((int)-1, (int)-1).x, -1));
        group2.setText(TuxGuitar.getProperty((String)"tuxguitar-community.auth-dialog.signup"));
        Link link = new Link((Composite)group2, 16384);
        link.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        link.setText(TuxGuitar.getProperty((String)"tuxguitar-community.auth-dialog.signup.tip"));
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                final String string = event.text;
                if (string != null) {
                    new Thread(new Runnable(){

                        public void run() {
                            TGCommunityWeb.open(string);
                        }
                    }).start();
                }
            }
        });
        Composite composite = new Composite((Composite)shell2, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(131072, 4, true, true));
        Button button = new Button(composite, 8);
        button.setText(TuxGuitar.getProperty((String)"ok"));
        button.setLayoutData((Object)this.getButtonData());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGCommunityAuthDialog.this.update(text.getText(), text2.getText());
                shell2.dispose();
            }
        });
        Button button2 = new Button(composite, 8);
        button2.setText(TuxGuitar.getProperty((String)"cancel"));
        button2.setLayoutData((Object)this.getButtonData());
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        shell2.setDefaultButton(button);
        DialogUtils.openDialog((Shell)shell2, (int)11);
    }

    private GridLayout makeGroupLayout(int n, int n2) {
        GridLayout gridLayout = new GridLayout(n, false);
        gridLayout.marginTop = n2;
        gridLayout.marginBottom = n2;
        gridLayout.marginLeft = n2;
        gridLayout.marginRight = n2;
        gridLayout.verticalSpacing = n2;
        gridLayout.horizontalSpacing = n2;
        return gridLayout;
    }

    private GridData makeLabelData() {
        return new GridData(131072, 0x1000000, false, true);
    }

    private GridData makeTextData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 250;
        return gridData;
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    protected void update(String string, String string2) {
        this.auth.setUsername(string);
        this.auth.setPassword(string2);
        this.accepted = true;
    }

    public boolean isAccepted() {
        return this.accepted;
    }
}

