/*  BMP - Cross-platform multimedia player
 *  Copyright (C) 2003-2004  BMP development team.
 *
 *  Based on XMMS:
 *  Copyright (C) 1998-2003  XMMS development team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef LYRICWIN_H
#define LYRICWIN_H

#include <glib.h>
#include <gtk/gtk.h>

#include "pbutton.h"


#define LYRICWIN_FRAME_TOP_HEIGHT    20
#define LYRICWIN_FRAME_BOTTOM_HEIGHT 6
#define LYRICWIN_FRAME_LEFT_WIDTH    12
#define LYRICWIN_FRAME_RIGHT_WIDTH   19

#define LYRICWIN_MIN_WIDTH           MAINWIN_WIDTH
#define LYRICWIN_MIN_HEIGHT          MAINWIN_HEIGHT
#define LYRICWIN_WIDTH_SNAP          25
#define LYRICWIN_HEIGHT_SNAP         29
#define LYRICWIN_SHADED_HEIGHT       MAINWIN_SHADED_HEIGHT
#define LYRICWIN_WIDTH               cfg.lyric_width
#define LYRICWIN_HEIGHT (cfg.lyric_shaded ? LYRICWIN_SHADED_HEIGHT : cfg.lyric_height)

#define LYRICWIN_DEFAULT_WIDTH       275
#define LYRICWIN_DEFAULT_HEIGHT      232
#define LYRICWIN_DEFAULT_POS_X       295
#define LYRICWIN_DEFAULT_POS_Y       20

#define LYRICWIN_DEFAULT_FONT        "Sans Bold 10"



#define LYRICWIN_DEFAULT_DIR_PRESET "dir_default.preset"
#define LYRICWIN_DEFAULT_PRESET_EXT "preset"


void lyricwin_set_shade_menu_cb(gboolean shaded);
void draw_lyricwin_window(gboolean force);
void lyricwin_create(void);
void lyricwin_show(void);
void lyricwin_hide(void);
gboolean lyricwin_has_focus(void);
void lyric_list_free();
void lyric_move_dir(const char *filename);
void lyricwin_update_lyric(void);
void lyricwin_box_draw(Widget * w);
void lyricwin_draw_curr_lyric(gint time);


extern GtkWidget *lyricwin;
extern PButton *lyricwin_close;
extern gboolean lyricwin_focus;

#endif
