#ifndef __KONFORKA_BASIC_WRAPPER_H
#define __KONFORKA_BASIC_WRAPPER_H

/**
 * @file
 * @brief The konforka::basic_wrapper class declaration.
 */

#include <konforka/exception.h>

namespace konforka {

    /**
     * @brief The basic wrapper class.
     *
     */
    template<typename T>
	class basic_wrapper {
	    public:
		/**
		 * The type of wrapped content.
		 */
		typedef T content_type;

		/**
		 * The content wrapped into the instance.
		 */
		content_type opkele;
		/**
		 * This boolean indicates whether the object has a content
		 * attached to it.
		 */
		bool bopkele;

		/**
		 * Default constructors creates the object with no content
		 * associated with it.
		 */
		basic_wrapper()
		    : bopkele(false) { }
		/**
		 * The constructor associates the content give with the object.
		 * @param o the content being attached to the object.
		 */
		basic_wrapper(content_type o)
		    : opkele(o), bopkele(true) { }
		/**
		 * Virtual destructor doing nothing in this class.
		 */
		virtual ~basic_wrapper() { }

		/**
		 * Attaches the given content to the object.
		 * @param o the content being attached to the object.
		 */
		void attach(content_type o) {
		    opkele = o;
		    bopkele = true;
		}

		/**
		 * Test whether the object has content attached.
		 * @return naturally, returns true if yes.
		 */
		bool is() const {
		    return bopkele;
		}

		/**
		 * Throws an exception in case the object lacks content
		 * attached.
		 */
		void ensure() const {
		    if(!is())
			throw konforka::exception(CODEPOINT,"no content attached");
		}

		/**
		 * Get the content attached to the object. It would throw an
		 * exception if there is no content attached.
		 * @return reference to the content.
		 */
		virtual content_type& get_content() {
		    ensure();
		    return opkele;
		}
		/**
		 * Get the content attached to the object. It would throw an
		 * exception if there is no content attached.
		 * @return const reference to the content.
		 */
		virtual const content_type& get_content() const {
		    ensure();
		    return opkele;
		}

		/**
		 * Casts the object to the reference to the content type,
		 * throwing an exception if there's no content associated with
		 * an object.
		 * @return reference to the content attached.
		 * @see get_content()
		 */
		operator const content_type&(void) const { return get_content(); }
		/**
		 * Casts the object to the const reference to the content type,
		 * throwing an exception if there's no content associated with
		 * an object.
		 * @return reference to the content attached.
		 * @see get_content()
		 */
		operator content_type&(void) { return get_content(); }
	};

}

#endif /* __KONFORKA_BASIC_WRAPPER_H */
/* vim:set ft=cpp: */
