.TH ID3 1 "id3 mass tagger"
.SH NAME
id3 \- a command line mass tagger
.SH SYNOPSIS
.HP 2
.B id3
.RB [ \-v ]
.RB [ \-m ]
.RB [ \-123 ]
.RB [ \-d ]
.RB [ \-t
.IR title ]
.RB [ \-a
.IR artist ]
.RB [ \-l
.IR album ]
.br
.RB [ \-n
.IR tracknr ]
.RB [ \-y
.IR year ]
.RB [ \-g
.IR genre ]
.RB [ \-c
.IR comment ]
.br
.RB [ \-f
.IR template ]
.RB [ \-q
.IR format ]
.RB [ \-D
.IR file ]
.RB [ \-R ]
.RB [ \-M ]
.br
.RB [ \-E ]
.RB [ \-s
.IR size ]
.RB [ \-u ]
.RB [ \-r\fIFRAME ]
.RB [ \-w\fIFRAME
.IR data ]
.IR \*(lqfilespec\*(rq
.SH DESCRIPTION
.I id3
mass tagger is a tool for listing and manipulating ID3 and Lyrics3
tags in multiple
files. It can generate tag fields from the filename and other variables,
and/or rename files, using an intuitive syntax.

.I id3
currently supports the old-style ID3 format with track-number extension
(ID3 v1.1), as well as the more complicated ID3v2 (ID3 v2.2.0, v2.3.0) format.
This also means use is pretty much limited to audio files which use these
formats, e.g, MPEG-1 Layer III.
.SH OPTIONS
Order of the options is only important where specified.
.TP
.B filespec ...
specifies the file(s) to be affected by the command.

If you use wildcards, it is necessary to enclose the specification
in double quotes ("") for pattern matching to work.
.TP
.B \-h
show command line help
.TP
.B \-V
display version number and copyright
.TP
.B \-v
be verbose
.TP
.B \-1
process/add ID3v1 tags.
.TP
.B \-2
process/add ID3v2 tags.
.TP
.B \-3
process/add Lyrics3 tags.

If more than one tag type is specified, they are all written, but only the
left-most tag is read from. If no tag type is specified, 
.I id3 
will by default
attempt to read ID3v2, Lyrics3 and ID3v1 tags in that order, only modify existing ID3v2 and Lyrics3 tags, and modify/add ID3v1 tags.
.TP
.BI \-R
searches recursively; Normally, path separators in \fIfilespec\fR do not get
matched by `?' or `*' wildcards. With this switch, they are treated as an
ordinary character.
.TP
.B \-M
preserve last modification time of files operated on
.TP
.B \--
force the following argument to be interpreted as a filename. Use this for
files that start with a `-' (dash).
.P
.SS Modifying operations
The default operation of 
.I id3
is to list the tags found. By using any of the following options, this behaviour is inhibited.
.TP
.B \-d
do not re-use existing tag data. If no new tag information is specified in
conjunction with this option, all selected tags will be removed.
.PP
.BI \-t " title
.br
.BI \-a " artist
.br
.BI \-l " album
.br
.BI \-n " tracknr
.br
.BI \-y " year
.br
.BI \-g " genre
.br
.BI \-c " comment
.IP
add/replace the specified fields in all selected tags with the values
given. Field values are scanned for substitution variables, see
.B SUBSTITUTION
below. If a field value is a single variable, and its substitution fails, no
operation is performed.

Genres can be specified either directly or with their assigned number,
regardless of tag format.
.TP
.BI \-f " filename-template
rename files encountered according to \fIfilename-template\fR.
The argument is scanned for substitution variables. An empty variable will by
default get replaced with \*(lqUnknown\*(rq.
Trying to rename to an already existing file will cause an error.
.TP
.BI \-q " format
for each file encountered, \fIformat\fR will get scanned for substitution
variables, and written to standard output. Using this option will block any
attempt to modify files.
.TP
.B \-m
match mode; interpret any variables found in a \fIfilespec\fR as a wildcard,
and set the tag field corresponding to the matched wildcard.
Thus, `-m\ "%a\ -\ %t.mp3"' is equivalent for `-a\ %1\ -t\ %2\ "*\ -\ *.mp3"'.
This option is merely a shorthand and does not add any intelligence;
in particular, any variable interpreted still counts as a wildcard, see
.B SUBSTITUTION
below.
.TP
.BI \-D " filename
duplicate and copy the tags of the specified format as found in \fIfilename\fR
to the target files. The tag in each file is replaced after any variables have
been read, but before any fields are updated.

Any original tag values not explicitly copied to the new tag (for example, by
using -u) are lost. If \fIfilename\fR does not have any tags, this option is
identical to the -d option.
.B SUBSTITUTION
below.
.PP
The following options only apply on the tag most recently selected before
them, and only have meaning where relevant.
.TP
.BI \-E
only write a tag of the most recently selected type if a file already contains it; do not add new ones.
.TP
.BI \-u
update all standard tag fields by copying them from the source tag. This is
similar to writing `-talnygc %t %a %l %n %y %g %c', but only operates on the
most recent tag. It is possible for the source and destination tag to be the
same.
.TP
.BI \-s " size
try to write a new tag using exactly \fIsize\fR bytes, adding / removing
padding as necessary. The resulting tag will have no padding if \fIsize\fR
is smaller than the actual size necessary.
.TP
.B \-r\fIFRAME
remove all occurrences of frames named \fIFRAME\fR from the tag. Consult the
format documentation for valid \fIFRAME\fR names.
.TP
.BI \-w\fIFRAME " data
add / update a frame named \fIFRAME\fR with \fIdata\fR in the  tag.
\fIdata\fR is scanned for substitution variables. Again, consult the format
documentation. See \fICOMPATIBILITY\fR for more information.
.PP
Individual options can be stacked in a single argument for more convenience.
For example, running

   id3 -2d -alt "Artist" "Album" "Title" *.mp3

is equivalent to:

   id3 -2 -d -a "Artist" -l "Album" -t "Title" *.mp3

.SH SUBSTITUTION
.I id3 
can perform \*(lqprintf-like\*(rq substitution on the values prior to
writing them to a tag. Note that if you want to use pattern matching, you
HAVE TO enclose the wildcard specification on the command line in double quotes
to prevent your shell from expanding any wildcards.
.TP
.BI \(rs c
escape sequence. \(rsn, \(rsr, \(rst, \(rsv, \(rsf, \(rsb, \(rsa, get replaced as in C, any
other character will be stripped of any special meaning. E.g., \(rsn becomes the
newline character, \(rs\(rs a single backslash.
.TP
.BI % <modifiers>N
.SM where \fIN\fR <- [0..9]
replaced with the portion of the file path matching the \fIn\fRth `*'
(asterisk) wildcard in the file specification. 0 is taken to mean 10.
.TP
.BI % <modifiers>c
.SM where \fIc\fR <- [a..z]
.RS
replaced by values according to the following table:
.PP
.BR %t " title
.br
.BR %a " artist
.br
.BR %l " album\ title
.br
.BR %n " track\ number
.br
.BR %y " year
.br
.BR %g " genre
.br
.BR %c " comment\ field
.br
.BR %f " file\ name\ (without\ path)
.br
.BR %p " path\ to\ filename
.br
.BR %x " auto-increasing\ counter
.br
.BR %X " file counter
.PP
Values get read (where applicable) from the source tag, which is the left-most
tag selected on the command line, and reflect the state of the file before any
modifications were made. If the source value is not available, the variable
fails.
\fI%p%f\fR combines to the full path and file name. The \fI%x\fR value
gets increased every time it has been substituted inside the same directory,
and is intended for auto-numbering. \fI%X\fR increases for every file
processed.
.RE
.TP
.B %%
replaced with a single \*(lq%\*(rq, equivalent to \fB\(rs%\fR
.TP
.BI %| text || alt\ text || ... |?
substituted by the first \fItext\fR that was completely successful, or fails
as empty, see \fBfall-backs\fR below. This can be used as an all-or-nothing
substitution. A lone \*(lq%?\*(rq always fails.
.SS Available \fI<modifiers>\fR (optional):
.TP
.BR + " (plus\ sign)
Capitalize the substituted value
.TP
.BR - " (minus\ sign)
Convert all characters to lowercase
.TP
.BR _ " (underscore)
Use the raw value of the variable. Normally, substitution replaces any
underscores with spaces, and condenses empty whitespace.
.TP
.BR * " (asterisk)
Split the variable into separate words by looking at the capitalization.
.TP
.BR # " (hash\ or\ pound\ sign)
Attempt to fit numeric values in the substituted string to a desired width, 
by removing or adding leading zeros.
Multiple hash signs can be stacked to indicate the desired width. If there are
no numeric values, this modifier has no effect.
.TP
.BI | fall-back |
If substitution for a variable fails, attempt \fIfall-back\fR instead.
\fIfall-back\fR itself may be empty or contain other variables (including other
fall-backs). If \fIfall-back\fR contains variables that fail, the \fIfall-back\fR
fails and will not be used. If more than one fall-back is provided, successive
fall-backs are tried until one succeeds.
.RE
.SH EXAMPLES
Here are some examples of using 
.I id3
:
.TP
\fBid3 -a "Stallman" -t "Free Software Song" fs_song.mp3"
Add a simple tag to a file.
.TP
\fBid3 muzak.mp3
List tag information in a file.
.TP
\fBid3 -d *.mp3
Removes all ID3v1 tags from all mp3's.
.TP
\fBid3 -2 -1u fs_song.mp3
Copy ID3v2 tag to ID3v1 tag in selected file.
.TP
\fBid3 -D source.mp3 -1 -2 dest.mp3
Duplicate ID3v1 and ID3v2 tags of source.mp3
.TP
\fBid3 -a "TAFKAT" -n "%1" -t "%+2" "*. *.mp3"
Update tag fields similar to this;
.nf
  -a "TAFKAT" -n "01" -t "My Song"  "01. my_song.mp3"
  -a "TAFKAT" -n "02" -t "Untitled" "02. untitled.mp3"
.TP
\fBid3 -2 -f "%a - %t.mp3" blaet.mp3
Rename file to a standard format, using ID3v2 values.
.TP
\fBid3 -a %t -t %a "*.mp3"
Swap artist and title fields in all mp3's.
.TP
\fBid3 -2 -rAPIC -s 0 *.mp3
Removes embedded images and padding from all mp3's.
.TP
\fBid3 -2d -u *.mp3
Rewrite ID3v2 tag while keeping only the basic fields.
.TP
\fBid3 -2 -wUSLT "foo, bar\nlalala!\n" blaet.mp3
Adds an ID3v2 lyric frame to blaet.mp3.
.TP
\fBid3 -v -g alt-rock -alnt "The Author" %1 %2 %3 "Author - */(*) *.mp3"
Process multiple directories at once.
.TP
\fBid3 -v -g alt-rock -a "The Author" -m "Author - %l/(%n) %t.mp3"
Shorthand for the previous example.
.TP
\fBid3 -2 -c "Was: %_f" -f "%|Nobody|a - %|Untitled (%x)|t.mp3" "*.mp3"
Advanced rename. Saves previous filename in the comment field.
.TP
\fBid3 -2 -q "%| %a - %|Untitled|t || %t || %1 |?" "*.mp3"
Generate a playlist.
.SH NOTES
The internal pattern matching emulates the normal pattern matching of
\*(lqsh\*(rq. It supports ?, * and [].

A shell pattern will never match a forward slash (\*(lq/\*(rq) or a dot
(\*(lq.\*(rq) beginning a filename. Wildcards can be used for directories as
well (to arbitrary depths), in which case a search will be performed.

In an ambiguous situation, the pattern matcher will always resolve a
\*(lq*\*(rq wildcard to the shortest possible sequence of tokens. This differs
from the behavior of regular expressions, however it tends to make sense in
the context of filenames.

Do NOT add ID3 tags to files for which it does not make sense, i.e, add them
only to MP3 files. In particular, do not add ID3v2 tags to Ogg files, since
ID3v2 tags start at the beginning of the file.
.SH COMPATIBILITY
id3 has a built-in genre list of 148 genres. If you pass the -g parameter a
string instead of a number when using ID3v1, id3 tries to find the specified
genre in this list, and selects the closest possible match (if any). For the
genre numbers and exact spelling, see \fIid3v1.c\fR in the source
distribution. An empty or invalid genre is assigned the number 0.

id3 automatically writes Unicode tags where necessary. Depending on your
system, you may only be able to fully work with all characters if you are
using an UTF-8 locale.

id3 will write the ID3v2 tag version that was encountered and does not convert
from one version to another. If no existing tag is found, ID3 v2.3 will be
written (this may change in a future version).

The -w\fIFRAME\fR parameter only knows the following ID3v2.2 (3
letter)/ID3v2.3 (4 letter) frames:
T??/T??? (text),
W??/W??? (links),
COM/COMM (comment),
IPL/IPLS (involved  people),
ULT/USLT (lyrics),
CNT/PCNT (numeric play counter) and
USER (tos, v2.3 only).
Frames that do not match the tag type encountered are ignored and not
converted. It is a no-op for ID3v1.

id3 does not (currently) support ID3v2 v4.0 tags. It also does not support
ID3v2 features as compression, encryption, ...
.SH AUTHOR
Written by Marc R. Schoolderman <squell@alumina.nl>.
.SH COPYRIGHT
This is free software; see the source for copying conditions. There is NO
warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
.SH SEE ALSO
Program homepage: https://squell.github.io/id3

