/* 
 * This file is part of dcaenc.
 *
 * Copyright (c) 2008-2012 Alexander E. Patrakov <patrakov@gmail.com>
 *
 * dcaenc is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * dcaenc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with dcaenc; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef INT_DATA_H
#define INT_DATA_H

#include "softfloat.h"


/*
 *  Official tables taken from:
 *  ETSI TS 102 114 V1.2.1
 *
 *  Copyright (C)  European Telecommunications Standards Institute 2002.
 *  Copyright (C) European Broadcasting Union 2002.
 *  All rights reserved.
 */

/* 5.4.1 Bit Stream Header,
 * Table 5.7: RATE parameter vs. targeted bit-rate
 * with "open" replaced by 6144000
 * and "variable" and "lossless" by 16144000 (i.e. invalid value)
 */
static const int target_bitrate_table[32] = {
	32000, 56000, 64000, 96000, 112000, 128000, 192000, 224000,
	256000, 320000, 384000, 448000, 512000, 576000, 640000, 768000,
	960000, 1024000, 1152000, 1280000, 1344000, 1408000, 1411200, 1472000,
	1536000, 1920000, 2048000, 3072000, 3840000, 6144000, 16144000, 16144000,
};

/* 5.4.1 Bit Stream Header,
 * Table 5.4: Audio channel arrangement
 * FIXME: more than 5 channels are not supported
 */
static const int channels_table[16] = {
	1, 2, 2, 2, 2, 3, 3, 4, 4, 5, 6, 6, 6, 7, 8, 8,
};

/* 5.4.1 Bit Stream Header,
 * Table 5.5: Core audio sampling frequencies
 */
static const int sample_rates[9] = {
	8000, 16000, 32000, 11025, 22050, 44100, 12000, 24000, 48000,
};

static const int bitstream_sfreq[9] = {
	1, 2, 3, 6, 7, 8, 11, 12, 13,
};

/* manually derived from
 * Table B.5: Selection of quantization levels and codebooks
 * Fixme: will become invalid when Huffman codes are introduced.
 */
static const int bit_consumption[27] = {
	-8, 28, 40, 48, 52, 60, 68, 76, 80, 96,
	112, 128, 144, 160, 176, 192, 208, 224, 240, 256,
	272, 288, 304, 320, 336, 352, 368,
};

/* Table B.5: Selection of quantization levels and codebooks */
static const int quant_levels[27] = {
	1, 3, 5, 7, 9, 13, 17, 25, 32, 64,
	128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536,
	131072, 262144, 524288, 1048576, 2097152, 4194304, 8388608,
};

/* D.2.1 Lossy Quantization */
static const int32_t stepsize[27] = {
	0, 6710886, 4194304, 3355443, 2474639, 2097152, 1761608, 1426063, 796918, 461373,
	251658, 146801, 79692, 46137, 27263, 16777, 10486, 5872, 3355, 1887,
	1258, 713, 336, 168, 84, 42, 21,
};

/* Generated table, FIXME: move to math_tables.c */
/* a / stepsize[i] == mul32(a, stepsize_inv[i].m) >> stepsize_inv[i].e */
static const softfloat stepsize_inv[27] = {
	{0, 0}, {1342177360, 21}, {2147483647, 21}, {1342177360, 20},
	{1819901661, 20}, {2147483647, 20}, {1278263843, 19}, {1579032492, 19},
	{1412817763, 18}, {1220162327, 17}, {1118482133, 16}, {1917391412, 16},
	{1766017772, 15}, {1525212826, 14}, {1290553940, 13}, {2097179000, 13},
	{1677683200, 12}, {1497972244, 11}, {1310893147, 10}, {1165354136, 9},
	{1748031204, 9}, {1542092044, 8}, {1636178017, 7}, {1636178017, 6},
	{1636178017, 5}, {1636178017, 4}, {1636178017, 3},
};

/* D.1.2 7-bit Quantization (Nominal 1.1 dB Step) */
static const int32_t scalefactor[128] = {
	1, 1, 2, 2, 2, 2, 3, 3,
	3, 4, 4, 5, 6, 7, 7, 8,
	10, 11, 12, 14, 16, 18, 20, 23,
	26, 30, 34, 38, 44, 50, 56, 64,
	72, 82, 93, 106, 120, 136, 155, 176,
	200, 226, 257, 292, 331, 376, 427, 484,
	550, 624, 708, 804, 912, 1035, 1175, 1334,
	1514, 1718, 1950, 2213, 2512, 2851, 3236, 3673,
	4169, 4732, 5370, 6095, 6918, 7852, 8913, 10116,
	11482, 13032, 14791, 16788, 19055, 21627, 24547, 27861,
	31623, 35892, 40738, 46238, 52481, 59566, 67608, 76736,
	87096, 98855, 112202, 127350, 144544, 164059, 186209, 211349,
	239883, 272270, 309030, 350752, 398107, 451856, 512861, 582103,
	660693, 749894, 851138, 966051, 1096478, 1244515, 1412538, 1603245,
	1819701, 2065380, 2344229, 2660725, 3019952, 3427678, 3890451, 4415704,
	5011872, 5688529, 6456542, 7328245, 8317638, 8317638, 8317638, 8317638,
};

/* Generated table */
/* sqrt(2) * a / scalefactor[i] == 4 * mul32(a, scalefactor_inv[i].m) >> scalefactor_inv[i].e */
static const softfloat scalefactor_inv[128] = {
	{2147483647, 1}, {2147483647, 1}, {2147483647, 2}, {2147483647, 2},
	{2147483647, 2}, {2147483647, 2}, {1431655765, 2}, {1431655765, 2},
	{1431655765, 2}, {2147483647, 3}, {2147483647, 3}, {1717986918, 3},
	{1431655765, 3}, {1227133513, 3}, {1227133513, 3}, {2147483647, 4},
	{1717986918, 4}, {1561806289, 4}, {1431655765, 4}, {1227133513, 4},
	{2147483647, 5}, {1908874353, 5}, {1717986918, 5}, {1493901668, 5},
	{1321528398, 5}, {1145324612, 5}, {2021161080, 6}, {1808407282, 6},
	{1561806289, 6}, {1374389534, 6}, {1227133513, 6}, {2147483647, 7},
	{1908874353, 7}, {1676084798, 7}, {1477838209, 7}, {1296593900, 7},
	{1145324612, 7}, {2021161080, 8}, {1773405851, 8}, {1561806289, 8},
	{1374389534, 8}, {1216273924, 8}, {2139127680, 9}, {1882725390, 9},
	{1660893697, 9}, {1462116526, 9}, {1287484341, 9}, {1135859119, 9},
	{1999112050, 10}, {1762037865, 10}, {1552982525, 10}, {1367551775, 10},
	{1205604855, 10}, {2124660150, 11}, {1871509153, 11}, {1648443220, 11},
	{1452459217, 11}, {1279990253, 11}, {1127704233, 11}, {1987368509, 12},
	{1750814693, 12}, {1542632939, 12}, {1359099663, 12}, {1197398995, 12},
	{2109880792, 13}, {1858853132, 13}, {1638006149, 13}, {1443165385, 13},
	{1271479187, 13}, {1120235993, 13}, {1973767086, 14}, {1739045674, 14},
	{1532153461, 14}, {1349922194, 14}, {1189384493, 14}, {2095804865, 15},
	{1846464029, 15}, {1626872524, 15}, {1433347133, 15}, {1262853884, 15},
	{1112619678, 15}, {1960569045, 16}, {1727349015, 16}, {1521881227, 16},
	{1340842289, 16}, {1181357555, 16}, {2081669156, 17}, {1834047752, 17},
	{1615889229, 17}, {1423675973, 17}, {1254322457, 17}, {1105123583, 17},
	{1947330755, 18}, {1715693602, 18}, {1511607799, 18}, {1331801790, 18},
	{1173384427, 18}, {2067616532, 19}, {1821667648, 19}, {1604980024, 19},
	{1414066955, 19}, {1245861410, 19}, {1097665748, 19}, {1934193616, 20},
	{1704119624, 20}, {1501412075, 20}, {1322817107, 20}, {1165466323, 20},
	{2053666205, 21}, {1809379407, 21}, {1594151671, 21}, {1404526328, 21},
	{1237455941, 21}, {1090259329, 21}, {1921143210, 22}, {1692621231, 22},
	{1491281857, 22}, {1313892269, 22}, {1157603482, 22}, {2039810470, 23},
	{1797172644, 23}, {1583396912, 23}, {1395050052, 23}, {1229107276, 23},
	{1082903494, 23}, {1082903494, 23}, {1082903494, 23}, {1082903494, 23},
};
#endif
