/*****************************************************************************
 *
 *   drawbar.h
 *
 *   Simulation of an electronic organ like Vox Continental
 *   with JACK MIDI input and JACK audio output
 *
 *   Copyright (C) 2009,2010 Martin Homuth-Rosemann
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; version 2 of the License
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 ******************************************************************************/

#ifndef DRAWBAR_H
#define DRAWBAR_H

#include <QGroupBox>

QT_BEGIN_NAMESPACE
class QLabel;
class QSlider;
QT_END_NAMESPACE

class Drawbar : public QGroupBox
{
    Q_OBJECT

public:
    Drawbar(int *value, const QString &title, QWidget *parent = 0);
    void addMix( int *value1=0, int *value2=0, int *value3=0, int *value4=0 );

signals:
    void valueChanged(int value);

public slots:
    void setValue(int value);
    void update();

private:
    int *extValue;
    int *mix1;
    int *mix2;
    int *mix3;
    int *mix4;
    QLabel *label;
    QSlider *slider;
    QTimer *timer;

private slots:
    void exportValue( int value );
};

#endif
