/*****************************************************************************
 *
 *   connie.h
 *
 *   Simulation of an electronic organ like Vox Continental
 *   with JACK MIDI input and JACK audio output
 *
 *   Copyright (C) 2009,2010 Martin Homuth-Rosemann
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; version 2 of the License
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 *****************************************************************************/
#ifndef CONNIE_H
#define CONNIE_H

typedef enum {CONNIE, HAMMOND} model_t;
typedef enum keybd_enum { QWERTY=0, QWERTZ, AZERTY } keybd_t;

extern const char * connie_version;
//extern const char * connie_name;

extern const char *jack_name;
extern float concert_pitch;
extern int intonation;
extern const char *inton_name;
extern int transpose;
extern int tg_midi_channel;
extern char *uuid;
extern char *connie_conf;

// tone generation

// stops
extern int tg_stops[9];

// voices
extern int tg_voices[3];
//extern float tg_vol_fl;
//extern float tg_vol_rd;
//extern float tg_vol_sh;

// master volume
extern float tg_master_vol;


// extern int tg_fx[3];

// vibrato frequency
extern int tg_vibrato;

// percussion intensity
extern int tg_percussion;

// reverb intensity
extern int tg_reverb;

// all sound off
extern void tg_panic( void );


#endif
