/*
 * Decompiled with CFR 0.152.
 */
package org.commonjukebox.plugins.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.commonjukebox.plugins.model.PluginFolder;
import org.commonjukebox.plugins.model.PluginInfo;

public class PluginRepositoryInformation {
    private Map<String, PluginFolder> pluginFolders;

    public Map<String, PluginFolder> getPluginFolders() {
        if (this.pluginFolders == null) {
            this.pluginFolders = new HashMap<String, PluginFolder>();
        }
        return this.pluginFolders;
    }

    public void addPluginFolder(PluginFolder pluginFolder) {
        this.getPluginFolders().put(this.getKey(pluginFolder), pluginFolder);
    }

    public void removePluginFolder(PluginFolder pluginFolder) {
        this.getPluginFolders().remove(this.getKey(pluginFolder));
    }

    public boolean containsPluginFolder(PluginFolder pluginFolder) {
        return this.getPluginFolders().containsKey(this.getKey(pluginFolder));
    }

    private String getKey(PluginFolder pluginFolder) {
        return pluginFolder != null ? pluginFolder.getName() : null;
    }

    public List<String> getPluginNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (PluginFolder pluginFolder : this.getPluginFolders().values()) {
            PluginInfo pluginInfo = pluginFolder.getPluginInfo();
            if (pluginInfo == null) continue;
            names.add(pluginInfo.getName());
        }
        return names;
    }

    public List<PluginFolder> differenceWith(PluginRepositoryInformation pluginRepositoryInformation) {
        ArrayList<PluginFolder> difference = new ArrayList<PluginFolder>();
        for (PluginFolder pluginFolder : this.getPluginFolders().values()) {
            if (pluginRepositoryInformation.containsPluginFolder(pluginFolder)) continue;
            difference.add(pluginFolder);
        }
        return difference;
    }

    public int getPluginsNumber() {
        return this.getPluginFolders().size();
    }

    public List<PluginInfo> getPlugins() {
        ArrayList<PluginInfo> plugins = new ArrayList<PluginInfo>();
        for (PluginFolder pluginFolder : this.getPluginFolders().values()) {
            PluginInfo pluginInfo = pluginFolder.getPluginInfo();
            if (pluginInfo == null) continue;
            plugins.add(pluginInfo);
        }
        return plugins;
    }

    public PluginInfo getPluginByName(String pluginName) {
        for (PluginFolder pluginFolder : this.getPluginFolders().values()) {
            PluginInfo pluginInfo = pluginFolder.getPluginInfo();
            if (pluginInfo == null || !pluginInfo.getName().equalsIgnoreCase(pluginName)) continue;
            return pluginInfo;
        }
        return null;
    }

    public void setPluginsInfoFrom(PluginRepositoryInformation pluginRepositoryInformation) {
        for (PluginFolder pluginFolder : pluginRepositoryInformation.getPluginFolders().values()) {
            PluginFolder pluginFolder2;
            PluginInfo pluginInfo1 = pluginFolder.getPluginInfo();
            if (pluginInfo1 == null || (pluginFolder2 = this.getPluginFolders().get(this.getKey(pluginInfo1.getPluginFolder()))) == null) continue;
            pluginFolder2.setPluginInfo(pluginInfo1);
        }
    }
}

